/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MongoUtil {
    public static Object getDBOValue(DBObject dbo, String path) {
        return MongoUtil.getDBOValue(dbo, Arrays.asList(path.split("\\.")).iterator());
    }

    public static Object getDBOValue(DBObject dbo, Iterator<String> path) {
        return MongoUtil.getDBOValueInternal(path, dbo);
    }

    private static Object getDBOValueInternal(Iterator<String> path, Object current) {
        if (path.hasNext()) {
            if (current instanceof DBObject) {
                String key = path.next();
                if (current instanceof BasicDBList) {
                    try {
                        Integer.parseInt(key);
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
                Object value = ((DBObject)current).get(key);
                return MongoUtil.getDBOValueInternal(path, value);
            }
            return null;
        }
        return current;
    }

    public static void setDBOValue(DBObject dbo, String path, Object value) {
        MongoUtil.setDBOValue(dbo, Arrays.asList(path.split("\\.")).iterator(), value);
    }

    public static void setDBOValue(DBObject dbo, Iterator<String> path, Object value) {
        MongoUtil.setDBOValueInternal(dbo, path, value);
    }

    private static void setDBOValueInternal(DBObject currentDBO, Iterator<String> path, Object value) {
        String key = path.next();
        if (path.hasNext()) {
            DBObject nextDBO;
            Object next = currentDBO.get(key);
            if (next instanceof DBObject) {
                nextDBO = (DBObject)next;
            } else {
                nextDBO = new BasicDBObject();
                currentDBO.put(key, (Object)nextDBO);
            }
            MongoUtil.setDBOValueInternal(nextDBO, path, value);
        } else {
            currentDBO.put(key, value);
        }
    }

    public static Set<String> findIndexedGeometries(DBCollection dbc) {
        return MongoUtil.findIndexedFields(dbc, "2dsphere");
    }

    public static Set<String> findIndexedFields(DBCollection dbc) {
        return MongoUtil.findIndexedFields(dbc, null);
    }

    public static Set<String> findIndexedFields(DBCollection dbc, String type) {
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        List indices = dbc.getIndexInfo();
        for (DBObject index : indices) {
            Object key = index.get("key");
            if (!(key instanceof DBObject)) continue;
            for (Map.Entry entry : ((DBObject)key).toMap().entrySet()) {
                if (type != null && !type.equals(entry.getValue())) continue;
                fields.add(entry.getKey().toString());
            }
        }
        fields.remove("_id");
        return fields;
    }

    public static Map<String, Class<?>> findMappableFields(DBCollection dbc) {
        return MongoUtil.findMappableFields(dbc.findOne());
    }

    public static Map<String, Class<?>> findMappableFields(DBObject dbo) {
        if (dbo == null) {
            return Collections.emptyMap();
        }
        Map<String, Class<?>> map = MongoUtil.doFindMappableFields(dbo);
        map.remove("_id");
        return map;
    }

    private static Map<String, Class<?>> doFindMappableFields(DBObject dbo) {
        if (dbo == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap map = new LinkedHashMap();
        for (Map.Entry e : dbo.toMap().entrySet()) {
            Class<?> binding;
            Object k = e.getKey();
            if (!(k instanceof String)) continue;
            String field = (String)k;
            Object v = e.getValue();
            if (v instanceof DBObject) {
                if (v instanceof BasicDBList) continue;
                for (Map.Entry<String, Class<?>> childEntry : MongoUtil.doFindMappableFields((DBObject)v).entrySet()) {
                    map.put(field + "." + childEntry.getKey(), childEntry.getValue());
                }
                continue;
            }
            if (v instanceof List || (binding = MongoUtil.mapBSONObjectToJavaType(v)) == null) continue;
            map.put(field, binding);
        }
        return map;
    }

    public static Class<?> mapBSONObjectToJavaType(Object o) {
        if (o instanceof String || o instanceof Double || o instanceof Long || o instanceof Integer || o instanceof Boolean || o instanceof Date) {
            return o.getClass();
        }
        return null;
    }
}

