/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.geotools.data.mongodb.FeatureTypeDBObject;
import org.geotools.data.mongodb.MongoSchemaStore;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;

public class MongoSchemaDBStore
implements MongoSchemaStore {
    static final String DEFAULT_databaseName = "geotools";
    static final String DEFAULT_collectionName = "schemas";
    final MongoClient client;
    final DBCollection collection;

    public MongoSchemaDBStore(String uri) throws IOException {
        this(new MongoClientURI(uri));
    }

    public MongoSchemaDBStore(MongoClientURI uri) throws IOException {
        this.client = new MongoClient(uri);
        String databaseName = uri.getDatabase();
        if (databaseName == null) {
            databaseName = DEFAULT_databaseName;
        }
        DB database = this.client.getDB(databaseName);
        String collectionName = uri.getCollection();
        if (collectionName == null) {
            collectionName = DEFAULT_collectionName;
        }
        this.collection = database.getCollection(collectionName);
        this.collection.ensureIndex((DBObject)new BasicDBObject("typeName", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
    }

    @Override
    public void storeSchema(SimpleFeatureType schema) throws IOException {
        String typeName;
        if (schema != null && (typeName = schema.getTypeName()) != null) {
            this.collection.update((DBObject)new BasicDBObject("typeName", (Object)schema.getTypeName()), FeatureTypeDBObject.convert(schema), true, false);
        }
    }

    @Override
    public SimpleFeatureType retrieveSchema(Name name) throws IOException {
        if (name == null) {
            return null;
        }
        String typeName = name.getLocalPart();
        if (typeName == null) {
            return null;
        }
        DBObject document = this.collection.findOne((DBObject)new BasicDBObject("typeName", (Object)typeName));
        SimpleFeatureType featureType = null;
        if (document != null) {
            try {
                featureType = FeatureTypeDBObject.convert(document, name);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        return featureType;
    }

    @Override
    public void deleteSchema(Name name) throws IOException {
        if (name == null) {
            return;
        }
        String typeName = name.getLocalPart();
        if (typeName == null) {
            return;
        }
        this.collection.remove((DBObject)new BasicDBObject("typeName", (Object)typeName));
    }

    @Override
    public List<String> typeNames() {
        DBCursor cursor = this.collection.find((DBObject)new BasicDBObject(), (DBObject)new BasicDBObject("typeName", (Object)1));
        ArrayList<String> typeNames = new ArrayList<String>(cursor.count());
        while (cursor.hasNext()) {
            Object typeName;
            DBObject document = cursor.next();
            if (document == null || !((typeName = document.get("typeName")) instanceof String)) continue;
            typeNames.add((String)typeName);
        }
        return typeNames;
    }

    @Override
    public void close() {
        this.client.close();
    }
}

