/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.mongodb.AbstractCollectionMapper;
import org.geotools.data.mongodb.MongoGeometryBuilder;
import org.geotools.data.mongodb.MongoUtil;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MongoInferredMapper
extends AbstractCollectionMapper {
    public static final Logger LOG = Logging.getLogger(MongoInferredMapper.class);
    MongoGeometryBuilder geomBuilder = new MongoGeometryBuilder();
    SimpleFeatureType schema;

    @Override
    public String getGeometryPath() {
        String gdName = this.schema.getGeometryDescriptor().getLocalName();
        return (String)this.schema.getDescriptor(gdName).getUserData().get("mapping");
    }

    @Override
    public String getPropertyPath(String property) {
        AttributeDescriptor descriptor = this.schema.getDescriptor(property);
        return descriptor == null ? null : (String)descriptor.getUserData().get("mapping");
    }

    @Override
    public Geometry getGeometry(DBObject dbo) {
        Object o = MongoUtil.getDBOValue(dbo, this.getGeometryPath());
        return o == null ? null : this.geomBuilder.toGeometry((DBObject)o);
    }

    @Override
    public DBObject toObject(Geometry g) {
        return this.geomBuilder.toObject(g);
    }

    @Override
    public void setGeometry(DBObject dbo, Geometry g) {
        MongoUtil.setDBOValue(dbo, this.getGeometryPath(), (Object)this.toObject(g));
    }

    @Override
    public SimpleFeatureType buildFeatureType(Name name, DBCollection collection) {
        Set<String> indexedGeometries = MongoUtil.findIndexedGeometries(collection);
        Set<String> indexedFields = MongoUtil.findIndexedFields(collection);
        Map<String, Class<?>> mappedFields = MongoUtil.findMappableFields(collection);
        indexedFields.removeAll(mappedFields.keySet());
        indexedFields.removeAll(indexedGeometries);
        block0: for (String mappedProperty : new ArrayList<String>(mappedFields.keySet())) {
            for (String indexedGeometry : indexedGeometries) {
                if (!mappedProperty.startsWith(indexedGeometry)) continue;
                mappedFields.remove(mappedProperty);
                continue block0;
            }
        }
        DBObject dbo = collection.findOne();
        if (dbo != null) {
            Iterator<String> indexedIterator = indexedFields.iterator();
            while (indexedIterator.hasNext()) {
                Object value = MongoUtil.getDBOValue(dbo, indexedIterator.next());
                if (value != null) continue;
                indexedIterator.remove();
            }
        }
        SimpleFeatureTypeBuilder ftBuilder = new SimpleFeatureTypeBuilder();
        ftBuilder.setName(name);
        String geometryField = indexedGeometries.iterator().next();
        if (indexedGeometries.size() > 1) {
            LOG.log(Level.WARNING, "More than one indexed geometry field found for type {0}, selecting {1} (first one encountered with index search of collection {2})", new Object[]{name, geometryField, collection.getFullName()});
        }
        ftBuilder.userData("mapping", geometryField);
        ftBuilder.userData("encoding", "GeoJSON");
        ftBuilder.add(geometryField, Geometry.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        LOG.log(Level.INFO, "building type {0}: mapping geometry field {1} from collection {2}", new Object[]{name, geometryField, collection.getFullName()});
        for (Map.Entry<String, Class<?>> mappedField : mappedFields.entrySet()) {
            String field = mappedField.getKey();
            Class<?> binding = mappedField.getValue();
            ftBuilder.userData("mapping", field);
            ftBuilder.add(field, binding);
            LOG.log(Level.INFO, "building type \"{0}\": mapping field \"{1}\" with binding {2} from collection {3}", new Object[]{name, field, binding.getName(), collection.getFullName()});
        }
        for (String field : indexedFields) {
            ftBuilder.userData("mapping", field);
            ftBuilder.add(field, String.class);
            LOG.log(Level.INFO, "building type \"{0}\": mapping indexed field \"{1}\" with default binding, {2}, from collection {3}", new Object[]{name, field, String.class.getName(), collection.getFullName()});
        }
        SimpleFeatureType featureType = ftBuilder.buildFeatureType();
        featureType.getUserData().put("collection", collection.getName());
        this.schema = featureType;
        return featureType;
    }
}

