/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.List;
import org.geotools.geometry.jts.Geometries;

public class MongoGeometryBuilder {
    GeometryFactory geometryFactory;
    boolean opportunisticMultiGeometryCoversion = true;

    public MongoGeometryBuilder() {
        this(new GeometryFactory());
    }

    public MongoGeometryBuilder(GeometryFactory geomFactory) {
        this.geometryFactory = geomFactory;
    }

    public Geometry toGeometry(DBObject obj) {
        if (obj == null) {
            return null;
        }
        String type = (String)obj.get("type");
        Geometries g = Geometries.getForName(type);
        if (g == null) {
            throw new IllegalArgumentException("Unable to create geometry of type: " + type);
        }
        BasicDBList list = (BasicDBList)obj.get("coordinates");
        switch (g) {
            case POINT: {
                return this.toPoint((List<?>)list);
            }
            case LINESTRING: {
                return this.toLineString((List<?>)list);
            }
            case POLYGON: {
                return this.toPolygon((List<?>)list);
            }
            case MULTIPOINT: {
                return this.toMultiPoint((List<?>)list);
            }
            case MULTILINESTRING: {
                return this.toMultiLineString((List<?>)list);
            }
            case MULTIPOLYGON: {
                return this.toMultiPolygon((List<?>)list);
            }
            case GEOMETRYCOLLECTION: {
                return this.toGeometryCollection((BasicDBList)obj.get("geometries"));
            }
        }
        throw new IllegalArgumentException("Unknown geometry type: " + type);
    }

    public DBObject toObject(Envelope envelope) {
        return this.toObject(this.geometryFactory.toGeometry(envelope));
    }

    public DBObject toObject(Geometry geom) {
        Geometries g = Geometries.get(geom);
        switch (g) {
            case POINT: {
                return this.toObject((Point)geom);
            }
            case LINESTRING: {
                return this.toObject((LineString)geom);
            }
            case POLYGON: {
                return this.toObject((Polygon)geom);
            }
            case MULTIPOINT: {
                return this.toObject((MultiPoint)geom);
            }
            case MULTILINESTRING: {
                return this.toObject((MultiLineString)geom);
            }
            case MULTIPOLYGON: {
                return this.toObject((MultiPolygon)geom);
            }
            case GEOMETRYCOLLECTION: {
                return this.toObject((GeometryCollection)geom);
            }
        }
        throw new IllegalArgumentException("Unknown geometry type: " + geom);
    }

    public GeometryCollection toGeometryCollection(BasicDBList obj) {
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        for (Object o : obj) {
            geoms.add(this.toGeometry((DBObject)o));
        }
        return this.geometryFactory.createGeometryCollection(geoms.toArray(new Geometry[geoms.size()]));
    }

    public DBObject toObject(GeometryCollection gc) {
        return null;
    }

    public MultiPolygon toMultiPolygon(List<?> list) {
        ArrayList<Polygon> polys = new ArrayList<Polygon>();
        for (Object o : list) {
            polys.add(this.toPolygon((List)o));
        }
        return this.geometryFactory.createMultiPolygon(polys.toArray(new Polygon[polys.size()]));
    }

    public DBObject toObject(MultiPolygon mp) {
        if (this.opportunisticMultiGeometryCoversion && mp.getNumGeometries() == 1) {
            return this.toObject((Polygon)mp.getGeometryN(0));
        }
        BasicDBList l = new BasicDBList();
        for (int i = 0; i < mp.getNumGeometries(); ++i) {
            l.add(this.toList((Polygon)mp.getGeometryN(i)));
        }
        return BasicDBObjectBuilder.start().add("type", (Object)"MultiPolygon").add("coordinates", (Object)l).get();
    }

    public MultiLineString toMultiLineString(List<?> list) {
        ArrayList<LineString> lines = new ArrayList<LineString>();
        for (Object o : list) {
            lines.add(this.toLineString((List)o));
        }
        return this.geometryFactory.createMultiLineString(lines.toArray(new LineString[lines.size()]));
    }

    public DBObject toObject(MultiLineString ml) {
        if (this.opportunisticMultiGeometryCoversion && ml.getNumGeometries() == 1) {
            return this.toObject((LineString)ml.getGeometryN(0));
        }
        BasicDBList l = new BasicDBList();
        for (int i = 0; i < ml.getNumGeometries(); ++i) {
            l.add(this.toList(((LineString)ml.getGeometryN(i)).getCoordinateSequence()));
        }
        return BasicDBObjectBuilder.start().add("type", (Object)"MultiLineString").add("coordinates", (Object)l).get();
    }

    public MultiPoint toMultiPoint(List<?> list) {
        ArrayList<Point> points = new ArrayList<Point>();
        for (Object o : list) {
            points.add(this.toPoint((List)o));
        }
        return this.geometryFactory.createMultiPoint(points.toArray(new Point[points.size()]));
    }

    public DBObject toObject(MultiPoint mp) {
        if (this.opportunisticMultiGeometryCoversion && mp.getNumGeometries() == 1) {
            return this.toObject((Point)mp.getGeometryN(0));
        }
        return BasicDBObjectBuilder.start().add("type", (Object)"MultiPoint").add("coordinates", this.toList(mp.getCoordinates())).get();
    }

    public Polygon toPolygon(List<?> list) {
        LinearRing outer = (LinearRing)this.toLineString((List)list.get(0));
        ArrayList<LinearRing> inner = new ArrayList<LinearRing>();
        for (int i = 1; i < list.size(); ++i) {
            inner.add((LinearRing)this.toLineString((List)list.get(i)));
        }
        return this.geometryFactory.createPolygon(outer, inner.toArray(new LinearRing[inner.size()]));
    }

    public DBObject toObject(Polygon p) {
        return BasicDBObjectBuilder.start().add("type", (Object)"Polygon").add("coordinates", this.toList(p)).get();
    }

    public LineString toLineString(List<?> list) {
        ArrayList<Coordinate> coordList = new ArrayList<Coordinate>(list.size());
        for (Object o : list) {
            coordList.add(this.toCoordinate((List)o));
        }
        Coordinate[] coords = coordList.toArray(new Coordinate[coordList.size()]);
        if (coords.length > 3 && coords[0].equals(coords[coords.length - 1])) {
            return this.geometryFactory.createLinearRing(coords);
        }
        return this.geometryFactory.createLineString(coords);
    }

    public DBObject toObject(LineString l) {
        return BasicDBObjectBuilder.start().add("type", (Object)"LineString").add("coordinates", this.toList(l.getCoordinateSequence())).get();
    }

    public Point toPoint(List<?> list) {
        return this.geometryFactory.createPoint(this.toCoordinate(list));
    }

    public DBObject toObject(Point p) {
        return BasicDBObjectBuilder.start().add("type", (Object)"Point").add("coordinates", this.toList(p.getCoordinate())).get();
    }

    public Coordinate toCoordinate(List<?> list) {
        double x = ((Number)list.get(0)).doubleValue();
        double y = ((Number)list.get(1)).doubleValue();
        return new Coordinate(x, y);
    }

    List<?> toList(Coordinate c) {
        BasicDBList l = new BasicDBList();
        l.add((Object)c.x);
        l.add((Object)c.y);
        return l;
    }

    List<?> toList(CoordinateSequence cs) {
        BasicDBList l = new BasicDBList();
        for (int i = 0; i < cs.size(); ++i) {
            BasicDBList m = new BasicDBList();
            m.add((Object)cs.getX(i));
            m.add((Object)cs.getY(i));
            l.add((Object)m);
        }
        return l;
    }

    List<?> toList(Coordinate[] cs) {
        BasicDBList l = new BasicDBList();
        for (int i = 0; i < cs.length; ++i) {
            BasicDBList m = new BasicDBList();
            m.add((Object)cs[i].x);
            m.add((Object)cs[i].y);
            l.add((Object)m);
        }
        return l;
    }

    List<?> toList(Polygon p) {
        BasicDBList l = new BasicDBList();
        l.add(this.toList(p.getExteriorRing().getCoordinateSequence()));
        for (int i = 0; i < p.getNumInteriorRing(); ++i) {
            l.add(this.toList(p.getInteriorRingN(i).getCoordinateSequence()));
        }
        return l;
    }
}

