/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import com.mongodb.DBCollection;
import java.io.IOException;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.mongodb.CollectionMapper;
import org.geotools.data.mongodb.MongoDataStore;
import org.geotools.data.mongodb.MongoFeatureSource;
import org.geotools.data.mongodb.MongoFeatureWriter;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureStore;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class MongoFeatureStore
extends ContentFeatureStore {
    MongoFeatureSource delegate;

    public MongoFeatureStore(ContentEntry entry, Query query, DBCollection collection) {
        super(entry, query);
        this.delegate = new MongoFeatureSource(entry, query, collection);
    }

    public MongoDataStore getDataStore() {
        return (MongoDataStore)super.getDataStore();
    }

    public CollectionMapper getMapper() {
        return this.delegate.getMapper();
    }

    public void setMapper(CollectionMapper mapper) {
        this.delegate.setMapper(mapper);
    }

    protected SimpleFeatureType buildFeatureType() throws IOException {
        return this.delegate.buildFeatureType();
    }

    protected int getCountInternal(Query query) throws IOException {
        return this.delegate.getCountInternal(query);
    }

    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        return this.delegate.getBoundsInternal(query);
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        return this.delegate.getReaderInternal(query);
    }

    protected boolean canOffset() {
        return this.delegate.canOffset();
    }

    protected boolean canLimit() {
        return this.delegate.canLimit();
    }

    protected boolean canRetype() {
        return this.delegate.canRetype();
    }

    protected boolean canSort() {
        return this.delegate.canSort();
    }

    protected boolean canFilter() {
        return this.delegate.canFilter();
    }

    protected FeatureWriter<SimpleFeatureType, SimpleFeature> getWriterInternal(Query query, int flags) throws IOException {
        if ((flags & 7) != 0) {
            return new MongoFeatureWriter(this.delegate.getCollection(), this.getSchema(), this);
        }
        return null;
    }
}

