/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.Query;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.mongodb.CollectionMapper;
import org.geotools.data.mongodb.FilterToMongo;
import org.geotools.data.mongodb.MongoDataStore;
import org.geotools.data.mongodb.MongoFeatureReader;
import org.geotools.data.mongodb.MongoInferredMapper;
import org.geotools.data.mongodb.MongoSchemaMapper;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.visitor.PostPreProcessFilterSplittingVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortOrder;

public class MongoFeatureSource
extends ContentFeatureSource {
    static Logger LOG = Logging.getLogger((String)"org.geotools.data.mongodb");
    final DBCollection collection;
    CollectionMapper mapper;

    public MongoFeatureSource(ContentEntry entry, Query query, DBCollection collection) {
        super(entry, query);
        this.collection = collection;
        this.initMapper();
    }

    final void initMapper() {
        SimpleFeatureType type = this.entry.getState(null).getFeatureType();
        this.setMapper(type != null ? new MongoSchemaMapper(type) : new MongoInferredMapper());
    }

    public DBCollection getCollection() {
        return this.collection;
    }

    public CollectionMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(CollectionMapper mapper) {
        this.mapper = mapper;
    }

    protected SimpleFeatureType buildFeatureType() throws IOException {
        SimpleFeatureType type = this.mapper.buildFeatureType(this.entry.getName(), this.collection);
        this.getDataStore().getSchemaStore().storeSchema(type);
        return type;
    }

    public MongoDataStore getDataStore() {
        return (MongoDataStore)super.getDataStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        try (FeatureReader r = this.getReader(query);){
            ReferencedEnvelope e = new ReferencedEnvelope();
            if (r.hasNext()) {
                e.init(((SimpleFeature)r.next()).getBounds());
            }
            while (r.hasNext()) {
                e.include(((SimpleFeature)r.next()).getBounds());
            }
            ReferencedEnvelope referencedEnvelope = e;
            return referencedEnvelope;
        }
    }

    protected int getCountInternal(Query query) throws IOException {
        Filter f = query.getFilter();
        if (this.isAll(f)) {
            LOG.fine("count(all)");
            return (int)this.collection.count();
        }
        Filter[] split = this.splitFilter(f);
        if (!this.isAll(split[1])) {
            return -1;
        }
        DBObject q = this.toQuery(f);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("count(" + q + ")");
        }
        return (int)this.collection.count(q);
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        ArrayList<Filter> postFilterList = new ArrayList<Filter>();
        ArrayList<String> postFilterAttributes = new ArrayList<String>();
        DBCursor cursor = this.toCursor(query, postFilterList, postFilterAttributes);
        FeatureReader<SimpleFeatureType, SimpleFeature> r = new MongoFeatureReader(cursor, this);
        if (!postFilterList.isEmpty() && !this.isAll((Filter)postFilterList.get(0))) {
            r = new FilteringFeatureReader<SimpleFeatureType, SimpleFeature>(r, (Filter)postFilterList.get(0));
            if (!postFilterAttributes.isEmpty()) {
                SimpleFeatureType returnedSchema = SimpleFeatureTypeBuilder.retype(this.getSchema(), query.getPropertyNames());
                r = new ReTypeFeatureReader(r, returnedSchema);
            }
        }
        return r;
    }

    protected boolean canOffset() {
        return true;
    }

    protected boolean canLimit() {
        return true;
    }

    protected boolean canRetype() {
        return true;
    }

    protected boolean canSort() {
        return true;
    }

    protected boolean canFilter() {
        return true;
    }

    DBCursor toCursor(Query q, List<Filter> postFilter, List<String> postFilterAttrs) {
        DBCursor c;
        BasicDBObject query = new BasicDBObject();
        Filter f = q.getFilter();
        if (!this.isAll(f)) {
            Filter[] split = this.splitFilter(f);
            query = this.toQuery(split[0]);
            if (!this.isAll(split[1])) {
                postFilter.add(split[1]);
            }
        }
        if (q.getPropertyNames() != Query.ALL_NAMES) {
            BasicDBObject keys = new BasicDBObject();
            for (String string : q.getPropertyNames()) {
                keys.put(this.mapper.getPropertyPath(string), (Object)1);
            }
            for (Filter filter : postFilter) {
                String[] attributeNames;
                for (String attrName : attributeNames = DataUtilities.attributeNames(filter)) {
                    if (attrName == null || attrName.isEmpty() || keys.containsField(attrName)) continue;
                    keys.put(this.mapper.getPropertyPath(attrName), (Object)1);
                    postFilterAttrs.add(attrName);
                }
            }
            if (!keys.containsField(this.mapper.getGeometryPath())) {
                keys.put(this.mapper.getGeometryPath(), (Object)1);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("find(%s, %s)", query, keys));
            }
            c = this.collection.find((DBObject)query, (DBObject)keys);
        } else {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("find(%s)", query));
            }
            c = this.collection.find((DBObject)query);
        }
        if (q.getStartIndex() != null && q.getStartIndex() != 0) {
            c = c.skip(q.getStartIndex().intValue());
        }
        if (q.getMaxFeatures() != Integer.MAX_VALUE) {
            c = c.limit(q.getMaxFeatures());
        }
        if (q.getSortBy() != null) {
            BasicDBObject orderBy = new BasicDBObject();
            for (String string : q.getSortBy()) {
                String propName = string.getPropertyName().getPropertyName();
                orderBy.append(propName, (Object)(string.getSortOrder() == SortOrder.ASCENDING ? 1 : -1));
            }
            c = c.sort((DBObject)orderBy);
        }
        return c;
    }

    DBObject toQuery(Filter f) {
        if (this.isAll(f)) {
            return new BasicDBObject();
        }
        FilterToMongo v = new FilterToMongo(this.mapper);
        v.setFeatureType(this.getSchema());
        return (DBObject)f.accept((FilterVisitor)v, null);
    }

    boolean isAll(Filter f) {
        return f == null || f == Filter.INCLUDE;
    }

    Filter[] splitFilter(Filter f) {
        PostPreProcessFilterSplittingVisitor splitter = new PostPreProcessFilterSplittingVisitor(this.getDataStore().getFilterCapabilities(), null, null){

            @Override
            public Object visit(PropertyIsLike filter, Object notUsed) {
                if (this.original == null) {
                    this.original = filter;
                }
                if (!this.fcs.supports(PropertyIsLike.class)) {
                    this.postStack.push(filter);
                    return null;
                }
                if (!(filter.getExpression() instanceof PropertyName)) {
                    this.postStack.push(filter);
                    return null;
                }
                int i = this.postStack.size();
                filter.getExpression().accept((ExpressionVisitor)this, null);
                if (i < this.postStack.size()) {
                    this.postStack.pop();
                    this.postStack.push(filter);
                    return null;
                }
                this.preStack.pop();
                this.preStack.push(filter);
                return null;
            }
        };
        f.accept((FilterVisitor)splitter, null);
        return new Filter[]{splitter.getFilterPre(), splitter.getFilterPost()};
    }
}

