/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.mongodb.CollectionMapper;
import org.geotools.data.mongodb.MongoFeatureSource;
import org.geotools.data.simple.SimpleFeatureReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class MongoFeatureReader
implements SimpleFeatureReader {
    DBCursor cursor;
    MongoFeatureSource featureSource;
    CollectionMapper mapper;

    public MongoFeatureReader(DBCursor cursor, MongoFeatureSource featureSource) {
        this.cursor = cursor;
        this.featureSource = featureSource;
        this.mapper = featureSource.getMapper();
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        return this.featureSource.getSchema();
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.cursor.hasNext();
    }

    @Override
    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        DBObject obj = this.cursor.next();
        return this.mapper.buildFeature(obj, this.featureSource.getSchema());
    }

    @Override
    public void close() throws IOException {
        this.cursor.close();
    }
}

