/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.geotools.data.AbstractDataStoreFactory;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.mongodb.MongoDataStore;

public class MongoDataStoreFactory
extends AbstractDataStoreFactory {
    public static final DataAccessFactory.Param NAMESPACE = new DataAccessFactory.Param("namespace", String.class, "Namespace prefix", false);
    public static final DataAccessFactory.Param DATASTORE_URI = new DataAccessFactory.Param("data_store", String.class, "MongoDB URI", true, (Object)"mongodb://localhost/<database name>");
    public static final DataAccessFactory.Param SCHEMASTORE_URI = new DataAccessFactory.Param("schema_store", String.class, "Schema Store URI", true, (Object)"file://<absolute path>");

    @Override
    public String getDisplayName() {
        return "MongoDB";
    }

    @Override
    public String getDescription() {
        return "MongoDB database";
    }

    @Override
    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{NAMESPACE, DATASTORE_URI, SCHEMASTORE_URI};
    }

    public MongoDataStore createDataStore(Map<String, Serializable> params) throws IOException {
        MongoDataStore dataStore = new MongoDataStore((String)DATASTORE_URI.lookUp(params), (String)SCHEMASTORE_URI.lookUp(params));
        String uri = (String)NAMESPACE.lookUp(params);
        if (uri != null) {
            dataStore.setNamespaceURI(uri);
        }
        return dataStore;
    }

    @Override
    public DataStore createNewDataStore(Map<String, Serializable> params) throws IOException {
        throw new UnsupportedOperationException();
    }
}

