/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.vividsolutions.jts.geom.Geometry;
import org.geotools.data.mongodb.AbstractCollectionMapper;
import org.geotools.data.mongodb.MongoGeometryBuilder;
import org.geotools.data.mongodb.MongoUtil;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeoJSONMapper
extends AbstractCollectionMapper {
    MongoGeometryBuilder geomBuilder = new MongoGeometryBuilder();

    @Override
    public String getGeometryPath() {
        return "geometry";
    }

    @Override
    public String getPropertyPath(String property) {
        return "properties." + property;
    }

    @Override
    public Geometry getGeometry(DBObject obj) {
        return this.geomBuilder.toGeometry((DBObject)obj.get("geometry"));
    }

    @Override
    public DBObject toObject(Geometry g) {
        return this.geomBuilder.toObject(g);
    }

    @Override
    public void setGeometry(DBObject obj, Geometry g) {
        obj.put("geometry", (Object)this.toObject(g));
    }

    @Override
    public SimpleFeatureType buildFeatureType(Name name, DBCollection collection) {
        SimpleFeatureTypeBuilder ftBuilder = new SimpleFeatureTypeBuilder();
        ftBuilder.setName(name);
        ftBuilder.userData("mapping", "geometry");
        ftBuilder.userData("encoding", "GeoJSON");
        ftBuilder.add("geometry", Geometry.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        DBObject rootDBO = collection.findOne();
        if (rootDBO != null && rootDBO.containsField("properties")) {
            DBObject propertiesDBO = (DBObject)rootDBO.get("properties");
            for (String key : propertiesDBO.keySet()) {
                Object v = propertiesDBO.get(key);
                Class<?> binding = MongoUtil.mapBSONObjectToJavaType(v);
                if (binding != null) {
                    ftBuilder.userData("mapping", "properties." + key);
                    ftBuilder.add(key, binding);
                    continue;
                }
                System.err.println("unmapped key, " + key + " with type of " + v.getClass().getName());
            }
        }
        SimpleFeatureType ft = ftBuilder.buildFeatureType();
        ft.getUserData().put("collection", ft.getTypeName());
        return ft;
    }
}

