/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.bson.types.ObjectId;
import org.geotools.data.mongodb.CollectionMapper;
import org.geotools.data.mongodb.MongoGeometryBuilder;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.identity.Identifier;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.AnyInteracts;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.Meets;
import org.opengis.filter.temporal.MetBy;
import org.opengis.filter.temporal.OverlappedBy;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;

public class FilterToMongo
implements FilterVisitor,
ExpressionVisitor {
    private static final Logger LOGGER = Logging.getLogger(FilterToMongo.class);
    static final SimpleDateFormat ISO8601_SDF = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    final CollectionMapper mapper;
    final MongoGeometryBuilder geometryBuilder;
    SimpleFeatureType featureType;

    public FilterToMongo(CollectionMapper mapper) {
        this(mapper, new MongoGeometryBuilder());
    }

    public FilterToMongo(CollectionMapper mapper, MongoGeometryBuilder geometryBuilder) {
        this.mapper = mapper;
        this.geometryBuilder = geometryBuilder;
    }

    protected BasicDBObject asDBObject(Object extraData) {
        if (extraData != null || extraData instanceof BasicDBObject) {
            return (BasicDBObject)extraData;
        }
        return new BasicDBObject();
    }

    public void setFeatureType(SimpleFeatureType featureType) {
        this.featureType = featureType;
    }

    public Object visit(Literal expression, Object extraData) {
        Class targetType = null;
        if (extraData != null && extraData instanceof Class) {
            targetType = (Class)extraData;
        }
        return this.encodeLiteral(expression.getValue(), targetType);
    }

    public Object visit(PropertyName expression, Object extraData) {
        String prop = expression.getPropertyName();
        if (extraData == Geometry.class) {
            return this.mapper.getGeometryPath();
        }
        return this.mapper.getPropertyPath(prop);
    }

    public Object visit(ExcludeFilter filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        output.put("foo", (Object)"not_likely_to_exist");
        return output;
    }

    public Object visit(IncludeFilter filter, Object extraData) {
        return new BasicDBObject();
    }

    public Object visit(And filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        List children = filter.getChildren();
        if (children != null) {
            for (Filter child : children) {
                child.accept((FilterVisitor)this, (Object)output);
            }
        }
        return output;
    }

    public Object visit(Or filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        List children = filter.getChildren();
        BasicDBList orList = new BasicDBList();
        if (children != null) {
            for (Filter child : children) {
                BasicDBObject item = (BasicDBObject)child.accept((FilterVisitor)this, null);
                orList.add((Object)item);
            }
            output.put("$or", (Object)orList);
        }
        return output;
    }

    public Object visit(Not filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        BasicDBObject expr = (BasicDBObject)filter.getFilter().accept((FilterVisitor)this, null);
        output.put("$not", (Object)expr);
        return output;
    }

    public Object visit(PropertyIsBetween filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        String propName = Converters.convert(filter.getExpression().accept((ExpressionVisitor)this, null), String.class);
        Object lower = filter.getLowerBoundary().accept((ExpressionVisitor)this, this.getValueType(filter.getExpression()));
        Object upper = filter.getUpperBoundary().accept((ExpressionVisitor)this, this.getValueType(filter.getExpression()));
        BasicDBObject dbo = new BasicDBObject();
        dbo.put("$gte", lower);
        dbo.put("$lte", upper);
        output.put(propName, (Object)dbo);
        return output;
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        return this.encodeBinaryComparisonOp((BinaryComparisonOperator)filter, null, extraData);
    }

    BasicDBObject encodeBinaryComparisonOp(BinaryComparisonOperator filter, String op, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        Expression left = filter.getExpression1();
        Expression right = filter.getExpression2();
        Class<?> leftValueType = this.getValueType(right);
        Class<?> rightValueType = this.getValueType(left);
        Object leftValue = filter.getExpression1().accept((ExpressionVisitor)this, leftValueType);
        Object rightValue = filter.getExpression2().accept((ExpressionVisitor)this, rightValueType);
        if (rightValue instanceof String && !(leftValue instanceof String)) {
            Object tmp = leftValue;
            leftValue = rightValue;
            rightValue = tmp;
        }
        output.put((String)leftValue, op == null ? rightValue : new BasicDBObject(op, rightValue));
        return output;
    }

    private Class<?> getValueType(Expression e) {
        Class ret;
        Class valueType = null;
        if (e instanceof PropertyName && this.featureType != null) {
            AttributeDescriptor attType = (AttributeDescriptor)e.evaluate((Object)this.featureType);
            if (attType != null) {
                valueType = attType.getType().getBinding();
            }
        } else if (e instanceof Function && (ret = this.getFunctionReturnType((Function)e)) != null) {
            valueType = ret;
        }
        return valueType;
    }

    private Class<?> getFunctionReturnType(Function f) {
        Class clazz = Object.class;
        if (f.getFunctionName() != null && f.getFunctionName().getReturn() != null) {
            clazz = f.getFunctionName().getReturn().getType();
        }
        if (clazz == Object.class) {
            clazz = null;
        }
        return clazz;
    }

    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        return this.encodeBinaryComparisonOp((BinaryComparisonOperator)filter, "$ne", extraData);
    }

    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        return this.encodeBinaryComparisonOp((BinaryComparisonOperator)filter, "$gt", extraData);
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        return this.encodeBinaryComparisonOp((BinaryComparisonOperator)filter, "$gte", extraData);
    }

    public Object visit(PropertyIsLessThan filter, Object extraData) {
        return this.encodeBinaryComparisonOp((BinaryComparisonOperator)filter, "$lt", extraData);
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        return this.encodeBinaryComparisonOp((BinaryComparisonOperator)filter, "$lte", extraData);
    }

    public Object visit(PropertyIsLike filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        Expression filterExpression = filter.getExpression();
        if (!(filterExpression instanceof PropertyName)) {
            throw new UnsupportedOperationException("LIKE only works with propertyName");
        }
        String expr = Converters.convert(filterExpression.accept((ExpressionVisitor)this, null), String.class);
        String multi = filter.getWildCard();
        String single = filter.getSingleChar();
        int flags = filter.isMatchingCase() ? 0 : 2;
        String regex = filter.getLiteral().replace(multi, ".*").replace(single, ".");
        regex = "^" + regex + "$";
        Pattern p = Pattern.compile(regex, flags);
        output.put(expr, (Object)p);
        return output;
    }

    public Object visit(PropertyIsNull filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        String prop = Converters.convert(filter.accept((FilterVisitor)this, null), String.class);
        output.put(prop, (Object)new BasicDBObject("$exists", (Object)false));
        return output;
    }

    public Object visit(Id filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        Set ids = filter.getIdentifiers();
        ArrayList<ObjectId> objectIds = new ArrayList<ObjectId>(ids.size());
        for (Identifier id : ids) {
            objectIds.add(new ObjectId(id.toString()));
        }
        Object objectIdDBO = objectIds.size() > 1 ? new BasicDBObject("$in", objectIds) : (Serializable)objectIds.get(0);
        output.put("_id", objectIdDBO);
        return output;
    }

    public Object visit(BBOX filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        Object e1 = filter.getExpression1().accept((ExpressionVisitor)this, Geometry.class);
        Envelope envelope = (Envelope)filter.getExpression2().evaluate(null, Envelope.class);
        DBObject dbo = BasicDBObjectBuilder.start().push("$geoIntersects").add("$geometry", (Object)this.geometryBuilder.toObject(envelope)).get();
        output.put((String)e1, (Object)dbo);
        return output;
    }

    public Object visit(Intersects filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        Object e1 = filter.getExpression1().accept((ExpressionVisitor)this, Geometry.class);
        Geometry geometry = (Geometry)filter.getExpression2().evaluate(null, Geometry.class);
        DBObject dbo = BasicDBObjectBuilder.start().push("$geoIntersects").add("$geometry", (Object)this.geometryBuilder.toObject(geometry)).get();
        output.put((String)e1, (Object)dbo);
        return output;
    }

    public Object visit(Within filter, Object extraData) {
        BasicDBObject output = this.asDBObject(extraData);
        Object e1 = filter.getExpression1().accept((ExpressionVisitor)this, Geometry.class);
        Geometry geometry = (Geometry)filter.getExpression2().evaluate(null, Geometry.class);
        DBObject dbo = BasicDBObjectBuilder.start().push("$geoWithin").add("$geometry", (Object)this.geometryBuilder.toObject(geometry)).get();
        output.put((String)e1, (Object)dbo);
        return output;
    }

    public Object visitNullFilter(Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(NilExpression expression, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Beyond filter, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Contains filter, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Crosses filter, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Disjoint filter, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(DWithin filter, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Equals filter, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Overlaps filter, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Touches filter, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Add expression, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Divide expression, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Function function, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Multiply expression, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Subtract expression, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(PropertyIsNil filter, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(After after, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Before before, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Begins begins, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(BegunBy begunBy, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(During during, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(EndedBy endedBy, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Ends ends, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Meets meets, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(MetBy metBy, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(TContains contains, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(TEquals equals, Object extraData) {
        throw new UnsupportedOperationException();
    }

    public Object visit(TOverlaps contains, Object extraData) {
        throw new UnsupportedOperationException();
    }

    Object encodeLiteral(Object literal, Class<?> targetType) {
        if (literal instanceof Envelope) {
            return this.geometryBuilder.toObject((Envelope)literal);
        }
        if (literal instanceof Geometry) {
            return this.geometryBuilder.toObject((Geometry)literal);
        }
        if (literal instanceof Date) {
            if (targetType != null && Date.class.isAssignableFrom(targetType)) {
                return literal;
            }
            return ISO8601_SDF.format((Date)literal);
        }
        if (literal instanceof String) {
            if (targetType != null && Date.class.isAssignableFrom(targetType)) {
                try {
                    return ISO8601_SDF.parse((String)literal);
                }
                catch (ParseException e) {
                    LOGGER.log(Level.WARNING, "Could not parse String literal as ISO-8601 date", e);
                }
            }
            return literal;
        }
        return literal.toString();
    }
}

