/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.mongodb;

import com.mongodb.DBObject;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.List;
import org.geotools.data.mongodb.CollectionMapper;
import org.geotools.data.mongodb.MongoFeature;
import org.geotools.data.mongodb.MongoUtil;
import org.geotools.util.Converters;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public abstract class AbstractCollectionMapper
implements CollectionMapper {
    @Override
    public SimpleFeature buildFeature(DBObject rootDBO, SimpleFeatureType featureType) {
        String gdLocalName = featureType.getGeometryDescriptor().getLocalName();
        List adList = featureType.getAttributeDescriptors();
        ArrayList<Geometry> values = new ArrayList<Geometry>(adList.size());
        for (AttributeDescriptor descriptor : adList) {
            String adLocalName = descriptor.getLocalName();
            if (gdLocalName.equals(adLocalName)) {
                values.add(this.getGeometry(rootDBO));
                continue;
            }
            String path = this.getPropertyPath(adLocalName);
            Object o = path == null ? null : MongoUtil.getDBOValue(rootDBO, path);
            values.add((Geometry)(o == null ? null : (Object)Converters.convert(o, descriptor.getType().getBinding())));
        }
        return new MongoFeature(values.toArray(), featureType, rootDBO.get("_id").toString());
    }
}

