/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.oracle;

import java.lang.reflect.Method;
import org.geotools.factory.Hints;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;

public class OracleClobConverterFactory
implements ConverterFactory {
    OracleDateConverter converter = new OracleDateConverter();
    static final Class<?> ORA_CLOB;
    static final Method ORA_GET_CHARS;
    static final Method ORA_LENGTH;

    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (ORA_CLOB == null) {
            return null;
        }
        if (!String.class.equals(target)) {
            return null;
        }
        if (!ORA_CLOB.isAssignableFrom(source)) {
            return null;
        }
        return this.converter;
    }

    static {
        Class<?> oracleClobClass = null;
        try {
            oracleClobClass = Class.forName("oracle.sql.CLOB");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (oracleClobClass == null) {
            ORA_CLOB = null;
            ORA_GET_CHARS = null;
            ORA_LENGTH = null;
        } else {
            try {
                ORA_CLOB = oracleClobClass;
                ORA_LENGTH = ORA_CLOB.getMethod("length", new Class[0]);
                ORA_GET_CHARS = ORA_CLOB.getMethod("getChars", Long.TYPE, Integer.TYPE, char[].class);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not initialize the oracle blob converter", e);
            }
        }
    }

    class OracleDateConverter
    implements Converter {
        OracleDateConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            int length = ((Long)ORA_LENGTH.invoke(source, new Object[0])).intValue();
            char[] buffer = new char[length];
            ORA_GET_CHARS.invoke(source, 1L, length, buffer);
            return (T)new String(buffer);
        }
    }
}

