/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.utils.imagepyramid;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.option.DefaultOption;
import org.apache.commons.cli2.validation.InvalidArgumentException;
import org.apache.commons.cli2.validation.Validator;
import org.apache.commons.io.FileUtils;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.gce.imagemosaic.ImageMosaicConfigHandler;
import org.geotools.gce.imagemosaic.ImageMosaicDirectoryWalker;
import org.geotools.gce.imagemosaic.ImageMosaicEventHandlers;
import org.geotools.gce.imagemosaic.MosaicConfigurationBean;
import org.geotools.gce.imagemosaic.catalogbuilder.CatalogBuilderConfiguration;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.util.logging.Logging;
import org.geotools.utils.coveragetiler.CoverageTiler;
import org.geotools.utils.imagepyramid.PyramidLayerBuilder;
import org.geotools.utils.progress.BaseArgumentsManager;
import org.geotools.utils.progress.ExceptionEvent;
import org.geotools.utils.progress.ProcessingEvent;
import org.geotools.utils.progress.ProcessingEventListener;

public class PyramidBuilder
extends BaseArgumentsManager
implements Runnable,
ProcessingEventListener {
    private static final Set<String> scalingAlgorithms = new HashSet<String>();
    private static final String VERSION = "0.3";
    private static final String NAME = "PyramidBuilder";
    private DefaultOption locationOpt;
    private DefaultOption outputLocationOpt;
    private File outputLocation;
    private Option tileDimOpt;
    private Option scaleAlgorithmOpt;
    private Option numStepsOpt;
    private Option scaleFactorOpt;
    private Option overwriteOpt;
    private int tileW = -1;
    private int tileH = -1;
    private String scaleAlgorithm;
    private static final Logger LOGGER;
    private int scaleFactor;
    private File inputLocation;
    private String name;
    private Option nameOpt;
    private int numSteps;
    private boolean exceptionOccurred = false;
    private boolean overwriteOutputDirs = false;
    private double currStep = 0.0;
    private double totalSteps = 0.0;
    private ProcessingEventListener slaveToolsListener = new ProcessingEventListener(){

        @Override
        public void getNotification(ProcessingEvent event) {
            PyramidBuilder.this.fireEvent(event.getMessage(), PyramidBuilder.this.currStep / PyramidBuilder.this.totalSteps * 100.0 + event.getPercentage() / PyramidBuilder.this.totalSteps);
        }

        @Override
        public void exceptionOccurred(ExceptionEvent event) {
            PyramidBuilder.this.fireException(event.getMessage(), event.getPercentage(), event.getException());
            PyramidBuilder.this.exceptionOccurred = true;
        }
    };
    private GeneralEnvelope envelope;
    private double[][] resolutions;
    private Option compressionRatioOpt;
    private Option compressionTypeOpt;
    private Option internalTileDimOpt = this.optionBuilder.withShortName("it").withLongName("internal_tile_dimension").withArgument(this.argumentBuilder.withName("it").withMinimum(0).withMaximum(1).create()).withDescription("Internal width and height of each tile we generate").withRequired(false).create();
    private int internalTileWidth = 512;
    private int internalTileHeight = 512;
    private String compressionScheme = "LZW";
    private double compressionRatio = 0.75;

    public PyramidBuilder() {
        super(NAME, VERSION);
        this.locationOpt = this.optionBuilder.withShortName("s").withLongName("source").withArgument(this.argumentBuilder.withName("source").withMinimum(1).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Source can be a single file or directory ");
                }
                File source = new File((String)args.get(0));
                if (!source.exists()) {
                    throw new InvalidArgumentException(new StringBuffer("The provided source is invalid! ").toString());
                }
            }
        }).create()).withDescription("path where files are located").withRequired(true).create();
        this.nameOpt = this.optionBuilder.withShortName("name").withLongName("pyramid_name").withArgument(this.argumentBuilder.withName("name").withMinimum(0).withMaximum(1).create()).withDescription("name for the pyramid property file").withRequired(false).create();
        this.tileDimOpt = this.optionBuilder.withShortName("t").withLongName("tiled_dimension").withArgument(this.argumentBuilder.withName("t").withMinimum(0).withMaximum(1).create()).withDescription("tile dimensions as a couple width,height in pixels").withRequired(true).create();
        this.scaleFactorOpt = this.optionBuilder.withShortName("f").withLongName("scale_factor").withArgument(this.argumentBuilder.withName("f").withMinimum(1).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one scaling algorithm at a time can be chosen");
                }
                int factor = Integer.parseInt((String)args.get(0));
                if (factor <= 0) {
                    throw new InvalidArgumentException(new StringBuffer("The provided scale factor is negative! ").toString());
                }
                if (factor == 1) {
                    LOGGER.warning("The scale factor is 1, program will exit!");
                    System.exit(0);
                }
            }
        }).create()).withDescription("integer scale factor").withRequired(true).create();
        this.numStepsOpt = this.optionBuilder.withShortName("n").withLongName("num_steps").withArgument(this.argumentBuilder.withName("n").withMinimum(1).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one scaling algorithm at a time can be chosen");
                }
                int steps = Integer.parseInt((String)args.get(0));
                if (steps <= 0) {
                    throw new InvalidArgumentException(new StringBuffer("The provided scale factor is negative! ").toString());
                }
            }
        }).create()).withDescription("integer scale factor").withRequired(true).create();
        this.scaleAlgorithmOpt = this.optionBuilder.withShortName("a").withLongName("scaling_algorithm").withArgument(this.argumentBuilder.withName("a").withMinimum(0).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one scaling algorithm at a time can be chosen");
                }
                if (!scalingAlgorithms.contains(args.get(0))) {
                    throw new InvalidArgumentException(new StringBuffer("The output format ").append(args.get(0)).append(" is not permitted").toString());
                }
            }
        }).create()).withDescription("name of the scaling algorithm, eeither one of average (a), filtered (f), bilinear (bil), nearest neigbhor (nn)").withRequired(false).create();
        this.overwriteOpt = this.optionBuilder.withShortName("w").withLongName("overwrite").withDescription("completely wipe out existing layer dirs before proceeding.").withRequired(false).create();
        this.compressionTypeOpt = this.optionBuilder.withShortName("z").withLongName("compressionType").withDescription("compression type.").withArgument(this.argumentBuilder.withName("compressionType").withMinimum(0).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one scaling algorithm at a time can be chosen");
                }
            }
        }).create()).withRequired(false).create();
        this.compressionRatioOpt = this.optionBuilder.withShortName("r").withLongName("compressionRatio").withDescription("compression ratio.").withArgument(this.argumentBuilder.withName("compressionRatio").withMinimum(0).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one scaling algorithm at a time can be chosen");
                }
                String val = (String)args.get(0);
                double value = Double.parseDouble(val);
                if (value <= 0.0 || value > 1.0) {
                    throw new InvalidArgumentException("Invalid compressio ratio");
                }
            }
        }).create()).withRequired(false).create();
        this.addOption(this.compressionTypeOpt);
        this.addOption(this.compressionRatioOpt);
        this.addOption((Option)this.locationOpt);
        this.addOption(this.tileDimOpt);
        this.addOption(this.scaleFactorOpt);
        this.addOption(this.scaleAlgorithmOpt);
        this.addOption(this.numStepsOpt);
        this.addOption(this.overwriteOpt);
        this.addOption(this.internalTileDimOpt);
        this.finishInitialization();
    }

    @Override
    public void run() {
        AbstractGridFormat format = GridFormatFinder.findFormat((Object)this.inputLocation);
        if (format == null) {
            String message = "Could not find a format for this coverage";
            this.fireException(message, 0.0, new IOException(message));
            return;
        }
        AbstractGridCoverage2DReader inReader = format.getReader((Object)this.inputLocation);
        if (inReader == null) {
            String message = "Unable to instantiate a reader for this coverage";
            this.fireException(message, 0.0, new IOException(message));
            return;
        }
        this.envelope = inReader.getOriginalEnvelope();
        try {
            inReader.dispose();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failure occurred while closing grid coverage reader", e);
        }
        if (!this.outputLocation.exists() && !this.outputLocation.mkdir()) {
            String message = "Could not create output directory: " + this.outputLocation;
            this.fireException(message, 0.0, new IOException(message));
            return;
        }
        this.totalSteps = (this.numSteps + 1) * 2;
        this.currStep = 1.0;
        File outputDir = new File(this.outputLocation, "0");
        if (!this.checkLayerDir(outputDir)) {
            return;
        }
        this.resolutions = new double[2][this.numSteps + 1];
        this.tileInput(outputDir);
        if (this.exceptionOccurred) {
            return;
        }
        this.currStep += 1.0;
        double[] resolution = this.mosaicLevel(0);
        this.resolutions[0][0] = resolution[0];
        this.resolutions[1][0] = resolution[1];
        if (this.exceptionOccurred) {
            return;
        }
        this.currStep += 1.0;
        int currLevel = this.scaleFactor;
        int prevLevel = 0;
        for (int step = 0; step < this.numSteps; ++step) {
            File prevLevelDirectory = new File(this.outputLocation, String.valueOf(prevLevel));
            File currLevelDirectory = new File(this.outputLocation, String.valueOf(currLevel));
            if (!this.checkLayerDir(currLevelDirectory)) {
                return;
            }
            this.buildNewLayer(prevLevelDirectory, currLevelDirectory);
            if (this.exceptionOccurred) {
                return;
            }
            this.currStep += 1.0;
            resolution = this.mosaicLevel(currLevel);
            this.resolutions[0][step + 1] = resolution[0];
            this.resolutions[1][step + 1] = resolution[1];
            if (this.exceptionOccurred) {
                return;
            }
            this.currStep += 1.0;
            prevLevel = currLevel;
            currLevel *= this.scaleFactor;
        }
        this.fireEvent("Creating final properties file ", 99.9);
        this.createPropertiesFiles();
        if (!this.exceptionOccurred) {
            this.fireEvent("Done!!!", 100.0);
        }
    }

    private boolean checkLayerDir(File outputDir) {
        if (!outputDir.exists()) {
            return true;
        }
        if (!this.overwriteOutputDirs) {
            this.fireException(new IOException("Layer directory " + outputDir + " already exist. Use -w to force its deletion"));
            return false;
        }
        try {
            FileUtils.deleteDirectory((File)outputDir);
        }
        catch (IOException e) {
            this.fireException(e);
            return false;
        }
        return true;
    }

    private void tileInput(File outputDir) {
        CoverageTiler tiler = new CoverageTiler();
        tiler.addProcessingEventListener(this.slaveToolsListener);
        tiler.setInputLocation(this.inputLocation);
        tiler.setOutputLocation(outputDir);
        tiler.setTileWidth(this.tileW);
        tiler.setTileHeight(this.tileH);
        tiler.setInternalTileHeight(this.internalTileHeight);
        tiler.setInternalTileWidth(this.internalTileWidth);
        tiler.setCompressionRatio(this.compressionRatio);
        tiler.setCompressionScheme(this.compressionScheme);
        tiler.run();
        tiler.removeAllProcessingEventListeners();
    }

    private void buildNewLayer(File prevLevelDirectory, File currLevelDirectory) {
        PyramidLayerBuilder layerBuilder = new PyramidLayerBuilder();
        layerBuilder.addProcessingEventListener(this.slaveToolsListener);
        layerBuilder.setInputLocation(new File(prevLevelDirectory, this.name + ".shp"));
        layerBuilder.setOutputLocation(currLevelDirectory);
        layerBuilder.setScaleAlgorithm(this.scaleAlgorithm);
        layerBuilder.setScaleFactor(this.scaleFactor);
        layerBuilder.setTileHeight(this.tileH);
        layerBuilder.setTileWidth(this.tileW);
        layerBuilder.setCompressionRatio(this.compressionRatio);
        layerBuilder.setCompressionScheme(this.compressionScheme);
        layerBuilder.run();
        layerBuilder.removeAllProcessingEventListeners();
    }

    private double[] mosaicLevel(int level) {
        CatalogBuilderConfiguration configuration = new CatalogBuilderConfiguration();
        configuration.setParameter("RootMosaicDirectory", new File(this.outputLocation, String.valueOf(level)).getAbsolutePath());
        configuration.setParameter("Name", this.name);
        configuration.setParameter("IndexingDirectories", configuration.getParameter("RootMosaicDirectory"));
        ImageMosaicEventHandlers eventHandler = new ImageMosaicEventHandlers();
        ImageMosaicConfigHandler catalogHandler = new ImageMosaicConfigHandler(configuration, eventHandler);
        ImageMosaicDirectoryWalker builder = new ImageMosaicDirectoryWalker(catalogHandler, eventHandler);
        builder.run();
        eventHandler.addProcessingEventListener(new ImageMosaicEventHandlers.ProcessingEventListener(){

            public void getNotification(ImageMosaicEventHandlers.ProcessingEvent event) {
                PyramidBuilder.this.slaveToolsListener.getNotification(new ProcessingEvent(event.getSource(), event.getMessage(), event.getPercentage()));
            }

            public void exceptionOccurred(ImageMosaicEventHandlers.ExceptionEvent event) {
                PyramidBuilder.this.slaveToolsListener.exceptionOccurred(new ExceptionEvent(event.getSource(), event.getMessage(), event.getPercentage(), event.getException()));
            }
        });
        eventHandler.removeAllProcessingEventListeners();
        MosaicConfigurationBean bean = (MosaicConfigurationBean)catalogHandler.getConfigurations().values().iterator().next();
        return new double[]{bean.getLevels()[0][0], bean.getLevels()[0][1]};
    }

    private void createPropertiesFiles() {
        Properties properties = new Properties();
        properties.setProperty("Envelope2D", new StringBuffer(Double.toString(this.envelope.getMinimum(0))).append(",").append(Double.toString(this.envelope.getMinimum(1))).append(" ").append(Double.toString(this.envelope.getMaximum(0))).append(",").append(Double.toString(this.envelope.getMaximum(1))).toString());
        properties.setProperty("LevelsNum", Integer.toString(this.numSteps + 1));
        StringBuffer levels = new StringBuffer();
        StringBuffer levelDirs = new StringBuffer();
        for (int i = 0; i < this.numSteps + 1; ++i) {
            levels.append(Double.toString(this.resolutions[0][i])).append(",").append(Double.toString(this.resolutions[1][i]));
            levelDirs.append(i == 0 ? "0" : Integer.toString((int)Math.pow(this.scaleFactor, i)));
            if (i >= this.numSteps) continue;
            levels.append(" ");
            levelDirs.append(" ");
        }
        properties.setProperty("Levels", levels.toString());
        properties.setProperty("LevelsDirs", levelDirs.toString());
        properties.setProperty("Name", this.name);
        try {
            properties.store(new BufferedOutputStream(new FileOutputStream(new File(this.outputLocation, this.name + ".properties"))), "");
            File prjFile = new File(this.outputLocation, this.name + ".prj");
            BufferedWriter out = new BufferedWriter(new FileWriter(prjFile));
            out.write(this.envelope.getCoordinateReferenceSystem().toWKT());
            out.close();
        }
        catch (FileNotFoundException e) {
            this.fireException(e);
        }
        catch (IOException e) {
            this.fireException(e);
        }
    }

    @Override
    public void getNotification(ProcessingEvent event) {
        LOGGER.info(new StringBuffer("Progress is at ").append(event.getPercentage()).append("\n").append("attached message is: ").append(event.getMessage()).toString());
    }

    @Override
    public void exceptionOccurred(ExceptionEvent event) {
        LOGGER.log(Level.SEVERE, "An error occurred during processing", event.getException());
    }

    @Override
    public boolean parseArgs(String[] args) {
        String internalTileDim;
        if (!super.parseArgs(args)) {
            return false;
        }
        this.inputLocation = new File((String)this.getOptionValue((Option)this.locationOpt));
        this.outputLocation = this.hasOption((Option)this.outputLocationOpt) ? new File((String)this.getOptionValue((Option)this.outputLocationOpt)) : new File(this.inputLocation.getParentFile(), "pyramid");
        this.name = this.hasOption(this.nameOpt) ? (String)this.getOptionValue(this.nameOpt) : "pyramid";
        this.overwriteOutputDirs = this.hasOption(this.overwriteOpt);
        String tileDim = (String)this.getOptionValue(this.tileDimOpt);
        String[] pairs = tileDim.split(",");
        this.tileW = Integer.parseInt(pairs[0]);
        this.tileH = Integer.parseInt(pairs[1]);
        String scaleF = (String)this.getOptionValue(this.scaleFactorOpt);
        this.scaleFactor = Integer.parseInt(scaleF);
        this.scaleAlgorithm = (String)this.getOptionValue(this.scaleAlgorithmOpt);
        if (this.scaleAlgorithm == null) {
            this.scaleAlgorithm = "nn";
        }
        this.numSteps = Integer.parseInt((String)this.getOptionValue(this.numStepsOpt));
        if (this.hasOption(this.compressionTypeOpt)) {
            this.compressionScheme = (String)this.getOptionValue(this.compressionTypeOpt);
            if (this.compressionScheme == "") {
                this.compressionScheme = null;
            }
        }
        if (this.hasOption(this.compressionRatioOpt)) {
            try {
                this.compressionRatio = Double.parseDouble((String)this.getOptionValue(this.compressionRatioOpt));
            }
            catch (Exception e) {
                this.compressionRatio = Double.NaN;
            }
        }
        if ((internalTileDim = (String)this.getOptionValue(this.internalTileDimOpt)) != null && internalTileDim.length() > 0) {
            pairs = internalTileDim.split(",");
            this.internalTileWidth = Integer.parseInt(pairs[0]);
            this.internalTileHeight = Integer.parseInt(pairs[1]);
        } else {
            this.internalTileWidth = this.tileW;
            this.internalTileHeight = this.tileH;
        }
        return true;
    }

    public double getCompressionRatio() {
        return this.compressionRatio;
    }

    public String getCompressionScheme() {
        return this.compressionScheme;
    }

    public void setCompressionRatio(double compressionRatio) {
        this.compressionRatio = compressionRatio;
    }

    public void setCompressionScheme(String compressionScheme) {
        this.compressionScheme = compressionScheme;
    }

    public int getInternalTileHeight() {
        return this.internalTileHeight;
    }

    public int getInternalTileWidth() {
        return this.internalTileWidth;
    }

    public void setInternalTileHeight(int internalTileHeight) {
        this.internalTileHeight = internalTileHeight;
    }

    public void setInternalTileWidth(int internalTileWidth) {
        this.internalTileWidth = internalTileWidth;
    }

    public static void main(String[] args) throws IllegalArgumentException, IOException, InterruptedException {
        PyramidBuilder builder = new PyramidBuilder();
        builder.addProcessingEventListener(builder);
        if (builder.parseArgs(args)) {
            Thread t = new Thread((Runnable)builder, NAME);
            t.setPriority(builder.getPriority());
            t.start();
            try {
                t.join();
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Unable to parse command line argumentBuilder, exiting...");
        }
    }

    static {
        scalingAlgorithms.add("nn");
        scalingAlgorithms.add("bil");
        scalingAlgorithms.add("bic");
        scalingAlgorithms.add("avg");
        scalingAlgorithms.add("filt");
        LOGGER = Logging.getLogger((String)PyramidBuilder.class.toString());
    }
}

