/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.utils.imageoverviews;

import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageMetadata;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageWriter;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageWriterSpi;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.TileCache;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.validation.InvalidArgumentException;
import org.apache.commons.cli2.validation.Validator;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.geotools.image.io.ImageIOExt;
import org.geotools.util.logging.Logging;
import org.geotools.utils.CoverageToolsConstants;
import org.geotools.utils.WriteProgressListenerAdapter;
import org.geotools.utils.imageoverviews.Utils;
import org.geotools.utils.progress.BaseArgumentsManager;
import org.geotools.utils.progress.ExceptionEvent;
import org.geotools.utils.progress.ProcessingEvent;
import org.geotools.utils.progress.ProcessingEventListener;

public class OverviewsEmbedder
extends BaseArgumentsManager
implements Runnable,
ProcessingEventListener {
    private static final TIFFImageWriterSpi TIFF_IMAGE_WRITER_SPI = new TIFFImageWriterSpi();
    private int lastProgress = 0;
    private double lastOverviewProgress = 0.0;
    private final OverviewsEmbedderWriteProgressListener writeProgressListener = new OverviewsEmbedderWriteProgressListener();
    private static final String NAME = "OverviewsEmbedder";
    private static final String VERSION = "0.3";
    private Option locationOpt;
    private Option tileDimOpt;
    private Option scaleAlgorithmOpt;
    private Option wildcardOpt;
    private Option numStepsOpt;
    private Option scaleFactorOpt;
    private Option compressionRatioOpt;
    private Option compressionTypeOpt;
    private int tileW = -1;
    private int tileH = -1;
    private String scaleAlgorithm;
    private static final Logger LOGGER = Logging.getLogger((String)OverviewsEmbedder.class.toString());
    private BorderExtender borderExtender = CoverageToolsConstants.DEFAULT_BORDER_EXTENDER;
    private int downsampleStep;
    private float[] lowPassFilter = CoverageToolsConstants.DEFAULT_KERNEL_GAUSSIAN;
    private String sourcePath;
    private String compressionScheme = null;
    private boolean externalOverviews = false;
    private Option externalOpt;
    private double compressionRatio = 0.75;
    private int numSteps;
    private String wildcardString = "*.*";
    private int fileBeingProcessed;
    private int overviewInProcess;
    private double overallProgress = 0.0;
    private double overallProgressStep;

    public OverviewsEmbedder() {
        super(NAME, VERSION);
        this.locationOpt = this.optionBuilder.withShortName("s").withLongName("source").withArgument(this.argumentBuilder.withName("source").withMinimum(1).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Source can be a single file or  directory ");
                }
                File source = new File((String)args.get(0));
                if (!source.exists()) {
                    throw new InvalidArgumentException("The provided source is invalid! ");
                }
            }
        }).create()).withDescription("path where files are located").withRequired(true).create();
        this.tileDimOpt = this.optionBuilder.withShortName("t").withLongName("tiled_dimension").withArgument(this.argumentBuilder.withName("t").withMinimum(0).withMaximum(1).create()).withDescription("tile dimensions as a couple width,height in pixels").withRequired(false).create();
        this.externalOpt = this.optionBuilder.withShortName("ext").withLongName("external_overviews").withArgument(this.argumentBuilder.withName("extt").withMinimum(0).withMaximum(1).create()).withDescription("create externalOverviews overviews").withRequired(false).create();
        this.scaleFactorOpt = this.optionBuilder.withShortName("f").withLongName("scale_factor").withArgument(this.argumentBuilder.withName("f").withMinimum(1).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one scale factor at a time can be chosen");
                }
                int factor = Integer.parseInt((String)args.get(0));
                if (factor <= 0) {
                    throw new InvalidArgumentException("The provided scale factor is negative! ");
                }
                if (factor == 1) {
                    LOGGER.warning("The scale factor is 1, program will exit!");
                    System.exit(0);
                }
            }
        }).create()).withDescription("integer scale factor").withRequired(true).create();
        this.wildcardOpt = this.optionBuilder.withShortName("w").withLongName("wildcardOpt").withArgument(this.argumentBuilder.withName("wildcardOpt").withMinimum(0).withMaximum(1).create()).withDescription("wildcardOpt to use for selecting files").withRequired(false).create();
        this.numStepsOpt = this.optionBuilder.withShortName("n").withLongName("num_steps").withArgument(this.argumentBuilder.withName("n").withMinimum(1).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one  number of step at a time can be chosen");
                }
                int steps = Integer.parseInt((String)args.get(0));
                if (steps <= 0) {
                    throw new InvalidArgumentException("The provided number of step is negative! ");
                }
            }
        }).create()).withDescription("integer scale factor").withRequired(true).create();
        this.scaleAlgorithmOpt = this.optionBuilder.withShortName("a").withLongName("scaling_algorithm").withArgument(this.argumentBuilder.withName("a").withMinimum(0).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one scaling algorithm at a time can be chosen");
                }
                SubsampleAlgorithm algorithm = SubsampleAlgorithm.valueOf((String)args.get(0));
                if (algorithm == null) {
                    throw new InvalidArgumentException("The scaling algorithm " + args.get(0) + " is not supported");
                }
            }
        }).create()).withDescription("name of the scaling algorithm, eeither one of average (a), filtered\t (f), bilinear (bil), nearest neigbhor (nn)").withRequired(false).create();
        this.compressionTypeOpt = this.optionBuilder.withShortName("z").withLongName("compressionType").withDescription("compression type.").withArgument(this.argumentBuilder.withName("compressionType").withMinimum(0).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one scaling algorithm at a time can be chosen");
                }
            }
        }).create()).withRequired(false).create();
        this.compressionRatioOpt = this.optionBuilder.withShortName("r").withLongName("compressionRatio").withDescription("compression ratio.").withArgument(this.argumentBuilder.withName("compressionRatio").withMinimum(0).withMaximum(1).withValidator(new Validator(){

            public void validate(List args) throws InvalidArgumentException {
                int size = args.size();
                if (size > 1) {
                    throw new InvalidArgumentException("Only one scaling algorithm at a time can be chosen");
                }
                String val = (String)args.get(0);
                double value = Double.parseDouble(val);
                if (value <= 0.0 || value > 1.0) {
                    throw new InvalidArgumentException("Invalid compressio ratio");
                }
            }
        }).create()).withRequired(false).create();
        this.addOption(this.locationOpt);
        this.addOption(this.tileDimOpt);
        this.addOption(this.scaleFactorOpt);
        this.addOption(this.scaleAlgorithmOpt);
        this.addOption(this.numStepsOpt);
        this.addOption(this.wildcardOpt);
        this.addOption(this.compressionTypeOpt);
        this.addOption(this.compressionRatioOpt);
        this.addOption(this.externalOpt);
        this.finishInitialization();
    }

    public int getDownsampleStep() {
        return this.downsampleStep;
    }

    public void setDownsampleStep(int downsampleWH) {
        this.downsampleStep = downsampleWH;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public int getTileHeight() {
        return this.tileH;
    }

    public void setTileHeight(int tileHeight) {
        this.tileH = tileHeight;
    }

    public int getTileWidth() {
        return this.tileW;
    }

    public void setTileWidth(int tileWidth) {
        this.tileW = tileWidth;
    }

    public void setBorderExtender(BorderExtender borderExtender) {
        this.borderExtender = borderExtender;
    }

    public float[] getLowPassFilter() {
        return this.lowPassFilter;
    }

    public void setLowPassFilter(float[] lowPassFilter) {
        this.lowPassFilter = lowPassFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        StringBuilder message;
        File[] files;
        boolean localTileCache = false;
        TileCache baseTC = JAI.getDefaultInstance().getTileCache();
        if (baseTC == null) {
            localTileCache = true;
            long tilecacheSize = super.getTileCacheSize();
            baseTC = JAI.createTileCache();
            baseTC.setMemoryCapacity(tilecacheSize);
            baseTC.setMemoryThreshold(0.75f);
        }
        if (this.sourcePath == null) {
            this.fireEvent("Provided sourcePath is null", this.overallProgress);
            return;
        }
        File file = new File(this.sourcePath);
        int numFiles = 1;
        if (!file.canRead() || !file.exists()) {
            this.fireEvent("Provided file " + file.getAbsolutePath() + " cannot be read or does not exist", 100.0);
            return;
        }
        if (file.isDirectory()) {
            if (this.wildcardString == null) {
                this.fireEvent("Provided wildcardString is null", 100.0);
                return;
            }
            WildcardFileFilter fileFilter = new WildcardFileFilter(this.wildcardString);
            files = file.listFiles((FileFilter)fileFilter);
            numFiles = files.length;
            if (numFiles <= 0) {
                message = new StringBuilder("No files to process!");
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(message.toString());
                }
                this.fireEvent(message.toString(), 100.0);
            }
        } else {
            files = new File[]{file};
        }
        if (files == null || files.length == 0) {
            this.fireEvent("Unable to find input files for the provided wildcard " + this.wildcardString + " and input path " + this.sourcePath, 100.0);
            return;
        }
        this.overallProgressStep = 100.0 / (double)numFiles;
        this.fileBeingProcessed = 0;
        while (this.fileBeingProcessed < numFiles) {
            message = new StringBuilder("Managing file  ").append(this.fileBeingProcessed).append(" of ").append(files[this.fileBeingProcessed]).append(" files");
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(message.toString());
            }
            this.overallProgress = this.overallProgressStep * (double)this.fileBeingProcessed;
            this.fireEvent(message.toString(), this.overallProgress);
            if (this.getStopThread()) {
                message = new StringBuilder("Stopping requested at file  ").append(this.fileBeingProcessed).append(" of ").append(numFiles).append(" files");
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(message.toString());
                }
                this.fireEvent(message.toString(), this.overallProgress);
                return;
            }
            ImageInputStream stream = null;
            ImageWriter writer = null;
            ImageInputStream streamOut = null;
            RenderedOp currentImage = null;
            RenderedOp newImage = null;
            try {
                File localFile = files[this.fileBeingProcessed];
                stream = ImageIO.createImageInputStream(localFile);
                if (stream == null) {
                    message = new StringBuilder("Unable to create an input stream for file").append(files[this.fileBeingProcessed]);
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.severe(message.toString());
                    }
                    this.fireEvent(message.toString(), this.overallProgress);
                    break;
                }
                stream.mark();
                Iterator<ImageReader> it = ImageIO.getImageReaders(stream);
                if (!it.hasNext()) {
                    message = new StringBuilder("Unable to find a reader for file").append(files[this.fileBeingProcessed]);
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.severe(message.toString());
                    }
                    this.fireEvent(message.toString(), this.overallProgress);
                    break;
                }
                ImageReader reader = it.next();
                stream.reset();
                stream.mark();
                if (!reader.getFormatName().toLowerCase().startsWith("tif")) {
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.info("Discarding input file " + files[this.fileBeingProcessed] + " since it is not a proper tif file.");
                    }
                } else {
                    reader.setInput(stream);
                    ImageLayout layout = null;
                    int actualTileW = reader.getTileWidth(0);
                    int actualTileH = reader.getTileHeight(0);
                    if (!reader.isImageTiled(0) || reader.isImageTiled(0) && actualTileH != this.tileH && this.tileH != -1 || actualTileW != this.tileW && this.tileW != -1) {
                        message = new StringBuilder("Retiling image  ").append(this.fileBeingProcessed);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine(message.toString());
                        }
                        this.fireEvent(message.toString(), this.overallProgress);
                        layout = Utils.createTiledLayout(this.tileW, this.tileH, 0, 0);
                    }
                    stream.reset();
                    reader.reset();
                    reader.dispose();
                    if (this.externalOverviews) {
                        localFile = new File(localFile.getParent(), FilenameUtils.getBaseName((String)localFile.getAbsolutePath()) + ".tif.ovr");
                    }
                    if ((streamOut = ImageIOExt.createImageOutputStream(null, (Object)localFile)) == null) {
                        message = new StringBuilder("Unable to acquire an ImageOutputStream for the file ").append(files[this.fileBeingProcessed].toString());
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.severe(message.toString());
                        }
                        this.fireEvent(message.toString(), 100.0);
                        break;
                    }
                    writer = TIFF_IMAGE_WRITER_SPI.createWriterInstance();
                    writer.setOutput(streamOut);
                    writer.addIIOWriteProgressListener(this.writeProgressListener);
                    writer.addIIOWriteWarningListener(this.writeProgressListener);
                    ImageWriteParam param = writer.getDefaultWriteParam();
                    if (this.tileH != -1 & this.tileW != -1) {
                        param.setTilingMode(2);
                        param.setTiling(this.tileW, this.tileH, 0, 0);
                    } else {
                        param.setTilingMode(2);
                        param.setTiling(actualTileW, actualTileH, 0, 0);
                    }
                    if (this.compressionScheme != null && !Double.isNaN(this.compressionRatio)) {
                        param.setCompressionMode(2);
                        param.setCompressionType(this.compressionScheme);
                        param.setCompressionQuality((float)this.compressionRatio);
                    }
                    RenderingHints newHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
                    newHints.add(new RenderingHints(JAI.KEY_TILE_CACHE, baseTC));
                    ParameterBlock pbjRead = new ParameterBlock();
                    pbjRead.add(stream);
                    pbjRead.add((Object)0);
                    pbjRead.add(Boolean.FALSE);
                    pbjRead.add(Boolean.FALSE);
                    pbjRead.add(Boolean.FALSE);
                    pbjRead.add(null);
                    pbjRead.add(null);
                    pbjRead.add(null);
                    pbjRead.add(null);
                    currentImage = JAI.create((String)"ImageRead", (ParameterBlock)pbjRead, (RenderingHints)newHints);
                    message = new StringBuilder("Read original image  ").append(this.fileBeingProcessed);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(message.toString());
                    }
                    this.fireEvent(message.toString(), this.overallProgress);
                    int i = 0;
                    this.overviewInProcess = 0;
                    while (this.overviewInProcess < this.numSteps) {
                        message = new StringBuilder("Subsampling step ").append(this.overviewInProcess + 1).append(" of image  ").append(this.fileBeingProcessed);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine(message.toString());
                        }
                        this.fireEvent(message.toString(), this.overallProgress);
                        if (currentImage.getWidth() / this.downsampleStep <= 0 || currentImage.getHeight() / this.downsampleStep <= 0) break;
                        SubsampleAlgorithm algorithm = SubsampleAlgorithm.valueOf(this.scaleAlgorithm);
                        switch (algorithm) {
                            case Average: {
                                newImage = Utils.scaleAverage((RenderedImage)currentImage, baseTC, this.downsampleStep, this.borderExtender);
                                break;
                            }
                            case Filtered: {
                                newImage = Utils.filteredSubsample((RenderedImage)currentImage, baseTC, this.downsampleStep, this.lowPassFilter);
                                break;
                            }
                            case Bilinear: {
                                newImage = Utils.subsample(currentImage, baseTC, (Interpolation)new InterpolationBilinear(), this.downsampleStep, this.borderExtender);
                                break;
                            }
                            case Bicubic: {
                                newImage = Utils.subsample(currentImage, baseTC, (Interpolation)new InterpolationBicubic(2), this.downsampleStep, this.borderExtender);
                                break;
                            }
                            case Nearest: {
                                newImage = Utils.subsample(currentImage, baseTC, (Interpolation)new InterpolationNearest(), this.downsampleStep, this.borderExtender);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Invalid scaling algorithm " + this.scaleAlgorithm);
                            }
                        }
                        IIOMetadata imageMetadata = null;
                        if (writer instanceof TIFFImageWriter && (imageMetadata = writer.getDefaultImageMetadata(new ImageTypeSpecifier((RenderedImage)newImage), param)) != null) {
                            ((TIFFImageMetadata)imageMetadata).addShortOrLongField(254, 1);
                        }
                        if (!this.externalOverviews || i > 0) {
                            writer.writeInsert(-1, new IIOImage((RenderedImage)newImage, null, imageMetadata), param);
                        } else {
                            writer.write(null, new IIOImage((RenderedImage)newImage, null, imageMetadata), param);
                        }
                        message = new StringBuilder("Step ").append(this.overviewInProcess + 1).append(" of image  ").append(this.fileBeingProcessed).append(" done!");
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine(message.toString());
                        }
                        this.fireEvent(message.toString(), this.overallProgress);
                        currentImage.dispose();
                        currentImage = newImage;
                        ++i;
                        ++this.overviewInProcess;
                    }
                    this.overallProgress = 100.0;
                    message = new StringBuilder("Done with  image  ").append(this.fileBeingProcessed);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(message.toString());
                    }
                    this.fireEvent(message.toString(), this.overallProgress);
                }
            }
            catch (Throwable e) {
                this.fireException(e);
            }
            finally {
                block148: {
                    block147: {
                        block146: {
                            block145: {
                                block144: {
                                    if (localTileCache && baseTC != null) {
                                        try {
                                            baseTC.flush();
                                        }
                                        catch (Exception e) {}
                                    }
                                    try {
                                        if (streamOut != null) {
                                            streamOut.close();
                                        }
                                    }
                                    catch (Throwable e) {
                                        if (!LOGGER.isLoggable(Level.FINE)) break block144;
                                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                    }
                                }
                                try {
                                    if (writer != null) {
                                        writer.dispose();
                                    }
                                }
                                catch (Throwable e) {
                                    if (!LOGGER.isLoggable(Level.FINE)) break block145;
                                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                }
                            }
                            try {
                                if (currentImage != null) {
                                    currentImage.dispose();
                                }
                            }
                            catch (Throwable e) {
                                if (!LOGGER.isLoggable(Level.FINE)) break block146;
                                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                            }
                        }
                        try {
                            if (newImage != null) {
                                newImage.dispose();
                            }
                        }
                        catch (Throwable e) {
                            if (!LOGGER.isLoggable(Level.FINE)) break block147;
                            LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                        }
                    }
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block148;
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
            }
            ++this.fileBeingProcessed;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Done!!!");
        }
    }

    @Override
    public void getNotification(ProcessingEvent event) {
        LOGGER.info("Progress is at " + event.getPercentage() + "\n" + "attached message is: " + event.getMessage());
    }

    @Override
    public void exceptionOccurred(ExceptionEvent event) {
        LOGGER.log(Level.SEVERE, "An error occurred during processing", event.getException());
    }

    @Override
    public boolean parseArgs(String[] args) {
        if (!super.parseArgs(args)) {
            return false;
        }
        this.sourcePath = (String)this.getOptionValue(this.locationOpt);
        if (this.hasOption(this.tileDimOpt)) {
            String tileDim = (String)this.getOptionValue(this.tileDimOpt);
            String[] pairs = tileDim.split(",");
            this.tileW = Integer.parseInt(pairs[0]);
            this.tileH = pairs.length > 1 ? Integer.parseInt(pairs[1]) : this.tileW;
        }
        String scaleF = (String)this.getOptionValue(this.scaleFactorOpt);
        this.downsampleStep = Integer.parseInt(scaleF);
        if (this.hasOption(this.wildcardOpt)) {
            this.wildcardString = (String)this.getOptionValue(this.wildcardOpt);
        }
        if (this.hasOption(this.externalOpt)) {
            this.externalOverviews = Boolean.parseBoolean((String)this.getOptionValue(this.externalOpt));
        }
        this.scaleAlgorithm = (String)this.getOptionValue(this.scaleAlgorithmOpt);
        if (this.scaleAlgorithm == null) {
            this.scaleAlgorithm = "nn";
        }
        this.numSteps = Integer.parseInt((String)this.getOptionValue(this.numStepsOpt));
        if (this.hasOption(this.compressionTypeOpt)) {
            this.compressionScheme = (String)this.getOptionValue(this.compressionTypeOpt);
            if (this.compressionScheme == "") {
                this.compressionScheme = null;
            }
        }
        if (this.hasOption(this.compressionRatioOpt)) {
            try {
                this.compressionRatio = Double.parseDouble((String)this.getOptionValue(this.compressionRatioOpt));
            }
            catch (Exception e) {
                this.compressionRatio = Double.NaN;
            }
        }
        return true;
    }

    public static void main(String[] args) throws IllegalArgumentException, IOException, InterruptedException {
        OverviewsEmbedder overviewsEmbedder = new OverviewsEmbedder();
        overviewsEmbedder.addProcessingEventListener(overviewsEmbedder);
        if (overviewsEmbedder.parseArgs(args)) {
            Thread t = new Thread((Runnable)overviewsEmbedder, NAME);
            t.setPriority(overviewsEmbedder.getPriority());
            t.start();
            try {
                t.join();
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Unable to parse command line argumentBuilder, exiting...");
        }
    }

    public final void setWildcardString(String wildcardString) {
        this.wildcardString = wildcardString;
    }

    public final double getCompressionRatio() {
        return this.compressionRatio;
    }

    public final String getCompressionScheme() {
        return this.compressionScheme;
    }

    public void setCompressionRatio(double compressionRatio) {
        this.compressionRatio = compressionRatio;
    }

    public void setCompressionScheme(String compressionScheme) {
        this.compressionScheme = compressionScheme;
    }

    public String getScaleAlgorithm() {
        return this.scaleAlgorithm;
    }

    public void setScaleAlgorithm(String scaleAlgorithm) {
        this.scaleAlgorithm = scaleAlgorithm;
    }

    public int getNumSteps() {
        return this.numSteps;
    }

    public void setNumSteps(int numSteps) {
        this.numSteps = numSteps;
    }

    public OverviewsEmbedderWriteProgressListener getWriteProgressListener() {
        return this.writeProgressListener;
    }

    public String getWildcardString() {
        return this.wildcardString;
    }

    public boolean isExternalOverviews() {
        return this.externalOverviews;
    }

    public void setExternalOverviews(boolean externalOverviews) {
        this.externalOverviews = externalOverviews;
    }

    private class OverviewsEmbedderWriteProgressListener
    extends WriteProgressListenerAdapter {
        private OverviewsEmbedderWriteProgressListener() {
        }

        @Override
        public void imageComplete(ImageWriter source) {
            OverviewsEmbedder.this.lastOverviewProgress = ((double)OverviewsEmbedder.this.overviewInProcess + 1.0) * 100.0 * (1.0 / (double)OverviewsEmbedder.this.numSteps);
            OverviewsEmbedder.this.overallProgress = (double)OverviewsEmbedder.this.fileBeingProcessed * OverviewsEmbedder.this.overallProgressStep + OverviewsEmbedder.this.lastOverviewProgress * OverviewsEmbedder.this.overallProgressStep / 100.0;
            OverviewsEmbedder.this.lastProgress = (int)OverviewsEmbedder.this.overallProgress;
            OverviewsEmbedder.this.fireEvent("Completed writing out overview number " + (OverviewsEmbedder.this.overviewInProcess + 1), OverviewsEmbedder.this.lastProgress);
        }

        @Override
        public void imageProgress(ImageWriter source, float percentageDone) {
            double percentageAbsoluteOvr = OverviewsEmbedder.this.lastOverviewProgress + (double)percentageDone * (1.0 / (double)OverviewsEmbedder.this.numSteps);
            OverviewsEmbedder.this.overallProgress = (double)OverviewsEmbedder.this.fileBeingProcessed * OverviewsEmbedder.this.overallProgressStep + percentageAbsoluteOvr * OverviewsEmbedder.this.overallProgressStep / 100.0;
            if (OverviewsEmbedder.this.overallProgress > (double)(OverviewsEmbedder.this.lastProgress + 1) * 5.0) {
                OverviewsEmbedder.this.lastProgress++;
                OverviewsEmbedder.this.fireEvent("Writing out overview " + (OverviewsEmbedder.this.overviewInProcess + 1), (int)OverviewsEmbedder.this.overallProgress);
            }
            if (OverviewsEmbedder.this.getStopThread()) {
                source.abort();
            }
        }

        @Override
        public void imageStarted(ImageWriter source, int imageIndex) {
            OverviewsEmbedder.this.lastOverviewProgress = (double)(OverviewsEmbedder.this.overviewInProcess * 100) * (1.0 / (double)OverviewsEmbedder.this.numSteps);
            OverviewsEmbedder.this.overallProgress = (double)OverviewsEmbedder.this.fileBeingProcessed * OverviewsEmbedder.this.overallProgressStep + OverviewsEmbedder.this.lastOverviewProgress * OverviewsEmbedder.this.overallProgressStep / 100.0;
            OverviewsEmbedder.this.fireEvent("Started writing out overview number " + (OverviewsEmbedder.this.overviewInProcess + 1), OverviewsEmbedder.this.overallProgress);
        }

        @Override
        public void warningOccurred(ImageWriter source, int imageIndex, String warning) {
            OverviewsEmbedder.this.fireEvent("Warning at overview " + (OverviewsEmbedder.this.overviewInProcess + 1), OverviewsEmbedder.this.lastProgress);
        }

        @Override
        public void writeAborted(ImageWriter source) {
            OverviewsEmbedder.this.fireEvent("Aborted writing process.", -1.0);
        }
    }

    public static enum SubsampleAlgorithm {
        Nearest,
        Bilinear,
        Bicubic,
        Average,
        Filtered;

    }
}

