/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.utils.imagemosaic;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.console.CommandLine;
import org.geotools.console.Option;
import org.geotools.gce.imagemosaic.ImageMosaicConfigHandler;
import org.geotools.gce.imagemosaic.ImageMosaicDirectoryWalker;
import org.geotools.gce.imagemosaic.ImageMosaicEventHandlers;
import org.geotools.gce.imagemosaic.catalogbuilder.CatalogBuilderConfiguration;
import org.geotools.util.logging.Logging;

public class CommandLineCatalogBuilderRunner
extends CommandLine {
    private static final Logger LOGGER = Logging.getLogger((String)CommandLineCatalogBuilderRunner.class.toString());
    @Option(description="This index must use absolute or relative path", mandatory=false, name="absolute")
    private Boolean absolute;
    @Option(description="This index can use caching or not", mandatory=false, name="caching")
    private Boolean caching = false;
    @Option(description="Directories where to look for file to index", mandatory=true, name="indexingDirectories")
    private String indexingDirectoriesString;
    @Option(description="This index must handle footprint", mandatory=false, name="footprintManagement")
    private Boolean footprintManagement;
    @Option(description="Name to use for the index of this mosaic", mandatory=false, name="index")
    private String indexName;
    @Option(description="Root directory where to place the index file", mandatory=true, name="rootDirectory")
    private String rootMosaicDirectory;
    @Option(description="Wildcard to use for building the index of this mosaic", mandatory=false, name="wildcard")
    private String wildcardString = "*.*";
    @Option(description="Default location attribute for this index", mandatory=false, name="locationAttribute")
    private String locationAttribute = "location";

    public CommandLineCatalogBuilderRunner(String[] args) {
        super(args);
        if (this.absolute == null) {
            this.absolute = false;
        }
        if (this.caching == null) {
            this.caching = false;
        }
        if (this.footprintManagement == null) {
            this.footprintManagement = true;
        }
        if (this.indexName == null) {
            this.indexName = "index";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        CommandLineCatalogBuilderRunner runner = new CommandLineCatalogBuilderRunner(args);
        CatalogBuilderConfiguration configuration = new CatalogBuilderConfiguration();
        configuration.setParameter("AbsolutePath", runner.absolute.toString());
        configuration.setParameter("Name", runner.indexName);
        configuration.setParameter("FootprintManagement", runner.footprintManagement.toString());
        configuration.setParameter("Caching", runner.caching.toString());
        configuration.setParameter("RootMosaicDirectory", runner.rootMosaicDirectory);
        configuration.setParameter("Wildcard", runner.wildcardString);
        configuration.setParameter("LocationAttribute", runner.locationAttribute);
        String directories = runner.indexingDirectoriesString;
        String[] dirs_ = directories.split(",");
        ArrayList<String> dirs = new ArrayList<String>();
        for (String dir : dirs_) {
            dirs.add(dir);
        }
        configuration.setParameter("IndexingDirectories", directories);
        ImageMosaicEventHandlers eventHandler = new ImageMosaicEventHandlers();
        ImageMosaicConfigHandler catalogHandler = new ImageMosaicConfigHandler(configuration, eventHandler);
        ImageMosaicDirectoryWalker builder = new ImageMosaicDirectoryWalker(catalogHandler, eventHandler);
        final LinkedList exceptions = new LinkedList();
        try {
            ImageMosaicEventHandlers.ProcessingEventListener listener = new ImageMosaicEventHandlers.ProcessingEventListener(){

                public void exceptionOccurred(ImageMosaicEventHandlers.ExceptionEvent event) {
                    Exception t = event.getException();
                    exceptions.add(t);
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, t.getLocalizedMessage(), t);
                    }
                }

                public void getNotification(ImageMosaicEventHandlers.ProcessingEvent event) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(event.getMessage());
                    }
                }
            };
            eventHandler.addProcessingEventListener(listener);
            builder.run();
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Unable to build mosaic", e);
        }
        finally {
            catalogHandler.dispose();
        }
    }
}

