/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.processing.jai.nodata;

import org.geotools.processing.jai.nodata.Range;

public class RangeUshort
extends Range {
    private final int minValue;
    private final int maxValue;
    private final boolean minIncluded;
    private final boolean maxIncluded;
    private final boolean isPoint;

    RangeUshort(short minValue, boolean minIncluded, short maxValue, boolean maxIncluded) {
        int valueMin = minValue & 0xFFFF;
        int valueMax = maxValue & 0xFFFF;
        if (minValue < maxValue) {
            this.minValue = valueMin;
            this.maxValue = valueMax;
            this.isPoint = false;
            this.minIncluded = minIncluded;
            this.maxIncluded = maxIncluded;
        } else if (minValue > maxValue) {
            this.minValue = valueMax;
            this.maxValue = valueMin;
            this.isPoint = false;
            this.minIncluded = minIncluded;
            this.maxIncluded = maxIncluded;
        } else {
            this.minValue = valueMin;
            this.maxValue = valueMin;
            this.isPoint = true;
            if (!minIncluded && !maxIncluded) {
                throw new IllegalArgumentException("Cannot create a single-point range without minimum and maximum bounds included");
            }
            this.minIncluded = true;
            this.maxIncluded = true;
        }
    }

    @Override
    public boolean contains(short value) {
        boolean lower;
        int valueUshort = value & 0xFFFF;
        if (this.isPoint) {
            return this.minValue == valueUshort;
        }
        if (this.minIncluded) {
            lower = valueUshort < this.minValue;
        } else {
            boolean bl = lower = valueUshort <= this.minValue;
        }
        boolean upper = this.maxIncluded ? valueUshort > this.maxValue : valueUshort >= this.maxValue;
        return !lower && !upper;
    }

    @Override
    public Range.DataType getDataType() {
        return Range.DataType.USHORT;
    }

    @Override
    public boolean isPoint() {
        return this.isPoint;
    }

    @Override
    public Number getMax() {
        return this.maxValue;
    }

    @Override
    public Number getMin() {
        return this.minValue;
    }
}

