/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.processing.jai.nodata;

import org.geotools.processing.jai.nodata.Range;

public class RangeLong
extends Range {
    private final long minValue;
    private final long maxValue;
    private final boolean minIncluded;
    private final boolean maxIncluded;
    private final boolean isPoint;

    RangeLong(long minValue, boolean minIncluded, long maxValue, boolean maxIncluded) {
        if (minValue < maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.isPoint = false;
            this.minIncluded = minIncluded;
            this.maxIncluded = maxIncluded;
        } else if (minValue > maxValue) {
            this.minValue = maxValue;
            this.maxValue = minValue;
            this.isPoint = false;
            this.minIncluded = minIncluded;
            this.maxIncluded = maxIncluded;
        } else {
            this.minValue = minValue;
            this.maxValue = minValue;
            this.isPoint = true;
            if (!minIncluded && !maxIncluded) {
                throw new IllegalArgumentException("Cannot create a single-point range without minimum and maximum bounds included");
            }
            this.minIncluded = true;
            this.maxIncluded = true;
        }
    }

    @Override
    public boolean contains(long value) {
        boolean lower;
        if (this.isPoint) {
            return this.minValue == value;
        }
        if (this.minIncluded) {
            lower = value < this.minValue;
        } else {
            boolean bl = lower = value <= this.minValue;
        }
        boolean upper = this.maxIncluded ? value > this.maxValue : value >= this.maxValue;
        return !lower && !upper;
    }

    @Override
    public Range.DataType getDataType() {
        return Range.DataType.LONG;
    }

    @Override
    public boolean isPoint() {
        return this.isPoint;
    }

    @Override
    public Number getMax() {
        return this.maxValue;
    }

    @Override
    public Number getMin() {
        return this.minValue;
    }
}

