/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.processing.jai.nodata;

import org.geotools.processing.jai.nodata.Range;

public class RangeDouble
extends Range {
    private final double minValue;
    private final double maxValue;
    private final long intValue;
    private final boolean minIncluded;
    private final boolean maxIncluded;
    private final boolean isPoint;
    private final boolean isNaN;
    private final boolean nanIncluded;

    RangeDouble(double minValue, boolean minIncluded, double maxValue, boolean maxIncluded, boolean nanIncluded) {
        if (Double.isNaN(minValue) && !Double.isNaN(maxValue) || !Double.isNaN(minValue) && Double.isNaN(maxValue)) {
            throw new UnsupportedOperationException("NaN values can only be set inside a single-point Range");
        }
        if (minValue < maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.isPoint = false;
            this.isNaN = false;
            this.minIncluded = minIncluded;
            this.maxIncluded = maxIncluded;
            this.intValue = 0L;
            this.nanIncluded = nanIncluded;
        } else if (minValue > maxValue) {
            this.minValue = maxValue;
            this.maxValue = minValue;
            this.isPoint = false;
            this.isNaN = false;
            this.minIncluded = minIncluded;
            this.maxIncluded = maxIncluded;
            this.intValue = 0L;
            this.nanIncluded = nanIncluded;
        } else {
            this.minValue = minValue;
            this.maxValue = minValue;
            this.isPoint = true;
            this.nanIncluded = false;
            if (Double.isNaN(minValue)) {
                this.isNaN = true;
                this.intValue = Double.doubleToLongBits(minValue);
            } else {
                this.isNaN = false;
                this.intValue = 0L;
            }
            if (!minIncluded && !maxIncluded) {
                throw new IllegalArgumentException("Cannot create a single-point range without minimum and maximum bounds included");
            }
            this.minIncluded = true;
            this.maxIncluded = true;
        }
    }

    @Override
    public boolean contains(double value) {
        boolean notLower;
        if (this.isPoint) {
            if (this.isNaN) {
                long valueLong = Double.doubleToLongBits(value);
                return valueLong == this.intValue;
            }
            return this.minValue == value;
        }
        if (this.nanIncluded) {
            boolean lower;
            if (this.minIncluded) {
                lower = value < this.minValue;
            } else {
                boolean bl = lower = value <= this.minValue;
            }
            boolean upper = this.maxIncluded ? value > this.maxValue : value >= this.maxValue;
            return !lower && !upper;
        }
        if (this.minIncluded) {
            notLower = value >= this.minValue;
        } else {
            boolean bl = notLower = value > this.minValue;
        }
        boolean notUpper = this.maxIncluded ? value <= this.maxValue : value < this.maxValue;
        return notLower && notUpper;
    }

    @Override
    public Range.DataType getDataType() {
        return Range.DataType.DOUBLE;
    }

    @Override
    public boolean isPoint() {
        return this.isPoint;
    }

    @Override
    public Number getMax() {
        return this.maxValue;
    }

    @Override
    public Number getMin() {
        return this.minValue;
    }
}

