/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.processing.jai.nodata;

public abstract class Range {
    public boolean contains(byte value) {
        throw new UnsupportedOperationException("Wrong data type");
    }

    public boolean contains(short value) {
        throw new UnsupportedOperationException("Wrong data type");
    }

    public boolean contains(int value) {
        throw new UnsupportedOperationException("Wrong data type");
    }

    public boolean contains(float value) {
        throw new UnsupportedOperationException("Wrong data type");
    }

    public boolean contains(double value) {
        throw new UnsupportedOperationException("Wrong data type");
    }

    public boolean contains(long value) {
        throw new UnsupportedOperationException("Wrong data type");
    }

    public <T extends Number> boolean contains(T value) {
        int dataType = this.getDataType().getDataType();
        switch (dataType) {
            case 0: {
                return this.contains(value.byteValue());
            }
            case 1: 
            case 2: {
                return this.contains(value.shortValue());
            }
            case 3: {
                return this.contains(value.intValue());
            }
            case 4: {
                return this.contains(value.floatValue());
            }
            case 5: {
                return this.contains(value.doubleValue());
            }
            case 6: {
                return this.contains(value.longValue());
            }
        }
        throw new IllegalArgumentException("Wrong data type");
    }

    public abstract DataType getDataType();

    public abstract boolean isPoint();

    public abstract Number getMax();

    public abstract Number getMin();

    public static enum DataType {
        BYTE(Byte.class, 0),
        USHORT(Short.class, 1),
        SHORT(Short.class, 2),
        INTEGER(Integer.class, 3),
        FLOAT(Float.class, 4),
        DOUBLE(Double.class, 5),
        LONG(Long.class, 6);

        private Class<?> classType;
        private int dataType;

        private DataType(Class<?> classType, int dataType) {
            this.classType = classType;
            this.dataType = dataType;
        }

        public Class<?> getClassValue() {
            return this.classType;
        }

        public int getDataType() {
            return this.dataType;
        }

        public static int dataTypeFromClass(Class<?> classType) {
            if (classType == ((Object)((Object)BYTE)).getClass()) {
                return BYTE.getDataType();
            }
            if (classType == ((Object)((Object)SHORT)).getClass()) {
                return SHORT.getDataType();
            }
            if (classType == ((Object)((Object)INTEGER)).getClass()) {
                return INTEGER.getDataType();
            }
            if (classType == ((Object)((Object)FLOAT)).getClass()) {
                return FLOAT.getDataType();
            }
            if (classType == ((Object)((Object)DOUBLE)).getClass()) {
                return DOUBLE.getDataType();
            }
            if (classType == ((Object)((Object)LONG)).getClass()) {
                return LONG.getDataType();
            }
            throw new IllegalArgumentException("This class does not belong to the already existing classes");
        }
    }
}

