/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.processing.jai;

import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import java.util.List;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ROI;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import org.geotools.processing.jai.nodata.Range;

public class BandMergeDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "BandMergeOp"}, {"LocalName", "BandMergeOp"}, {"Vendor", "org.geotools"}, {"Description", "Operation used for merging multiple images into a single multibanded image"}, {"DocURL", "Not Defined"}, {"Version", "1.0"}, {"arg0Desc", "NoData values"}, {"arg1Desc", "Destination No Data value"}, {"arg2Desc", "Transformations List"}, {"arg3Desc", "ROI object to use"}};
    private static final String[] paramNames = new String[]{"noData", "destinationNoData", "transformations", "roi"};
    private static final Class[] paramClasses = new Class[]{Range[].class, Double.class, List.class, ROI.class};
    private static final Object[] paramDefaults = new Object[]{null, 0.0, null, null};

    public BandMergeDescriptor() {
        super(resources, paramClasses, paramNames, paramDefaults);
    }

    public boolean isRenderableSupported() {
        return true;
    }

    public static RenderedOp create(Range[] noData, double destinationNoData, RenderingHints hints, RenderedImage ... sources) {
        return BandMergeDescriptor.create(noData, destinationNoData, hints, null, sources);
    }

    public static RenderedOp create(Range[] noData, double destinationNoData, RenderingHints hints, List<AffineTransform> transform, RenderedImage ... sources) {
        return BandMergeDescriptor.create(noData, destinationNoData, hints, transform, null, sources);
    }

    public static RenderedOp create(Range[] noData, double destinationNoData, RenderingHints hints, List<AffineTransform> transform, ROI roi, RenderedImage ... sources) {
        ParameterBlockJAI pb = new ParameterBlockJAI("BandMergeOp", "rendered");
        int numSources = sources.length;
        if (numSources <= 0) {
            throw new IllegalArgumentException("No resources are present");
        }
        for (int index = 0; index < numSources; ++index) {
            RenderedImage source = sources[index];
            if (source == null) {
                throw new IllegalArgumentException("This resource is null");
            }
            pb.setSource((Object)source, index);
        }
        if (transform != null && !transform.isEmpty() && transform.get(0) instanceof AffineTransform) {
            pb.setParameter("transformations", transform);
        }
        pb.setParameter("noData", (Object)noData);
        pb.setParameter("destinationNoData", destinationNoData);
        pb.setParameter("roi", (Object)roi);
        return JAI.create((String)"BandMergeOp", (ParameterBlock)pb, (RenderingHints)hints);
    }

    public static RenderableOp createRenderable(Range[] noData, double destinationNoData, RenderingHints hints, RenderableImage ... sources) {
        return BandMergeDescriptor.createRenderable(noData, destinationNoData, hints, null, sources);
    }

    public static RenderableOp createRenderable(Range[] noData, double destinationNoData, RenderingHints hints, List<AffineTransform> transform, RenderableImage ... sources) {
        return BandMergeDescriptor.createRenderable(noData, destinationNoData, hints, transform, null, sources);
    }

    public static RenderableOp createRenderable(Range[] noData, double destinationNoData, RenderingHints hints, List<AffineTransform> transform, ROI roi, RenderableImage ... sources) {
        ParameterBlockJAI pb = new ParameterBlockJAI("BandMergeOp", "renderable");
        int numSources = sources.length;
        if (numSources <= 0) {
            throw new IllegalArgumentException("No resources are present");
        }
        for (int index = 0; index < numSources; ++index) {
            RenderableImage source = sources[index];
            if (source == null) {
                throw new IllegalArgumentException("This resource is null");
            }
            pb.setSource((Object)source, index);
        }
        if (transform != null && !transform.isEmpty() && transform.get(0) instanceof AffineTransform) {
            pb.setParameter("transformations", transform);
        }
        pb.setParameter("noData", (Object)noData);
        pb.setParameter("destinationNoData", destinationNoData);
        pb.setParameter("roi", (Object)roi);
        return JAI.createRenderable((String)"BandMergeOp", (ParameterBlock)pb, (RenderingHints)hints);
    }
}

