/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.processing.jai;

import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.ArrayList;
import java.util.List;
import javax.media.jai.CRIFImpl;
import javax.media.jai.ImageLayout;
import javax.media.jai.ROI;
import org.geotools.processing.jai.BandMergeOpImage;
import org.geotools.processing.jai.ExtendedBandMergeOpImage;
import org.geotools.processing.jai.nodata.Range;

public class BandMergeCRIF
extends CRIFImpl {
    public BandMergeCRIF() {
        super("bandmergeOp");
    }

    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderHints) {
        ImageLayout layout = RIFUtil.getImageLayoutHint((RenderingHints)renderHints);
        int numSources = paramBlock.getNumSources();
        ArrayList<Object> sources = new ArrayList<Object>(numSources);
        for (int i = 0; i < numSources; ++i) {
            sources.add(paramBlock.getSource(i));
        }
        Range[] nodata = (Range[])paramBlock.getObjectParameter(0);
        double destinationNoData = paramBlock.getDoubleParameter(1);
        List transform = (List)paramBlock.getObjectParameter(2);
        ROI roi = (ROI)paramBlock.getObjectParameter(3);
        if (transform != null && !transform.isEmpty()) {
            return new ExtendedBandMergeOpImage(sources, transform, renderHints, nodata, roi, destinationNoData, layout);
        }
        return new BandMergeOpImage(sources, renderHints, nodata, roi, destinationNoData, layout);
    }
}

