/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.ArrayList;
import java.util.Collection;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.ViewType;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.image.jai.Registry;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.raster.CoverageUtilities;
import org.geotools.process.raster.RasterProcess;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.NumberRange;
import org.jaitools.media.jai.contour.ContourDescriptor;
import org.jaitools.media.jai.contour.ContourRIF;
import org.jaitools.numeric.Range;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.util.InternationalString;
import org.opengis.util.ProgressListener;

@DescribeProcess(title="Contour", description="Computes contour lines at specified intervals or levels for the values in a raster.")
public class ContourProcess
implements RasterProcess {
    private static final InternationalString NO_DATA = Vocabulary.formatInternational((int)147);

    public static SimpleFeatureCollection process(GridCoverage2D gc2d, Integer band, double[] levels, Double interval, Boolean simplify, Boolean smooth, Geometry roi, ProgressListener progressListener) throws ProcessException {
        ContourProcess process = new ContourProcess();
        return process.execute(gc2d, band, levels, interval, simplify, smooth, roi, progressListener);
    }

    @DescribeResult(name="result", description="Contour line features.  Contour level is in value attribute.")
    public SimpleFeatureCollection execute(@DescribeParameter(name="data", description="Input raster") GridCoverage2D gc2d, @DescribeParameter(name="band", description="Name of band to use for values to be contoured", min=0, max=1) Integer band, @DescribeParameter(name="levels", description="Values of levels at which to generate contours") double[] levels, @DescribeParameter(name="interval", description="Interval between contour values (ignored if levels parameter is supplied)", min=0, minValue=0.0) Double interval, @DescribeParameter(name="simplify", description="Indicates whether contour lines are simplified", min=0) Boolean simplify, @DescribeParameter(name="smooth", description="Indicates whether contour lines are smoothed using Bezier smoothing", min=0) Boolean smooth, @DescribeParameter(name="roi", description="Geometry delineating the region of interest (in raster coordinate system)", min=0) Geometry roi, ProgressListener progressListener) throws ProcessException {
        boolean hasValues;
        if (gc2d == null) {
            throw new ProcessException("Invalid input, source grid coverage should be not null");
        }
        if (band != null && (band < 0 || band >= gc2d.getNumSampleDimensions())) {
            throw new ProcessException("Invalid input, invalid band number:" + band);
        }
        boolean bl = hasValues = levels != null && levels.length != 0;
        if (!hasValues && interval == null) {
            throw new ProcessException("One between interval and values must be valid");
        }
        gc2d = gc2d.view(ViewType.GEOPHYSICS);
        AffineTransform mt2D = (AffineTransform)gc2d.getGridGeometry().getGridToCRS2D(PixelOrientation.CENTER);
        ArrayList<Double> noDataList = new ArrayList<Double>();
        for (GridSampleDimension sd : gc2d.getSampleDimensions()) {
            double[] sdNoData = sd.getNoDataValues();
            if (sdNoData != null) {
                for (double nodata : sdNoData) {
                    noDataList.add(nodata);
                }
            }
            if (sd.getCategories() == null) continue;
            for (Category cat : sd.getCategories()) {
                NumberRange catRange;
                if (!cat.getName().equals(NO_DATA) || Double.isNaN((catRange = cat.getRange()).getMinimum())) continue;
                if (catRange.getMinimum() == catRange.getMaximum()) {
                    noDataList.add(catRange.getMinimum());
                    continue;
                }
                Range noData = new Range((Number)catRange.getMinimum(), catRange.isMinIncluded(), (Number)catRange.getMaximum(), catRange.isMaxIncluded());
                noDataList.add((Double)noData);
            }
        }
        RenderedImage raster = gc2d.getRenderedImage();
        ParameterBlockJAI pb = new ParameterBlockJAI("Contour");
        pb.setSource("source0", (Object)raster);
        if (roi != null) {
            pb.setParameter("roi", (Object)CoverageUtilities.prepareROI(roi, mt2D));
        }
        if (band != null) {
            pb.setParameter("band", (Object)band);
        }
        if (levels != null && levels.length > 0) {
            ArrayList<Double> elements = new ArrayList<Double>(levels.length);
            for (double level : levels) {
                elements.add(level);
            }
            pb.setParameter("levels", elements);
        } else {
            pb.setParameter("interval", (Object)interval);
        }
        if (simplify != null) {
            pb.setParameter("simplify", (Object)simplify);
        }
        if (smooth != null) {
            pb.setParameter("smooth", (Object)smooth);
        }
        if (!noDataList.isEmpty()) {
            pb.setParameter("nodata", noDataList);
        }
        RenderedOp dest = JAI.create((String)"Contour", (ParameterBlock)pb);
        Collection prop = (Collection)dest.getProperty("contours");
        SimpleFeatureType schema = CoverageUtilities.createFeatureType(gc2d, LineString.class);
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(schema);
        int i = 0;
        ListFeatureCollection featureCollection = new ListFeatureCollection(schema);
        AffineTransformation jtsTransformation = new AffineTransformation(mt2D.getScaleX(), mt2D.getShearX(), mt2D.getTranslateX(), mt2D.getShearY(), mt2D.getScaleY(), mt2D.getTranslateY());
        for (LineString line : prop) {
            Double value = (Double)line.getUserData();
            line.setUserData(null);
            line.apply((CoordinateSequenceFilter)jtsTransformation);
            builder.set("the_geom", (Object)line);
            builder.set("value", (Object)value);
            featureCollection.add(builder.buildFeature(String.valueOf(i++)));
        }
        return featureCollection;
    }

    static {
        Registry.registerRIF((JAI)JAI.getDefaultInstance(), (OperationDescriptor)new ContourDescriptor(), (RenderedImageFactory)new ContourRIF(), (String)"org.jaitools.media.jai");
    }
}

