/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import java.awt.geom.AffineTransform;
import javax.media.jai.Interpolation;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.raster.RasterProcess;
import org.opengis.coverage.processing.Operation;
import org.opengis.parameter.ParameterValueGroup;

@DescribeProcess(title="Transformed Coverage", description="Returns the result of an Affine transformation on the input raster.")
public class AffineProcess
implements RasterProcess {
    private static final CoverageProcessor PROCESSOR = CoverageProcessor.getInstance();
    private static final Operation AFFINE = PROCESSOR.getOperation("Affine");

    @DescribeResult(name="result", description="Raster transformed by an Affine transformation")
    public GridCoverage2D execute(@DescribeParameter(name="coverage", description="Input raster", min=1) GridCoverage2D coverage, @DescribeParameter(name="scalex", description="Scale parameter for the X direction", min=0) Double scaleX, @DescribeParameter(name="scaley", description="Scale parameter for the Y direction", min=0) Double scaleY, @DescribeParameter(name="shearx", description="Shear parameter for the X direction", min=0) Double shearX, @DescribeParameter(name="sheary", description="Shear parameter for the Y direction", min=0) Double shearY, @DescribeParameter(name="translatex", description="Offset parameter for the X direction", min=0) Double translateX, @DescribeParameter(name="translatey", description="Offset parameter for the Y direction", min=0) Double translateY, @DescribeParameter(name="nodata", description="Output coverage nodata values", min=0) double[] nodata, @DescribeParameter(name="interpolation", description="Interpolation function to use.  Values are NEAREST, BILINEAR, BICUBIC2, BICUBIC", min=0) Interpolation interp) throws ProcessException {
        double xScale = scaleX != null ? scaleX : 1.0;
        double yScale = scaleY != null ? scaleY : 1.0;
        double xShear = shearX != null ? shearX : 0.0;
        double yShear = shearY != null ? shearY : 0.0;
        double xTrans = translateX != null ? translateX : 0.0;
        double yTrans = translateY != null ? translateY : 0.0;
        AffineTransform transform = new AffineTransform(xScale, yShear, xShear, yScale, xTrans, yTrans);
        ParameterValueGroup params = AFFINE.getParameters();
        params.parameter("Source").setValue((Object)coverage);
        params.parameter("transform").setValue((Object)transform);
        if (nodata != null) {
            params.parameter("backgroundValues").setValue((Object)nodata);
        }
        if (interp != null) {
            params.parameter("interpolation").setValue((Object)interp);
        }
        return (GridCoverage2D)PROCESSOR.doOperation(params);
    }
}

