/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.tool;

import java.awt.Rectangle;
import java.lang.ref.WeakReference;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.map.GridReaderLayer;
import org.geotools.map.Layer;
import org.geotools.parameter.Parameter;
import org.geotools.resources.geometry.XRectangle2D;
import org.geotools.swing.tool.InfoToolHelper;
import org.geotools.swing.tool.InfoToolHelperUtils;
import org.geotools.swing.tool.InfoToolResult;
import org.opengis.coverage.PointOutsideCoverageException;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;

public class GridReaderLayerHelper
extends InfoToolHelper {
    private static final int CACHED_RASTER_WIDTH = 20;
    private WeakReference<GridCoverage2DReader> sourceRef;
    private GridCoverage2D cachedCoverage;

    @Override
    public boolean isSupportedLayer(Layer layer) {
        return layer instanceof GridReaderLayer;
    }

    @Override
    public void setLayer(Layer layer) {
        if (!(layer instanceof GridReaderLayer)) {
            throw new IllegalArgumentException("layer must be an instance of GridReaderLayer");
        }
        super.setLayer(layer);
        this.sourceRef = new WeakReference<GridCoverage2DReader>(((GridReaderLayer)layer).getReader());
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.sourceRef != null && this.sourceRef.get() != null;
    }

    @Override
    public InfoToolResult getInfo(DirectPosition2D pos) throws Exception {
        InfoToolResult result = new InfoToolResult();
        if (this.isValid()) {
            DirectPosition2D trPos = InfoToolHelperUtils.getTransformed(pos, this.getContentToLayerTransform());
            if (!(this.cachedCoverage != null && this.cachedCoverage.getEnvelope2D().contains(trPos) || this.renewCachedCoverage(trPos))) {
                return result;
            }
            try {
                Object objArray = this.cachedCoverage.evaluate((DirectPosition)trPos);
                Number[] bandValues = InfoToolHelperUtils.asNumberArray(objArray);
                if (bandValues != null) {
                    result.newFeature("Raw values");
                    for (int i = 0; i < bandValues.length; ++i) {
                        result.setFeatureValue("Band " + i, (Object)bandValues[i]);
                    }
                }
            }
            catch (PointOutsideCoverageException e) {
                // empty catch block
            }
        }
        return result;
    }

    private boolean renewCachedCoverage(DirectPosition centrePos) {
        Rectangle queryRect = this.createQueryGridEnvelope(centrePos);
        if (queryRect.isEmpty()) {
            return false;
        }
        GridCoverage2DReader reader = (GridCoverage2DReader)this.sourceRef.get();
        Parameter<GridGeometry2D> parameter = new Parameter<GridGeometry2D>(AbstractGridFormat.READ_GRIDGEOMETRY2D, new GridGeometry2D((GridEnvelope)new GridEnvelope2D(queryRect), reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER), reader.getCoordinateReferenceSystem()));
        try {
            this.cachedCoverage = reader.read(new GeneralParameterValue[]{parameter});
            return this.cachedCoverage != null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private Rectangle createQueryGridEnvelope(DirectPosition pos) {
        GridCoverage2DReader reader = (GridCoverage2DReader)this.sourceRef.get();
        try {
            MathTransform worldToGridTransform = reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER).inverse();
            DirectPosition midPos = worldToGridTransform.transform(pos, null);
            int x = (int)midPos.getOrdinate(0);
            int y = (int)midPos.getOrdinate(1);
            int halfWidth = 10;
            Rectangle queryRect = new Rectangle(x - halfWidth, y - halfWidth, 20, 20);
            GridEnvelope gridEnv = reader.getOriginalGridRange();
            Rectangle rect = new Rectangle(gridEnv.getLow(0), gridEnv.getLow(1), gridEnv.getSpan(0), gridEnv.getSpan(1));
            XRectangle2D.intersect(queryRect, rect, queryRect);
            return queryRect;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

