/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing;

import java.awt.Graphics2D;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.geotools.map.MapContent;
import org.geotools.map.MapViewport;
import org.geotools.renderer.GTRenderer;
import org.geotools.swing.RenderingExecutor;
import org.geotools.swing.RenderingExecutorEvent;
import org.geotools.swing.RenderingExecutorListener;
import org.geotools.swing.RenderingOperands;
import org.geotools.swing.RenderingTask;
import org.geotools.swing.SingleLayerMapContent;

public class DefaultRenderingExecutor
implements RenderingExecutor {
    private final AtomicLong NEXT_ID = new AtomicLong(1L);
    private final ExecutorService taskExecutor;
    private final ScheduledExecutorService watchExecutor;
    private ScheduledFuture<?> watcher;
    private CountDownLatch tasksLatch = new CountDownLatch(0);
    public static final long DEFAULT_POLLING_INTERVAL = 20L;
    private long pollingInterval = 20L;
    private List<TaskInfo> currentTasks = new CopyOnWriteArrayList<TaskInfo>();

    public DefaultRenderingExecutor() {
        this.taskExecutor = Executors.newCachedThreadPool();
        this.watchExecutor = Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory());
        this.startPolling();
    }

    @Override
    public long getPollingInterval() {
        return this.pollingInterval;
    }

    @Override
    public void setPollingInterval(long interval) {
        if (interval > 0L && interval != this.pollingInterval) {
            this.pollingInterval = interval;
            this.restartPolling();
        }
    }

    @Override
    public synchronized long submit(MapContent mapContent, GTRenderer renderer, Graphics2D graphics, RenderingExecutorListener listener) {
        long rtnValue = -1L;
        if (this.taskExecutor.isShutdown()) {
            throw new IllegalStateException("Calling submit after the executor has been shutdown");
        }
        if (mapContent == null) {
            throw new IllegalArgumentException("mapContent must not be null");
        }
        if (graphics == null) {
            throw new IllegalArgumentException("graphics must not be null");
        }
        if (mapContent.getViewport().isEmpty()) {
            throw new IllegalArgumentException("The viewport must not be empty");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (this.tasksLatch.getCount() == 0L) {
            this.tasksLatch = new CountDownLatch(1);
            long id = this.NEXT_ID.getAndIncrement();
            RenderingExecutorEvent event = new RenderingExecutorEvent(this, id);
            listener.onRenderingStarted(event);
            RenderingTask task = new RenderingTask(mapContent, graphics, renderer);
            Future<Boolean> future = this.taskExecutor.submit(task);
            this.currentTasks.add(new TaskInfo(id, task, mapContent, future, listener));
            rtnValue = id;
        }
        return rtnValue;
    }

    @Override
    public long submit(MapContent mapContent, List<RenderingOperands> operands, RenderingExecutorListener listener) {
        long rtnValue = -1L;
        if (this.taskExecutor.isShutdown()) {
            throw new IllegalStateException("Calling submit after the executor has been shutdown");
        }
        if (mapContent == null) {
            throw new IllegalArgumentException("mapContent must not be null");
        }
        if (mapContent.getViewport().isEmpty()) {
            throw new IllegalArgumentException("The viewport must not be empty");
        }
        if (operands == null || operands.isEmpty()) {
            throw new IllegalArgumentException("operands list must not be null or empty");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (this.tasksLatch.getCount() == 0L) {
            this.tasksLatch = new CountDownLatch(operands.size());
            long id = this.NEXT_ID.getAndIncrement();
            RenderingExecutorEvent event = new RenderingExecutorEvent(this, id);
            listener.onRenderingStarted(event);
            MapViewport vp = new MapViewport(mapContent.getViewport());
            vp.setEditable(false);
            for (RenderingOperands op : operands) {
                SingleLayerMapContent mc = new SingleLayerMapContent(op.getLayer());
                mc.setViewport(vp);
                op.getRenderer().setMapContent((MapContent)mc);
                RenderingTask task = new RenderingTask(mapContent, op.getGraphics(), op.getRenderer());
                Future<Boolean> future = this.taskExecutor.submit(task);
                this.currentTasks.add(new TaskInfo(id, task, mc, future, listener));
            }
            rtnValue = id;
        }
        return rtnValue;
    }

    @Override
    public synchronized void cancel(long taskId) {
        if (!this.currentTasks.isEmpty() && this.currentTasks.get((int)0).id == taskId) {
            this.cancelAll();
        }
    }

    @Override
    public synchronized void cancelAll() {
        for (TaskInfo info : this.currentTasks) {
            info.task.cancel();
        }
    }

    @Override
    public void shutdown() {
        if (this.taskExecutor != null && !this.taskExecutor.isShutdown()) {
            this.taskExecutor.shutdown();
            this.watchExecutor.shutdown();
        }
    }

    @Override
    public boolean isShutdown() {
        return this.taskExecutor.isShutdown();
    }

    private void pollTaskResult() {
        for (TaskInfo info : this.currentTasks) {
            if (info.polledDone || !info.future.isDone()) continue;
            info.polledDone = true;
            Boolean result = null;
            try {
                result = info.future.get();
            }
            catch (CancellationException ex) {
                result = false;
            }
            catch (Exception ex) {
                throw new IllegalStateException("When getting rendering result", ex);
            }
            RenderingExecutorEvent event = new RenderingExecutorEvent(this, info.id);
            if (!result.booleanValue()) {
                info.listener.onRenderingFailed(event);
                continue;
            }
            this.tasksLatch.countDown();
            if (this.tasksLatch.getCount() != 0L) continue;
            this.currentTasks.remove(info);
            info.listener.onRenderingCompleted(event);
            break;
        }
    }

    private void startPolling() {
        this.watcher = this.watchExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                DefaultRenderingExecutor.this.pollTaskResult();
            }
        }, this.pollingInterval, this.pollingInterval, TimeUnit.MILLISECONDS);
    }

    private void restartPolling() {
        this.stopPolling();
        this.startPolling();
    }

    private void stopPolling() {
        if (this.watcher != null && !this.watcher.isDone()) {
            this.watcher.cancel(false);
        }
    }

    private static class TaskInfo {
        final long id;
        final RenderingTask task;
        final MapContent mapContent;
        final Future<Boolean> future;
        final RenderingExecutorListener listener;
        boolean polledDone;

        TaskInfo(long id, RenderingTask task, MapContent mapContent, Future<Boolean> future, RenderingExecutorListener listener) {
            this.id = id;
            this.task = task;
            this.mapContent = mapContent;
            this.future = future;
            this.listener = listener;
            this.polledDone = false;
        }
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    }
}

