/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.relate;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.filter.IllegalFilterException;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.relate.RelationIntegrity;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.Disjoint;

public class OverlapsIntegrity
extends RelationIntegrity {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.validation");
    private static HashSet usedIDs;
    private boolean showPrintLines = true;

    public OverlapsIntegrity() {
        usedIDs = new HashSet();
    }

    @Override
    public boolean validate(Map layers, ReferencedEnvelope envelope, ValidationResults results) throws Exception {
        LOGGER.finer("Starting test " + this.getName() + " (" + this.getClass().getName() + ")");
        String typeRef1 = this.getGeomTypeRefA();
        LOGGER.finer(typeRef1 + ": looking up FeatureSource");
        SimpleFeatureSource geomSource1 = (SimpleFeatureSource)layers.get(typeRef1);
        LOGGER.finer(typeRef1 + ": found " + ((SimpleFeatureType)geomSource1.getSchema()).getTypeName());
        String typeRef2 = this.getGeomTypeRefB();
        if (typeRef2 == "" || typeRef1.equals(typeRef2)) {
            return this.validateSingleLayer(geomSource1, this.isExpected(), results, envelope);
        }
        LOGGER.warning(typeRef2 + ": looking up SimpleFeatureSource ");
        SimpleFeatureSource geomSource2 = (SimpleFeatureSource)layers.get(typeRef2);
        LOGGER.finer(typeRef2 + ": found " + ((SimpleFeatureType)geomSource2.getSchema()).getTypeName());
        return this.validateMultipleLayers(geomSource1, geomSource2, this.isExpected(), results, envelope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateMultipleLayers(SimpleFeatureSource featureSourceA, SimpleFeatureSource featureSourceB, boolean expected, ValidationResults results, ReferencedEnvelope bBox) throws Exception {
        boolean success = true;
        int errors = 0;
        int countInterval = 100;
        int counter = 0;
        SimpleFeatureType ft = (SimpleFeatureType)featureSourceA.getSchema();
        Filter filter = OverlapsIntegrity.filterBBox(bBox, ft);
        SimpleFeatureCollection collectionA = featureSourceA.getFeatures();
        SimpleFeatureIterator fr2 = null;
        try (SimpleFeatureIterator fr1 = null;){
            fr1 = collectionA.features();
            if (fr1 == null) {
                boolean bl = success;
                return bl;
            }
            while (fr1.hasNext()) {
                ++counter;
                SimpleFeature f1 = (SimpleFeature)fr1.next();
                Geometry g1 = (Geometry)f1.getDefaultGeometry();
                Filter filter2 = OverlapsIntegrity.filterBBox(ReferencedEnvelope.reference(g1.getEnvelope().getEnvelopeInternal()), ft);
                SimpleFeatureCollection collectionB = featureSourceB.getFeatures(filter2);
                fr2 = collectionB.features();
                try {
                    while (fr2 != null && fr2.hasNext()) {
                        SimpleFeature f2 = (SimpleFeature)fr2.next();
                        Geometry g2 = (Geometry)f2.getDefaultGeometry();
                        if (usedIDs.contains(f2.getID()) || f1.getID().equals(f2.getID()) || g1.overlaps(g2) == expected && g1.contains(g2) == expected) continue;
                        results.error(f1, this.getGeomTypeRefA() + "(" + f1.getID() + ")" + " overlapped " + this.getGeomTypeRefB() + "(" + f2.getID() + ")");
                        if (this.showPrintLines) {
                            // empty if block
                        }
                        success = false;
                        ++errors;
                    }
                    usedIDs.add(f1.getID());
                    if (counter % countInterval != 0 || !this.showPrintLines) continue;
                    System.out.println("count: " + counter);
                }
                finally {
                    fr2.close();
                }
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateSingleLayer(SimpleFeatureSource featureSourceA, boolean expected, ValidationResults results, ReferencedEnvelope bBox) throws Exception {
        boolean success = true;
        int errors = 0;
        Date date1 = new Date();
        int countInterval = 100;
        int counter = 0;
        SimpleFeatureType ft = (SimpleFeatureType)featureSourceA.getSchema();
        System.out.println("---------------- In Overlaps Integrity ----------------");
        SimpleFeatureCollection collectionA = null;
        if (bBox != null && !bBox.isNull() && bBox.getHeight() != 0.0 && bBox.getWidth() != 0.0) {
            Filter filter = OverlapsIntegrity.filterBBox(bBox, ft);
            collectionA = featureSourceA.getFeatures(filter);
        } else {
            collectionA = featureSourceA.getFeatures();
        }
        SimpleFeatureIterator fr1 = null;
        SimpleFeatureIterator fr2 = null;
        try {
            fr1 = collectionA.features();
            if (fr1 == null) {
                boolean bl = success;
                return bl;
            }
            while (fr1.hasNext()) {
                ++counter;
                SimpleFeature f1 = (SimpleFeature)fr1.next();
                Geometry g1 = (Geometry)f1.getDefaultGeometry();
                Filter filter2 = OverlapsIntegrity.filterBBox(ReferencedEnvelope.reference(g1.getEnvelope().getEnvelopeInternal()), ft);
                SimpleFeatureCollection collectionB = featureSourceA.getFeatures(filter2);
                fr2 = collectionB.features();
                try {
                    while (fr2 != null && fr2.hasNext()) {
                        SimpleFeature f2 = (SimpleFeature)fr2.next();
                        Geometry g2 = (Geometry)f2.getDefaultGeometry();
                        if (usedIDs.contains(f2.getID()) || f1.getID().equals(f2.getID()) || g1.relate(g2, "1********") == expected) continue;
                        if (results != null) {
                            results.error(f1, "" + this.getGeomTypeRefA() + "(" + f1.getID() + ")" + " overlapped " + this.getGeomTypeRefA() + "(" + f2.getID() + ")");
                        }
                        if (this.showPrintLines) {
                            // empty if block
                        }
                        success = false;
                        ++errors;
                    }
                    usedIDs.add(f1.getID());
                }
                finally {
                    fr2.close();
                }
            }
        }
        finally {
            Date date2 = new Date();
            float dt = date2.getTime() - date1.getTime();
            if (this.showPrintLines) {
                System.out.println("########## Validation duration: " + dt);
                System.out.println("########## Validation errors: " + errors);
            }
            fr1.close();
        }
        return success;
    }

    public static Filter filterBBox(Envelope bBox, SimpleFeatureType ft) throws FactoryRegistryException, IllegalFilterException {
        if (bBox == null) {
            return Filter.INCLUDE;
        }
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        PropertyName geomExpr = ff.property(ft.getGeometryDescriptor().getLocalName());
        Literal bboxExpr = ff.literal((Object)JTS.toGeometry(bBox));
        Disjoint disjointFilter = ff.disjoint((Expression)geomExpr, (Expression)bboxExpr);
        return ff.not((Filter)disjointFilter);
    }
}

