/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagepyramid;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.data.DataUtilities;
import org.geotools.data.PrjFileReader;
import org.geotools.factory.Hints;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagepyramid.ImagePyramidReader;
import org.geotools.gce.imagepyramid.Utils;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class ImagePyramidFormat
extends AbstractGridFormat
implements Format {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.gce.imagepyramid");

    public ImagePyramidFormat() {
        this.setInfo();
    }

    private void setInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("name", "ImagePyramid");
        info.put("description", "Image pyramidal plugin");
        info.put("vendor", "Geotools");
        info.put("docURL", "");
        info.put("version", "1.0");
        this.mInfo = info;
        this.readParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D, INPUT_TRANSPARENT_COLOR, ImageMosaicFormat.OUTPUT_TRANSPARENT_COLOR, USE_JAI_IMAGEREAD, ImageMosaicFormat.BACKGROUND_VALUES, SUGGESTED_TILE_SIZE, ImageMosaicFormat.ALLOW_MULTITHREADING, ImageMosaicFormat.MAX_ALLOWED_TILES, ImageMosaicFormat.ELEVATION, ImageMosaicFormat.TIME, ImageMosaicFormat.FADING}));
        this.writeParameters = null;
    }

    public ImagePyramidReader getReader(Object source) {
        return this.getReader(source, null);
    }

    public GridCoverageWriter getWriter(Object destination) {
        throw new UnsupportedOperationException("This plugin is a read only plugin!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean accepts(Object source, Hints hints) {
        if (source == null) {
            throw new NullPointerException("Null parameter provided to the accepts method of this ImagePyramidFormat");
        }
        try {
            String[] pair;
            PrjFileReader crsReader;
            URL sourceURL;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Accepts method of ImagePyramid with source" + source);
            }
            if ((sourceURL = Utils.checkSource(source, hints)) == null) {
                return false;
            }
            LOGGER.fine("accepts: " + sourceURL);
            try {
                sourceURL.openStream().close();
            }
            catch (Throwable e) {
                if (!LOGGER.isLoggable(Level.FINE)) return false;
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                return false;
            }
            URL prjURL = DataUtilities.changeUrlExt(sourceURL, "prj");
            try {
                crsReader = new PrjFileReader(Channels.newChannel(prjURL.openStream()));
            }
            catch (FactoryException e) {
                return false;
            }
            CoordinateReferenceSystem tempcrs = crsReader.getCoordinateReferenceSystem();
            if (tempcrs == null) {
                tempcrs = AbstractGridFormat.getDefaultCRS();
                LOGGER.log(Level.FINE, "Unable to find a CRS for this coverage, using a default one: " + tempcrs.toWKT());
            }
            Properties properties = new Properties();
            BufferedInputStream propertyStream = null;
            if (!sourceURL.getPath().endsWith(".properties")) {
                return false;
            }
            LOGGER.fine("loading properties from: " + sourceURL);
            try (InputStream openStream = sourceURL.openStream();){
                propertyStream = new BufferedInputStream(openStream);
                properties.load(propertyStream);
            }
            String envelope = properties.getProperty("Envelope2D");
            if (envelope == null) {
                return false;
            }
            String[] pairs = envelope.split(" ");
            double[][] cornersV = new double[2][2];
            for (int i = 0; i < 2; ++i) {
                pair = pairs[i].split(",");
                cornersV[i][0] = Double.parseDouble(pair[0]);
                cornersV[i][1] = Double.parseDouble(pair[1]);
            }
            int numOverviews = Integer.parseInt(properties.getProperty("LevelsNum")) - 1;
            String levels = properties.getProperty("Levels");
            pairs = levels.split(" ");
            double[][] overViewResolutions = numOverviews >= 1 ? new double[numOverviews][2] : (double[][])null;
            pair = pairs[0].split(",");
            double[] highestRes = new double[]{Double.parseDouble(pair[0]), Double.parseDouble(pair[1])};
            int i = 1;
            while (true) {
                if (i >= numOverviews + 1) {
                    if (properties.getProperty("Name") != null) return true;
                    return false;
                }
                pair = pairs[i].split(",");
                overViewResolutions[i - 1][0] = Double.parseDouble(pair[0]);
                overViewResolutions[i - 1][1] = Double.parseDouble(pair[1]);
                ++i;
            }
        }
        catch (Exception e) {
            if (!LOGGER.isLoggable(Level.FINE)) return false;
            LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            return false;
        }
    }

    public ImagePyramidReader getReader(Object source, Hints hints) {
        try {
            return new ImagePyramidReader(source, hints);
        }
        catch (MalformedURLException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.severe(new StringBuffer("impossible to get a reader for the provided source. The error is ").append(e.getLocalizedMessage()).toString());
            }
            return null;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.severe(new StringBuffer("impossible to get a reader for the provided source. The error is ").append(e.getLocalizedMessage()).toString());
            }
            return null;
        }
    }

    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        throw new UnsupportedOperationException("Unsupported method.");
    }

    public GridCoverageWriter getWriter(Object destination, Hints hints) {
        throw new UnsupportedOperationException("Unsupported method.");
    }
}

