/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.chart;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.geotools.renderer.style.ExternalGraphicFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.eastwood.ChartEngine;
import org.jfree.eastwood.Parameters;
import org.opengis.feature.Feature;
import org.opengis.filter.expression.Expression;

public class ChartGraphicFactory
implements ExternalGraphicFactory {
    public static final String FORMAT = "application/chart";
    private static final String HTTP_CHART = "http://chart?";

    @Override
    public Icon getIcon(Feature feature, Expression urlExpression, String format, int size) throws Exception {
        String url = (String)urlExpression.evaluate((Object)feature, String.class);
        if (!this.validRequest(url, format)) {
            return null;
        }
        Map params = Parameters.parseQueryString((String)url.substring(HTTP_CHART.length()));
        JFreeChart chart = ChartEngine.buildChart((Map)params);
        int[] chartSize = this.computeChartSize(size, params);
        return new ImageIcon(this.drawChart(chart, chartSize[0], chartSize[1]));
    }

    private boolean validRequest(String url, String format) {
        return FORMAT.equals(format) && url.startsWith(HTTP_CHART);
    }

    JFreeChart getChart(Feature feature, Expression urlExpression, String format, int size) throws Exception {
        String url = (String)urlExpression.evaluate((Object)feature, String.class);
        if (!this.validRequest(url, format)) {
            return null;
        }
        Map params = Parameters.parseQueryString((String)url.substring(HTTP_CHART.length()));
        return ChartEngine.buildChart((Map)params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BufferedImage drawChart(JFreeChart chart, int w, int h) {
        BufferedImage bi = new BufferedImage(w, h, 6);
        Graphics2D gr = bi.createGraphics();
        try {
            chart.draw(gr, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, w, h));
        }
        finally {
            gr.dispose();
        }
        return bi;
    }

    int[] computeChartSize(int size, Map params) {
        String[] sizes = (String[])params.get("chs");
        int[] dims = null;
        if (sizes != null) {
            dims = this.parseCHS(sizes);
        }
        if (dims == null && size <= 0) {
            throw new IllegalArgumentException("Chart size cannot be computed, a SLD size is missing, so is the chs chart param");
        }
        if (size > 0) {
            if (dims == null) {
                dims = new int[]{size, size};
            } else if (dims[0] > dims[1]) {
                dims[1] = dims[1] * size / dims[0];
                dims[0] = size;
            } else {
                dims[0] = dims[0] * size / dims[1];
                dims[1] = size;
            }
        }
        return dims;
    }

    int[] parseCHS(String[] sizes) {
        int[] dims = new int[2];
        String[] xy = sizes[0].split("x");
        if (xy.length != 2) {
            throw new IllegalArgumentException("The chs parameter should be in wxh form, where w and h are measured in pixels");
        }
        dims[0] = Integer.parseInt(xy[0]);
        dims[1] = Integer.parseInt(xy[1]);
        return dims;
    }
}

