/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalogbuilder;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.geotools.factory.Hints;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.index.Indexer;
import org.geotools.gce.imagemosaic.catalog.index.IndexerUtils;
import org.geotools.gce.imagemosaic.catalog.index.ParametersType;
import org.geotools.gce.imagemosaic.catalog.index.SchemaType;
import org.geotools.gce.imagemosaic.catalog.index.SchemasType;
import org.geotools.util.Utilities;

public class CatalogBuilderConfiguration {
    private Hints hints;
    private String timeAttribute;
    private String runtimeAttribute;
    private Indexer indexer;

    public String getEnvelope2D() {
        return this.getParameter("Envelope2D");
    }

    public CatalogBuilderConfiguration() {
        this.initDefaultsParam();
    }

    private void initDefaultsParam() {
        Indexer defaultIndexer = Utils.OBJECT_FACTORY.createIndexer();
        ParametersType parameters = Utils.OBJECT_FACTORY.createParametersType();
        List<ParametersType.Parameter> parameterList = parameters.getParameter();
        defaultIndexer.setParameters(parameters);
        this.setIndexer(defaultIndexer);
        IndexerUtils.setParam(parameterList, "LocationAttribute", "location");
        IndexerUtils.setParam(parameterList, "Wildcard", "*.*");
        IndexerUtils.setParam(parameterList, "FootprintManagement", Boolean.toString(true));
        IndexerUtils.setParam(parameterList, "AbsolutePath", Boolean.toString(false));
        IndexerUtils.setParam(parameterList, "Recursive", Boolean.toString(true));
        IndexerUtils.setParam(parameterList, "Name", "index");
    }

    public CatalogBuilderConfiguration(CatalogBuilderConfiguration that) {
        Utilities.ensureNonNull((String)"CatalogBuilderConfiguration", (Object)that);
        this.initDefaultsParam();
        try {
            BeanUtils.copyProperties((Object)this, (Object)that);
        }
        catch (IllegalAccessException e) {
            IllegalArgumentException iae = new IllegalArgumentException(e);
            throw iae;
        }
        catch (InvocationTargetException e) {
            IllegalArgumentException iae = new IllegalArgumentException(e);
            throw iae;
        }
    }

    public Hints getHints() {
        return this.hints;
    }

    public void setHints(Hints hints) {
        this.hints = hints;
    }

    public boolean isRecursive() {
        return Boolean.parseBoolean(this.getParameter("Recursive"));
    }

    public boolean isCaching() {
        return Boolean.parseBoolean(this.getParameter("Caching"));
    }

    public String getSchema(String name) {
        SchemasType schemas = this.indexer.getSchemas();
        if (schemas != null) {
            List<SchemaType> schemaList = schemas.getSchema();
            for (SchemaType schema : schemaList) {
                if (!schema.getName().equalsIgnoreCase(name)) continue;
                return schema.getAttributes();
            }
        }
        return null;
    }

    public void setParameter(String parameterName, String parameterValue) {
        List<ParametersType.Parameter> params = this.indexer.getParameters().getParameter();
        parameterValue = IndexerUtils.refineParameterValue(parameterName, parameterValue);
        for (ParametersType.Parameter param : params) {
            if (!param.getName().equalsIgnoreCase(parameterName)) continue;
            param.setValue(parameterValue);
            return;
        }
        ParametersType.Parameter param = Utils.OBJECT_FACTORY.createParametersTypeParameter();
        param.setName(parameterName);
        param.setValue(parameterValue);
        params.add(param);
    }

    public String getParameter(String parameterName) {
        return IndexerUtils.getParameter(parameterName, this.indexer);
    }

    public String getTimeAttribute() {
        return this.timeAttribute;
    }

    public Indexer getIndexer() {
        return this.indexer;
    }

    public void setIndexer(Indexer indexer) {
        this.indexer = indexer;
    }

    public String getRuntimeAttribute() {
        return this.runtimeAttribute;
    }

    public void setRuntimeAttribute(String runtimeAttribute) {
        this.runtimeAttribute = runtimeAttribute;
    }

    public String getIndexName() {
        return this.getParameter("Name");
    }

    public boolean isFootprintManagement() {
        return Boolean.parseBoolean(this.getParameter("FootprintManagement"));
    }

    public String getLocationAttribute() {
        return this.getParameter("LocationAttribute");
    }

    public String getRootMosaicDirectory() {
        return this.getParameter("RootMosaicDirectory");
    }

    public String getWildcard() {
        return this.getParameter("Wildcard");
    }

    public boolean isAbsolute() {
        return Boolean.parseBoolean(this.getParameter("AbsolutePath"));
    }

    public CatalogBuilderConfiguration clone() throws CloneNotSupportedException {
        return new CatalogBuilderConfiguration(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CatalogBuilderConfiguration)) {
            return false;
        }
        CatalogBuilderConfiguration that = (CatalogBuilderConfiguration)obj;
        if (!CatalogBuilderConfiguration.equalsParameter(this, that, "AbsolutePath")) {
            return false;
        }
        if (!CatalogBuilderConfiguration.equalsParameter(this, that, "Caching")) {
            return false;
        }
        if (!CatalogBuilderConfiguration.equalsParameter(this, that, "Recursive")) {
            return false;
        }
        if (!CatalogBuilderConfiguration.equalsParameter(this, that, "FootprintManagement")) {
            return false;
        }
        if (!CatalogBuilderConfiguration.equalsParameter(this, that, "Name")) {
            return false;
        }
        if (!CatalogBuilderConfiguration.equalsParameter(this, that, "LocationAttribute")) {
            return false;
        }
        return CatalogBuilderConfiguration.equalsParameter(this, that, "RootMosaicDirectory");
    }

    private static boolean equalsParameter(CatalogBuilderConfiguration thisConfig, CatalogBuilderConfiguration thatConfig, String parameterName) {
        String thisValue = thisConfig.getParameter(parameterName);
        String thatValue = thatConfig.getParameter(parameterName);
        return thisValue == null && thatValue == null || thisValue.equals(thatValue);
    }

    public int hashCode() {
        int seed = 37;
        seed = Utilities.hash((boolean)Boolean.parseBoolean(this.getParameter("AbsolutePath")), (int)seed);
        seed = Utilities.hash((boolean)Boolean.parseBoolean(this.getParameter("Recursive")), (int)seed);
        seed = Utilities.hash((boolean)Boolean.parseBoolean(this.getParameter("Caching")), (int)seed);
        seed = Utilities.hash((boolean)Boolean.parseBoolean(this.getParameter("FootprintManagement")), (int)seed);
        seed = Utilities.hash((Object)this.getParameter("LocationAttribute"), (int)seed);
        seed = Utilities.hash((Object)this.getParameter("Name"), (int)seed);
        seed = Utilities.hash((Object)this.getParameter("Wildcard"), (int)seed);
        seed = Utilities.hash((Object)this.getParameter("RootMosaicDirectory"), (int)seed);
        return seed;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CatalogBuilderConfiguration").append("\n");
        builder.append("wildcardString:\t\t\t").append(this.getParameter("Wildcard")).append("\n");
        builder.append("indexName:\t\t\t").append(this.getParameter("Name")).append("\n");
        builder.append("absolute:\t\t\t").append(Boolean.parseBoolean(this.getParameter("AbsolutePath"))).append("\n");
        builder.append("caching:\t\t\t").append(Boolean.parseBoolean(this.getParameter("Caching"))).append("\n");
        builder.append("recursive:\t\t\t").append(Boolean.parseBoolean(this.getParameter("Recursive"))).append("\n");
        builder.append("footprintManagement:\t\t\t").append(Boolean.parseBoolean(this.getParameter("FootprintManagement"))).append("\n");
        builder.append("locationAttribute:\t\t\t").append(this.getParameter("LocationAttribute")).append("\n");
        builder.append("rootMosaicDirectory:\t\t\t").append(this.getParameter("RootMosaicDirectory")).append("\n");
        return builder.toString();
    }

    public void check() {
        String indexingDirs = this.getParameter("IndexingDirectories");
        if (indexingDirs == null) {
            String customDirs;
            indexingDirs = customDirs = this.getParameter("HarvestingDirectory");
        }
        if (indexingDirs == null) {
            throw new IllegalStateException("Indexing directories are empty");
        }
        String[] indexingDirectoriesString = indexingDirs.split("\\s*,\\s*");
        if (indexingDirectoriesString == null || indexingDirectoriesString.length <= 0) {
            throw new IllegalStateException("Indexing directories are empty");
        }
        String indexName = this.getParameter("Name");
        if (indexName == null || indexName.length() == 0) {
            throw new IllegalStateException("Index name cannot be empty");
        }
        String rootMosaicDirectory = this.getParameter("RootMosaicDirectory");
        if (rootMosaicDirectory == null || rootMosaicDirectory.length() == 0) {
            throw new IllegalStateException("RootMosaicDirectory name cannot be empty");
        }
        rootMosaicDirectory = Utils.checkDirectory(rootMosaicDirectory, true);
        String wildcard = this.getParameter("Wildcard");
        if (wildcard == null || wildcard.length() == 0) {
            throw new IllegalStateException("WildcardString name cannot be empty");
        }
    }
}

