/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.InStream;
import com.vividsolutions.jts.io.InputStreamInStream;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKTReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.geotools.data.DataUtilities;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.gce.imagemosaic.catalog.FootprintGeometryProvider;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;

public class SidecarFootprintProvider
implements FootprintGeometryProvider {
    static final Logger LOGGER = Logging.getLogger(SidecarFootprintProvider.class);
    static final FootprintLoader[] LOADERS = new FootprintLoader[]{new ShapefileLoader(), new WKBLoader(), new WKTLoader()};
    private File mosaicFolder;
    private volatile FootprintLoader lastLoader;

    public SidecarFootprintProvider(File mosaicFolder) {
        this.mosaicFolder = mosaicFolder;
    }

    @Override
    public Geometry getFootprint(SimpleFeature feature) throws IOException {
        Object value = feature.getAttribute("location");
        if (value != null && value instanceof String) {
            Geometry result;
            block6: {
                String strValue = (String)value;
                String path = this.getFullPath(strValue);
                String noExtension = this.getNoExtensionPath(path);
                FootprintLoader loader = this.lastLoader;
                result = null;
                try {
                    if (loader != null) {
                        result = loader.loadFootprint(noExtension);
                    }
                    if (result != null) break block6;
                    for (FootprintLoader test : LOADERS) {
                        result = test.loadFootprint(noExtension);
                        if (result == null) continue;
                        this.lastLoader = test;
                        break;
                    }
                }
                catch (Exception e) {
                    throw new IOException("Failed to load the footprint for granule " + strValue, e);
                }
            }
            return result;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Could not use the location attribute value to search for a sidecar file, the value was: " + value);
        }
        return null;
    }

    private String getNoExtensionPath(String path) {
        int idx = path.lastIndexOf(".");
        String noExtension = idx > 0 ? path.substring(0, idx) : path;
        return noExtension;
    }

    private String getFullPath(String strValue) throws IOException {
        File file = new File(strValue);
        if (!file.isAbsolute()) {
            file = new File(this.mosaicFolder, strValue);
        }
        String path = file.getCanonicalPath();
        return path;
    }

    @Override
    public void dispose() {
    }

    private static class ShapefileLoader
    implements FootprintLoader {
        private ShapefileLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Geometry loadFootprint(String pathNoExtension) throws Exception {
            File file = new File(pathNoExtension + ".shp");
            if (file.exists()) {
                ShapefileDataStore ds = new ShapefileDataStore(DataUtilities.fileToURL(file));
                SimpleFeatureIterator fi = null;
                try {
                    fi = ds.getFeatureSource().getFeatures().features();
                    if (!fi.hasNext()) {
                        Geometry geometry = null;
                        return geometry;
                    }
                    SimpleFeature sf = (SimpleFeature)fi.next();
                    Geometry result = (Geometry)sf.getDefaultGeometry();
                    if (fi.hasNext()) {
                        throw new IOException("Found more than one footprint record in the shapefile " + file.getCanonicalPath());
                    }
                    Geometry geometry = result;
                    return geometry;
                }
                finally {
                    if (fi != null) {
                        fi.close();
                    }
                    ds.dispose();
                }
            }
            return null;
        }
    }

    private static class WKTLoader
    implements FootprintLoader {
        WKTReader reader = new WKTReader();

        private WKTLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Geometry loadFootprint(String pathNoExtension) throws Exception {
            File file = new File(pathNoExtension + ".wkt");
            if (file.exists()) {
                Geometry geometry;
                FileReader fr = null;
                try {
                    fr = new FileReader(file);
                    geometry = this.reader.read((Reader)fr);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fr);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)fr);
                return geometry;
            }
            return null;
        }
    }

    private static class WKBLoader
    implements FootprintLoader {
        WKBReader reader = new WKBReader();

        private WKBLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Geometry loadFootprint(String pathNoExtension) throws Exception {
            File file = new File(pathNoExtension + ".wkb");
            if (file.exists()) {
                Geometry geometry;
                FileInputStream is = null;
                try {
                    is = new FileInputStream(file);
                    geometry = this.reader.read((InStream)new InputStreamInStream((InputStream)is));
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
                return geometry;
            }
            return null;
        }
    }

    private static interface FootprintLoader {
        public Geometry loadFootprint(String var1) throws Exception;
    }
}

