/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Logger;
import org.geotools.data.DataUtilities;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.FootprintGeometryProvider;
import org.geotools.gce.imagemosaic.catalog.FootprintInsetPolicy;
import org.geotools.gce.imagemosaic.catalog.GTDataStoreFootprintProvider;
import org.geotools.gce.imagemosaic.catalog.MultiLevelROIProvider;
import org.geotools.gce.imagemosaic.catalog.SidecarFootprintProvider;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;

public class MultiLevelROIProviderFactory {
    private static final Logger LOGGER = Logging.getLogger(MultiLevelROIProviderFactory.class);
    public static final String SOURCE_PROPERTY = "footprint_source";
    public static final String FILTER_PROPERTY = "footprint_filter";
    public static final String INSET_PROPERTY = "footprint_inset";
    public static final String INSET_TYPE_PROPERTY = "footprint_inset_type";
    private static final String TYPE_SIDECAR = "sidecar";

    private MultiLevelROIProviderFactory() {
    }

    public static MultiLevelROIProvider createFootprintProvider(File mosaicFolder) {
        FootprintGeometryProvider provider;
        File configFile = new File(mosaicFolder, "footprints.properties");
        Properties properties = configFile.exists() ? Utils.loadPropertiesFromURL(DataUtilities.fileToURL(configFile)) : new Properties();
        String source = (String)properties.get(SOURCE_PROPERTY);
        if (source == null) {
            File defaultShapefileFootprint = new File(mosaicFolder, "footprints.shp");
            provider = defaultShapefileFootprint.exists() ? MultiLevelROIProviderFactory.buildShapefileSource(mosaicFolder, defaultShapefileFootprint.getName(), properties) : new SidecarFootprintProvider(mosaicFolder);
        } else if (TYPE_SIDECAR.equals(source)) {
            provider = new SidecarFootprintProvider(mosaicFolder);
        } else if (source.toLowerCase().endsWith(".shp")) {
            provider = MultiLevelROIProviderFactory.buildShapefileSource(mosaicFolder, source, properties);
        } else {
            throw new IllegalArgumentException("Invalid source type, it should be a reference to a shapefile or 'sidecar', but was '" + source + "' instead");
        }
        double inset = MultiLevelROIProviderFactory.getInset(properties);
        FootprintInsetPolicy insetPolicy = MultiLevelROIProviderFactory.getInsetPolicy(properties);
        return new MultiLevelROIProvider(provider, inset, insetPolicy);
    }

    private static FootprintInsetPolicy getInsetPolicy(Properties properties) {
        String insetTypeValue = (String)properties.get(INSET_TYPE_PROPERTY);
        if (insetTypeValue == null || insetTypeValue.trim().isEmpty()) {
            return FootprintInsetPolicy.border;
        }
        try {
            return FootprintInsetPolicy.valueOf(insetTypeValue.trim());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid inset type '" + insetTypeValue + "', valid values are: " + FootprintInsetPolicy.names());
        }
    }

    private static double getInset(Properties properties) {
        String inset = (String)properties.get(INSET_PROPERTY);
        if (inset == null) {
            return 0.0;
        }
        Double converted = Converters.convert(inset, Double.class);
        if (converted == null) {
            throw new IllegalArgumentException("Invalid inset value, should be a floating point number, but instead it is: '" + inset + "'");
        }
        return converted;
    }

    private static FootprintGeometryProvider buildShapefileSource(File mosaicFolder, String location, Properties properties) {
        File shapefile = new File(location);
        if (!shapefile.isAbsolute()) {
            shapefile = new File(mosaicFolder, location);
        }
        try {
            if (!shapefile.exists()) {
                throw new IllegalArgumentException("Tried to load the footprints from " + shapefile.getCanonicalPath() + " but the file was not found");
            }
            HashMap<String, Serializable> params = new HashMap<String, Serializable>();
            params.put("url", DataUtilities.fileToURL(shapefile));
            String cql = (String)properties.get(FILTER_PROPERTY);
            Filter filter = null;
            filter = cql != null ? ECQL.toFilter((String)cql) : ECQL.toFilter((String)"location = granule.location");
            String typeName = shapefile.getName();
            typeName = typeName.substring(0, typeName.lastIndexOf(46));
            return new GTDataStoreFootprintProvider(params, typeName, filter);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to create a shapefile based footprint provider", e);
        }
    }
}

