/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import java.io.IOException;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.Hints;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeatureType;

public class GranuleCatalogSource
implements GranuleSource {
    protected GranuleCatalog catalog;
    protected String typeName;
    protected Hints hints;

    public GranuleCatalogSource(GranuleCatalog catalog, String typeName, Hints hints) {
        this.catalog = catalog;
        this.typeName = typeName;
        this.hints = hints;
    }

    public SimpleFeatureCollection getGranules(Query q) throws IOException {
        Query updatedQuery = this.setupBaseQuery(q);
        return this.catalog.getGranules(updatedQuery);
    }

    private Query setupBaseQuery(Query q) {
        q = q == null ? new Query() : new Query(q);
        if (this.hints != null) {
            q.setHints(this.hints);
        }
        if (q.getTypeName() == null) {
            q.setTypeName(this.typeName);
        }
        return q;
    }

    public int getCount(Query q) throws IOException {
        q = this.setupBaseQuery(q);
        return this.catalog.getGranulesCount(q);
    }

    public ReferencedEnvelope getBounds(Query q) throws IOException {
        return this.getGranules(q).getBounds();
    }

    public SimpleFeatureType getSchema() throws IOException {
        return this.catalog.getType(this.typeName);
    }

    public void dispose() throws IOException {
    }
}

