/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import java.io.File;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataUtilities;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.factory.Hints;
import org.geotools.gce.imagemosaic.PathType;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.CachingDataStoreGranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.CatalogConfigurationBean;
import org.geotools.gce.imagemosaic.catalog.GTDataStoreGranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.STRTreeGranuleCatalog;
import org.geotools.util.logging.Logging;

public abstract class GranuleCatalogFactory {
    private static final Logger LOGGER = Logging.getLogger((String)"GranuleCatalogFactory");

    private GranuleCatalogFactory() {
    }

    public static GranuleCatalog createGranuleCatalog(Properties params, boolean caching, boolean create, DataStoreFactorySpi spi, Hints hints) {
        if (caching) {
            return new STRTreeGranuleCatalog(params, spi, hints);
        }
        return new CachingDataStoreGranuleCatalog(new GTDataStoreGranuleCatalog(params, create, spi, hints));
    }

    public static GranuleCatalog createGranuleCatalog(URL sourceURL, CatalogConfigurationBean catalogConfigurationBean, Properties overrideParams, Hints hints) {
        File sourceFile = DataUtilities.urlToFile(sourceURL);
        String extension = FilenameUtils.getExtension((String)sourceFile.getAbsolutePath());
        Properties params = new Properties();
        params.put("PathType", (Object)(catalogConfigurationBean.isAbsolutePath() ? PathType.ABSOLUTE : PathType.RELATIVE));
        if (catalogConfigurationBean.getLocationAttribute() != null) {
            params.put("LocationAttribute", catalogConfigurationBean.getLocationAttribute());
        }
        if (catalogConfigurationBean.getSuggestedSPI() != null) {
            params.put("SuggestedSPI", catalogConfigurationBean.getSuggestedSPI());
        }
        params.put("Heterogeneous", (Object)catalogConfigurationBean.isHeterogeneous());
        params.put("WrapStore", (Object)catalogConfigurationBean.isWrapStore());
        if (sourceURL != null) {
            File parentDirectory = DataUtilities.urlToFile(sourceURL);
            if (parentDirectory.isFile()) {
                parentDirectory = parentDirectory.getParentFile();
            }
            params.put("ParentLocation", DataUtilities.fileToURL(parentDirectory).toString());
        } else {
            params.put("ParentLocation", (Object)null);
        }
        String typeName = catalogConfigurationBean.getTypeName();
        if (typeName != null) {
            params.put("TypeName", catalogConfigurationBean.getTypeName());
        }
        DataStoreFactorySpi spi = null;
        if (extension.equalsIgnoreCase("shp")) {
            params.put(ShapefileDataStoreFactory.URLP.key, sourceURL);
            params.put(ShapefileDataStoreFactory.CREATE_SPATIAL_INDEX.key, Boolean.TRUE);
            params.put(ShapefileDataStoreFactory.ENABLE_SPATIAL_INDEX.key, Boolean.TRUE);
            params.put(ShapefileDataStoreFactory.MEMORY_MAPPED.key, Boolean.FALSE);
            params.put(ShapefileDataStoreFactory.CACHE_MEMORY_MAPS.key, Boolean.FALSE);
            params.put(ShapefileDataStoreFactory.DBFTIMEZONE.key, TimeZone.getTimeZone("UTC"));
            spi = Utils.SHAPE_SPI;
        } else {
            Properties properties = Utils.loadPropertiesFromURL(sourceURL);
            if (properties == null) {
                return null;
            }
            for (Object p : properties.keySet()) {
                params.put(p.toString(), properties.get(p).toString());
            }
            String SPIClass = properties.getProperty("SPI");
            try {
                spi = (DataStoreFactorySpi)Class.forName(SPIClass).newInstance();
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
                return null;
            }
        }
        if (overrideParams != null && !overrideParams.isEmpty()) {
            params.putAll((Map<?, ?>)overrideParams);
        }
        GranuleCatalog catalog = catalogConfigurationBean.isCaching() ? new STRTreeGranuleCatalog(params, spi, hints) : new CachingDataStoreGranuleCatalog(new GTDataStoreGranuleCatalog(params, false, spi, hints));
        return catalog;
    }
}

