/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.union.CascadedPolygonUnion;
import java.util.ArrayList;
import java.util.List;

enum FootprintInsetPolicy {
    full{

        @Override
        public Geometry applyInset(Geometry footprint, Geometry granuleBounds, double inset) {
            if (footprint == null) {
                return null;
            }
            return footprint.buffer(-inset);
        }
    }
    ,
    border{

        @Override
        public Geometry applyInset(Geometry footprint, Geometry granuleBounds, double inset) {
            if (footprint != null) {
                Geometry bufferedOuterRings;
                List<LinearRing> boundRings = this.getRings(granuleBounds);
                List<LinearRing> footprintRings = this.getRings(footprint);
                List<LineString> internalBorders = this.filterRings(footprintRings, bufferedOuterRings = this.buffer(boundRings, Math.max(inset / 100.0, 1.0E-9)));
                if (!internalBorders.isEmpty()) {
                    Geometry bufferedInternalRings = this.buffer(internalBorders, inset);
                    Geometry difference = footprint.difference(bufferedInternalRings);
                    footprint = this.collectPolygons(difference);
                }
            }
            return footprint;
        }

        private Geometry collectPolygons(Geometry geometry) {
            if (geometry.isEmpty()) {
                return geometry;
            }
            final ArrayList polygons = new ArrayList();
            geometry.apply(new GeometryComponentFilter(){

                public void filter(Geometry geom) {
                    if (geom instanceof Polygon && !geom.isEmpty()) {
                        polygons.add((Polygon)geom);
                    }
                }
            });
            if (polygons.isEmpty()) {
                return geometry.getFactory().createMultiPolygon(new Polygon[0]);
            }
            if (polygons.size() == 1) {
                return (Geometry)polygons.get(0);
            }
            Polygon[] array = polygons.toArray(new Polygon[polygons.size()]);
            return array[0].getFactory().createMultiPolygon(array);
        }

        private List<LineString> filterRings(List<LinearRing> footprintRings, Geometry bufferedOuterRings) {
            ArrayList<LineString> result = new ArrayList<LineString>();
            for (LinearRing ring : footprintRings) {
                Geometry difference = ring.difference(bufferedOuterRings);
                if (difference == null) continue;
                this.collectLines(difference, result);
            }
            return result;
        }

        private Geometry buffer(List<? extends Geometry> geometries, double distance) {
            ArrayList<Geometry> polygons = new ArrayList<Geometry>();
            for (Geometry geometry : geometries) {
                Geometry buffered = geometry.buffer(distance);
                polygons.add(buffered);
            }
            return CascadedPolygonUnion.union(polygons);
        }

        private List<LinearRing> getRings(Geometry bounds) {
            final ArrayList<LinearRing> rings = new ArrayList<LinearRing>();
            bounds.apply(new GeometryComponentFilter(){

                public void filter(Geometry geom) {
                    if (geom instanceof LinearRing && !geom.isEmpty()) {
                        rings.add((LinearRing)geom);
                    }
                }
            });
            return rings;
        }

        private void collectLines(Geometry geometry, final List<LineString> lines) {
            geometry.apply(new GeometryComponentFilter(){

                public void filter(Geometry geom) {
                    if (geom instanceof LineString && !geom.isEmpty()) {
                        lines.add((LineString)geom);
                    }
                }
            });
        }
    };


    public abstract Geometry applyInset(Geometry var1, Geometry var2, double var3);

    public static List<String> names() {
        FootprintInsetPolicy[] values = FootprintInsetPolicy.values();
        ArrayList<String> names = new ArrayList<String>(values.length);
        for (int i = 0; i < values.length; ++i) {
            names.add(values[i].name());
        }
        return names;
    }
}

