/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.feature.collection.AbstractFeatureVisitor;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.gce.imagemosaic.GranuleDescriptor;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.GTDataStoreGranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalogVisitor;
import org.geotools.gce.imagemosaic.catalog.MultiLevelROI;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.DefaultProgressListener;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterVisitor;
import org.opengis.geometry.BoundingBox;

class CachingDataStoreGranuleCatalog
extends GranuleCatalog {
    private static final Logger LOGGER = Logging.getLogger(CachingDataStoreGranuleCatalog.class);
    private final GTDataStoreGranuleCatalog adaptee;
    private final SoftValueHashMap<String, GranuleDescriptor> descriptorsCache = new SoftValueHashMap();

    public CachingDataStoreGranuleCatalog(GTDataStoreGranuleCatalog adaptee) {
        super(null);
        this.adaptee = adaptee;
    }

    @Override
    public void addGranules(String typeName, Collection<SimpleFeature> granules, Transaction transaction) throws IOException {
        this.adaptee.addGranules(typeName, granules, transaction);
    }

    @Override
    public void computeAggregateFunction(Query q, FeatureCalc function) throws IOException {
        this.adaptee.computeAggregateFunction(q, function);
    }

    @Override
    public void createType(String namespace, String typeName, String typeSpec) throws IOException, SchemaException {
        this.adaptee.createType(namespace, typeName, typeSpec);
    }

    @Override
    public void createType(SimpleFeatureType featureType) throws IOException {
        this.adaptee.createType(featureType);
    }

    @Override
    public void createType(String identification, String typeSpec) throws SchemaException, IOException {
        this.adaptee.createType(identification, typeSpec);
    }

    @Override
    public void dispose() {
        this.adaptee.dispose();
        if (this.multiScaleROIProvider != null) {
            this.multiScaleROIProvider.dispose();
            this.multiScaleROIProvider = null;
        }
    }

    @Override
    public BoundingBox getBounds(String typeName) {
        return this.adaptee.getBounds(typeName);
    }

    @Override
    public SimpleFeatureCollection getGranules(Query q) throws IOException {
        return this.adaptee.getGranules(q);
    }

    @Override
    public int getGranulesCount(Query q) throws IOException {
        return this.adaptee.getGranulesCount(q);
    }

    @Override
    public void getGranuleDescriptors(Query q, GranuleCatalogVisitor visitor) throws IOException {
        SimpleFeatureCollection features = this.adaptee.getGranules(q);
        if (features == null) {
            throw new NullPointerException("The provided SimpleFeatureCollection is null, it's impossible to create an index!");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Index Loaded");
        }
        Utils.BBOXFilterExtractor bboxExtractor = new Utils.BBOXFilterExtractor();
        q.getFilter().accept((FilterVisitor)bboxExtractor, null);
        ReferencedEnvelope requestedBBox = bboxExtractor.getBBox();
        Polygon intersectionGeometry = requestedBBox != null ? JTS.toGeometry(requestedBBox) : null;
        DefaultProgressListener listener = new DefaultProgressListener();
        features.accepts(new AbstractFeatureVisitor((Geometry)intersectionGeometry, visitor, listener, q){
            final /* synthetic */ Geometry val$intersectionGeometry;
            final /* synthetic */ GranuleCatalogVisitor val$visitor;
            final /* synthetic */ DefaultProgressListener val$listener;
            final /* synthetic */ Query val$q;
            {
                this.val$intersectionGeometry = geometry;
                this.val$visitor = granuleCatalogVisitor;
                this.val$listener = defaultProgressListener;
                this.val$q = query;
            }

            public void visit(Feature feature) {
                if (feature instanceof SimpleFeature) {
                    MultiLevelROI footprint;
                    SimpleFeature sf = (SimpleFeature)feature;
                    GranuleDescriptor granule = null;
                    String featureId = sf.getID();
                    if (CachingDataStoreGranuleCatalog.this.descriptorsCache.containsKey((Object)featureId)) {
                        granule = (GranuleDescriptor)CachingDataStoreGranuleCatalog.this.descriptorsCache.get((Object)featureId);
                    } else {
                        try {
                            footprint = CachingDataStoreGranuleCatalog.this.getGranuleFootprint(sf);
                            if (footprint == null || !footprint.isEmpty()) {
                                granule = new GranuleDescriptor(sf, ((CachingDataStoreGranuleCatalog)CachingDataStoreGranuleCatalog.this).adaptee.suggestedRasterSPI, ((CachingDataStoreGranuleCatalog)CachingDataStoreGranuleCatalog.this).adaptee.pathType, ((CachingDataStoreGranuleCatalog)CachingDataStoreGranuleCatalog.this).adaptee.locationAttribute, ((CachingDataStoreGranuleCatalog)CachingDataStoreGranuleCatalog.this).adaptee.parentLocation, footprint, ((CachingDataStoreGranuleCatalog)CachingDataStoreGranuleCatalog.this).adaptee.heterogeneous, ((CachingDataStoreGranuleCatalog)CachingDataStoreGranuleCatalog.this).adaptee.hints);
                                CachingDataStoreGranuleCatalog.this.descriptorsCache.put((Object)featureId, (Object)granule);
                            }
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.FINE, "Skipping invalid granule", e);
                        }
                    }
                    if (granule != null) {
                        footprint = granule.getFootprint();
                        if (this.val$intersectionGeometry == null || footprint == null || this.polygonOverlap((Geometry)footprint, this.val$intersectionGeometry)) {
                            this.val$visitor.visit(granule, null);
                        } else if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Skipping granule " + granule + "\n since its ROI does not intersect the requested area");
                        }
                    }
                    if (this.val$listener.isCanceled() || this.val$listener.hasExceptions()) {
                        if (this.val$listener.hasExceptions()) {
                            throw new RuntimeException(this.val$listener.getExceptions().peek());
                        }
                        throw new IllegalStateException("Feature visitor for query " + this.val$q + " has been canceled");
                    }
                }
            }

            private boolean polygonOverlap(Geometry g1, Geometry g2) {
                Geometry intersection = g1.intersection(g2);
                return intersection != null && intersection.getDimension() == 2;
            }
        }, listener);
    }

    @Override
    public QueryCapabilities getQueryCapabilities(String typeName) {
        return this.adaptee.getQueryCapabilities(typeName);
    }

    @Override
    public SimpleFeatureType getType(String typeName) throws IOException {
        return this.adaptee.getType(typeName);
    }

    @Override
    public int removeGranules(Query query) {
        int val = this.adaptee.removeGranules(query);
        if (val >= 1) {
            this.descriptorsCache.clear();
        }
        return val;
    }

    @Override
    public String[] getTypeNames() {
        return this.adaptee.getTypeNames();
    }

    public GranuleCatalog getAdaptee() {
        return this.adaptee;
    }

    @Override
    public void removeType(String typeName) throws IOException {
        this.adaptee.removeType(typeName);
    }
}

