/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import it.geosolutions.imageio.pam.PAMDataset;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.BorderExtender;
import javax.media.jai.Histogram;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.RasterFactory;
import javax.media.jai.TileCache;
import javax.media.jai.TileScheduler;
import javax.media.jai.remote.SerializableRenderedImage;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import net.sf.ehcache.Cache;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataUtilities;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.filter.visitor.DefaultFilterVisitor;
import org.geotools.gce.imagemosaic.ImageMosaicConfigHandler;
import org.geotools.gce.imagemosaic.ImageMosaicDatastoreWalker;
import org.geotools.gce.imagemosaic.ImageMosaicDirectoryWalker;
import org.geotools.gce.imagemosaic.ImageMosaicEventHandlers;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.ImageMosaicWalker;
import org.geotools.gce.imagemosaic.MosaicConfigurationBean;
import org.geotools.gce.imagemosaic.catalog.CatalogConfigurationBean;
import org.geotools.gce.imagemosaic.catalog.index.Indexer;
import org.geotools.gce.imagemosaic.catalog.index.IndexerUtils;
import org.geotools.gce.imagemosaic.catalog.index.ObjectFactory;
import org.geotools.gce.imagemosaic.catalog.index.ParametersType;
import org.geotools.gce.imagemosaic.catalogbuilder.CatalogBuilderConfiguration;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.io.ImageIOExt;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Converters;
import org.geotools.util.Range;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.spatial.BBOX;

public class Utils {
    public static final FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2();
    private static final String DATABASE_KEY = "database";
    private static final String MVCC_KEY = "MVCC";
    private static final double RESOLUTION_TOLERANCE_FACTOR = 0.01;
    public static final Hints.Key EXCLUDE_MOSAIC = new Hints.Key(Boolean.class);
    public static final Hints.Key CHECK_AUXILIARY_METADATA = new Hints.Key(Boolean.class);
    public static final Hints.Key AUXILIARY_FILES_PATH = new Hints.Key(String.class);
    public static final Hints.Key PARENT_DIR = new Hints.Key(String.class);
    public static final Hints.Key MOSAIC_READER = new Hints.Key(ImageMosaicReader.class);
    public static final String RANGE_SPLITTER_CHAR = ";";
    public static final String INDEXER_PROPERTIES = "indexer.properties";
    public static final String INDEXER_XML = "indexer.xml";
    private static JAXBContext CONTEXT = null;
    public static final String PAM_DATASET = "PamDataset";
    static final String DEFAULT = "default";
    private static Cache ehcache;
    public static final double[][] RGB_TO_GRAY_MATRIX;
    static final boolean OPTIMIZE_CROP;
    private static final Logger LOGGER;
    public static final String DEFAULT_WILCARD = "*.*";
    public static final boolean DEFAULT_PATH_BEHAVIOR = false;
    private static final boolean DEFAULT_CACHING_BEHAVIOR = false;
    public static final int DEFAULT_PRIORITY = 5;
    public static final String DEFAULT_LOCATION_ATTRIBUTE = "location";
    public static final String DEFAULT_INDEX_NAME = "index";
    public static final DataStoreFactorySpi SHAPE_SPI;
    static final String DIRECT_KAKADU_PLUGIN = "it.geosolutions.imageio.plugins.jp2k.JP2KKakaduImageReader";
    public static final boolean DEFAULT_RECURSION_BEHAVIOR = true;
    static final Color TRANSPARENT;
    public static final boolean DEFAULT_FOOTPRINT_MANAGEMENT = true;
    public static final boolean DEFAULT_CONFIGURATION_CACHING = false;
    static final double SAMEBBOX_THRESHOLD_FACTOR = 20.0;
    static final double AFFINE_IDENTITY_EPS = 1.0E-6;
    public static final boolean DEFAULT_COLOR_EXPANSION_BEHAVIOR = false;
    public static final TimeZone UTC_TIME_ZONE;
    static final String DESCENDING_ORDER_IDENTIFIER = " D";
    static final String ASCENDING_ORDER_IDENTIFIER = " A";
    public static final String SCAN_FOR_TYPENAMES = "TypeNames";
    public static final String SAMPLE_IMAGE_NAME = "sample_image";
    public static final String TIME_DOMAIN = "TIME";
    public static final String ELEVATION_DOMAIN = "ELEVATION";
    public static final String ADDITIONAL_DOMAIN = "ADDITIONAL";
    public static ObjectFactory OBJECT_FACTORY;
    private static IOFileFilter CLEANUP_FILTER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean createMosaic(String location, String indexName, String wildcard, boolean absolutePath, Hints hints) {
        CatalogBuilderConfiguration configuration = new CatalogBuilderConfiguration();
        configuration.setHints(hints);
        List<ParametersType.Parameter> parameterList = configuration.getIndexer().getParameters().getParameter();
        IndexerUtils.setParam(parameterList, "AbsolutePath", Boolean.toString(absolutePath));
        IndexerUtils.setParam(parameterList, "RootMosaicDirectory", location);
        IndexerUtils.setParam(parameterList, "Name", indexName);
        IndexerUtils.setParam(parameterList, "Wildcard", wildcard);
        IndexerUtils.setParam(parameterList, "IndexingDirectories", location);
        ImageMosaicEventHandlers eventHandler = new ImageMosaicEventHandlers();
        ImageMosaicConfigHandler catalogHandler = new ImageMosaicConfigHandler(configuration, eventHandler);
        ImageMosaicWalker walker = catalogHandler.isUseExistingSchema() ? new ImageMosaicDatastoreWalker(catalogHandler, eventHandler) : new ImageMosaicDirectoryWalker(catalogHandler, eventHandler);
        final LinkedList exceptions = new LinkedList();
        try {
            ImageMosaicEventHandlers.ProcessingEventListener listener = new ImageMosaicEventHandlers.ProcessingEventListener(){

                @Override
                public void exceptionOccurred(ImageMosaicEventHandlers.ExceptionEvent event) {
                    Exception t = event.getException();
                    exceptions.add(t);
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, t.getLocalizedMessage(), t);
                    }
                }

                @Override
                public void getNotification(ImageMosaicEventHandlers.ProcessingEvent event) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(event.getMessage());
                    }
                }
            };
            eventHandler.addProcessingEventListener(listener);
            walker.run();
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Unable to build mosaic", e);
            boolean bl = false;
            return bl;
        }
        finally {
            catalogHandler.dispose();
        }
        return exceptions.size() <= 0;
    }

    private static IOFileFilter initCleanUpFilter() {
        IOFileFilter filesFilter = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.suffixFileFilter((String)"properties"), FileFilterUtils.suffixFileFilter((String)"shp"), FileFilterUtils.suffixFileFilter((String)"dbf"), FileFilterUtils.suffixFileFilter((String)"sbn"), FileFilterUtils.suffixFileFilter((String)"sbx"), FileFilterUtils.suffixFileFilter((String)"shx"), FileFilterUtils.suffixFileFilter((String)"qix"), FileFilterUtils.suffixFileFilter((String)"lyr"), FileFilterUtils.suffixFileFilter((String)"prj"), FileFilterUtils.suffixFileFilter((String)"ncx"), FileFilterUtils.suffixFileFilter((String)"gbx9"), FileFilterUtils.suffixFileFilter((String)"ncx2"), FileFilterUtils.suffixFileFilter((String)"ncx3"), FileFilterUtils.nameFileFilter((String)"error.txt"), FileFilterUtils.nameFileFilter((String)"_metadata"), FileFilterUtils.suffixFileFilter((String)SAMPLE_IMAGE_NAME), FileFilterUtils.nameFileFilter((String)"error.txt.lck"), FileFilterUtils.suffixFileFilter((String)"xml"), FileFilterUtils.suffixFileFilter((String)"db")});
        return filesFilter;
    }

    public static String getMessageFromException(Exception exception) {
        if (exception.getLocalizedMessage() != null) {
            return exception.getLocalizedMessage();
        }
        return exception.getMessage();
    }

    static MosaicConfigurationBean loadMosaicProperties(URL sourceURL, String defaultLocationAttribute) {
        return Utils.loadMosaicProperties(sourceURL, defaultLocationAttribute, null);
    }

    static MosaicConfigurationBean loadMosaicProperties(URL sourceURL, String defaultLocationAttribute, Set<String> ignorePropertiesSet) {
        String[] pair;
        String[] pairs;
        Properties properties;
        boolean ignoreSome;
        CatalogConfigurationBean catalogConfigurationBean;
        MosaicConfigurationBean retValue;
        block38: {
            String bboxString;
            File sourceFile;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Trying to load properties file from URL:" + sourceURL);
            }
            retValue = new MosaicConfigurationBean();
            catalogConfigurationBean = new CatalogConfigurationBean();
            retValue.setCatalogConfigurationBean(catalogConfigurationBean);
            ignoreSome = ignorePropertiesSet != null && !ignorePropertiesSet.isEmpty();
            URL propsURL = sourceURL;
            if (!sourceURL.toExternalForm().endsWith(".properties") && (propsURL = DataUtilities.changeUrlExt(sourceURL, "properties")).getProtocol().equals("file") && !(sourceFile = DataUtilities.urlToFile(propsURL)).exists()) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("properties file doesn't exist");
                }
                return null;
            }
            properties = Utils.loadPropertiesFromURL(propsURL);
            if (properties == null) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Unable to load mosaic properties file");
                }
                return null;
            }
            pairs = null;
            pair = null;
            if (!(ignoreSome && ignorePropertiesSet.contains("Envelope2D") || (bboxString = properties.getProperty("Envelope2D", null)) == null)) {
                bboxString = bboxString.trim();
                try {
                    ReferencedEnvelope bbox = Utils.parseEnvelope(bboxString);
                    if (bbox != null) {
                        retValue.setEnvelope(bbox);
                    } else if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.info("Cannot parse imposed bbox.");
                    }
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.INFO)) break block38;
                    LOGGER.log(Level.INFO, "Cannot parse imposed bbox.", e);
                }
            }
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("AuxiliaryFile")) {
            retValue.setAuxiliaryFilePath(properties.getProperty("AuxiliaryFile"));
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("CheckAuxiliaryMetadata")) {
            boolean checkAuxiliaryMetadata = Boolean.valueOf(properties.getProperty("CheckAuxiliaryMetadata", "false").trim());
            retValue.setCheckAuxiliaryMetadata(checkAuxiliaryMetadata);
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("Levels")) {
            int levelsNumber = Integer.parseInt(properties.getProperty("LevelsNum", "1").trim());
            retValue.setLevelsNum(levelsNumber);
            if (!properties.containsKey("Levels")) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Required key Levels not found.");
                }
                return null;
            }
            String levels = properties.getProperty("Levels").trim();
            pairs = levels.split(" ");
            if (pairs == null || pairs.length != levelsNumber) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Levels number is different from the provided number of levels resoltion.");
                }
                return null;
            }
            double[][] resolutions = new double[levelsNumber][2];
            for (int i = 0; i < levelsNumber; ++i) {
                pair = pairs[i].split(",");
                if (pair == null || pair.length != 2) {
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.info("OverviewLevel number is different from the provided number of levels resoltion.");
                    }
                    return null;
                }
                resolutions[i][0] = Double.parseDouble(pair[0]);
                resolutions[i][1] = Double.parseDouble(pair[1]);
            }
            retValue.setLevels(resolutions);
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("TypeName")) {
            String typeName = properties.getProperty("TypeName", null);
            catalogConfigurationBean.setTypeName(typeName);
        }
        if (!(ignoreSome && ignorePropertiesSet.contains("SuggestedSPI") || !properties.containsKey("SuggestedSPI"))) {
            String suggestedSPI = properties.getProperty("SuggestedSPI").trim();
            catalogConfigurationBean.setSuggestedSPI(suggestedSPI);
        }
        if (properties.containsKey("TimeAttribute")) {
            String timeAttribute = properties.getProperty("TimeAttribute").trim();
            retValue.setTimeAttribute(timeAttribute);
        }
        if (properties.containsKey("ElevationAttribute")) {
            String elevationAttribute = properties.getProperty("ElevationAttribute").trim();
            retValue.setElevationAttribute(elevationAttribute);
        }
        if (properties.containsKey("AdditionalDomainAttributes")) {
            String additionalDomainAttributes = properties.getProperty("AdditionalDomainAttributes").trim();
            retValue.setAdditionalDomainAttributes(additionalDomainAttributes);
        }
        if (properties.containsKey("Caching")) {
            String caching = properties.getProperty("Caching").trim();
            try {
                catalogConfigurationBean.setCaching(Boolean.valueOf(caching));
            }
            catch (Throwable e) {
                catalogConfigurationBean.setCaching(false);
            }
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("Name")) {
            if (!properties.containsKey("Name")) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.severe("Required key Name not found.");
                }
                return null;
            }
            String coverageName = properties.getProperty("Name").trim();
            retValue.setName(coverageName);
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("ExpandToRGB")) {
            boolean expandMe = Boolean.valueOf(properties.getProperty("ExpandToRGB", "false").trim());
            retValue.setExpandToRGB(expandMe);
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("WrapStore")) {
            boolean wrapStore = Boolean.valueOf(properties.getProperty("WrapStore", "false").trim());
            catalogConfigurationBean.setWrapStore(wrapStore);
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("Heterogeneous")) {
            boolean heterogeneous = Boolean.valueOf(properties.getProperty("Heterogeneous", "false").trim());
            catalogConfigurationBean.setHeterogeneous(heterogeneous);
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("AbsolutePath")) {
            boolean absolutePath = Boolean.valueOf(properties.getProperty("AbsolutePath", Boolean.toString(false)).trim());
            catalogConfigurationBean.setAbsolutePath(absolutePath);
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("FootprintManagement")) {
            boolean footprintManagement = Boolean.valueOf(properties.getProperty("FootprintManagement", "false").trim());
            retValue.setFootprintManagement(footprintManagement);
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("LocationAttribute")) {
            catalogConfigurationBean.setLocationAttribute(properties.getProperty("LocationAttribute", DEFAULT_LOCATION_ATTRIBUTE).trim());
        }
        return retValue;
    }

    public static ReferencedEnvelope parseEnvelope(String bboxString) {
        if (bboxString == null || bboxString.length() == 0) {
            return null;
        }
        String[] pairs = bboxString.split(" ");
        if (pairs != null && pairs.length == 2) {
            String[] pair1 = pairs[0].split(",");
            String[] pair2 = pairs[1].split(",");
            if (pair1 != null && pair1.length == 2 && pair2 != null && pair2.length == 2) {
                return new ReferencedEnvelope(Double.parseDouble(pair1[0]), Double.parseDouble(pair2[0]), Double.parseDouble(pair1[1]), Double.parseDouble(pair2[1]), null);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Properties loadPropertiesFromURL(URL propsURL) {
        InputStream openStream;
        Properties properties;
        block13: {
            properties = new Properties();
            BufferedInputStream stream = null;
            openStream = null;
            try {
                openStream = propsURL.openStream();
                stream = new BufferedInputStream(openStream);
                properties.load(stream);
                if (stream == null) break block13;
            }
            catch (FileNotFoundException e) {
                Properties properties2;
                block14: {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                    }
                    properties2 = null;
                    if (stream == null) break block14;
                    IOUtils.closeQuietly((InputStream)stream);
                }
                if (openStream != null) {
                    IOUtils.closeQuietly((InputStream)openStream);
                }
                return properties2;
            }
            catch (IOException e2) {
                Properties properties3;
                block15: {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, e2.getLocalizedMessage(), e2);
                    }
                    properties3 = null;
                    if (stream == null) break block15;
                    {
                        catch (Throwable throwable) {
                            if (stream != null) {
                                IOUtils.closeQuietly(stream);
                            }
                            if (openStream != null) {
                                IOUtils.closeQuietly((InputStream)openStream);
                            }
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((InputStream)stream);
                }
                if (openStream != null) {
                    IOUtils.closeQuietly((InputStream)openStream);
                }
                return properties3;
            }
            IOUtils.closeQuietly((InputStream)stream);
        }
        if (openStream != null) {
            IOUtils.closeQuietly((InputStream)openStream);
        }
        return properties;
    }

    public static IOFileFilter excludeFilters(IOFileFilter inputFilter, IOFileFilter ... filters) {
        IOFileFilter retFilter = inputFilter;
        for (IOFileFilter filter : filters) {
            retFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{retFilter, FileFilterUtils.notFileFilter((IOFileFilter)filter)});
        }
        return retFilter;
    }

    static ImageReader getReader(ImageInputStream inStream) {
        Utilities.ensureNonNull((String)"inStream", (Object)inStream);
        inStream.mark();
        Iterator<ImageReader> readersIt = ImageIO.getImageReaders(inStream);
        if (!readersIt.hasNext()) {
            return null;
        }
        return readersIt.next();
    }

    static Rectangle getDimension(int imageIndex, ImageReader reader) throws IOException {
        Utilities.ensureNonNull((String)"reader", (Object)reader);
        if (imageIndex < 0) {
            throw new IllegalArgumentException(Errors.format((int)79, (Object)imageIndex));
        }
        return new Rectangle(0, 0, reader.getWidth(imageIndex), reader.getHeight(imageIndex));
    }

    public static boolean checkFileReadable(File file) {
        if (LOGGER.isLoggable(Level.FINE)) {
            String message = Utils.getFileInfo(file);
            LOGGER.fine(message);
        }
        return file.exists() && file.canRead() && file.isFile();
    }

    public static String getFileInfo(File file) {
        StringBuilder builder = new StringBuilder();
        builder.append("Checking file:").append(FilenameUtils.getFullPath((String)file.getAbsolutePath())).append("\n");
        builder.append("isHidden:").append(file.isHidden()).append("\n");
        builder.append("exists:").append(file.exists()).append("\n");
        builder.append("isFile").append(file.isFile()).append("\n");
        builder.append("canRead:").append(file.canRead()).append("\n");
        builder.append("canWrite").append(file.canWrite()).append("\n");
        builder.append("canExecute:").append(file.canExecute()).append("\n");
        builder.append("isAbsolute:").append(file.isAbsolute()).append("\n");
        builder.append("lastModified:").append(file.lastModified()).append("\n");
        builder.append("length:").append(file.length());
        String message = builder.toString();
        return message;
    }

    public static String checkDirectory(String testingDirectory, boolean writable) throws IllegalArgumentException {
        boolean failure;
        File inDir = new File(testingDirectory);
        boolean bl = failure = !inDir.exists() || !inDir.isDirectory() || inDir.isHidden() || !inDir.canRead();
        if (writable) {
            failure |= !inDir.canWrite();
        }
        if (failure) {
            String message = "Unable to create the mosaic\nlocation is:" + testingDirectory + "\n" + "location exists:" + inDir.exists() + "\n" + "location is a directory:" + inDir.isDirectory() + "\n" + "location is writable:" + inDir.canWrite() + "\n" + "location is readable:" + inDir.canRead() + "\n" + "location is hidden:" + inDir.isHidden() + "\n";
            LOGGER.severe(message);
            throw new IllegalArgumentException(message);
        }
        try {
            testingDirectory = inDir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        testingDirectory = FilenameUtils.normalize((String)testingDirectory);
        if (!testingDirectory.endsWith(File.separator)) {
            testingDirectory = testingDirectory + File.separator;
        }
        boolean bl2 = failure = !(inDir = new File(testingDirectory)).exists() || !inDir.isDirectory() || inDir.isHidden() || !inDir.canRead();
        if (writable) {
            failure |= !inDir.canWrite();
        }
        if (failure) {
            String message = "Unable to create the mosaic\nlocation is:" + testingDirectory + "\n" + "location exists:" + inDir.exists() + "\n" + "location is a directory:" + inDir.isDirectory() + "\n" + "location is writable:" + inDir.canWrite() + "\n" + "location is readable:" + inDir.canRead() + "\n" + "location is hidden:" + inDir.isHidden() + "\n";
            LOGGER.severe(message);
            throw new IllegalArgumentException(message);
        }
        return testingDirectory;
    }

    static boolean checkURLReadable(URL url) {
        try {
            url.openStream().close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static Map<String, Serializable> createDataStoreParamsFromPropertiesFile(URL datastoreProperties) throws IOException {
        Properties properties = Utils.loadPropertiesFromURL(datastoreProperties);
        if (properties == null) {
            return null;
        }
        String SPIClass = properties.getProperty("SPI");
        try {
            DataStoreFactorySpi spi = (DataStoreFactorySpi)Class.forName(SPIClass).newInstance();
            return Utils.createDataStoreParamsFromPropertiesFile(properties, spi);
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            throw (IOException)ioe.initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeSampleImage(File sampleImageFile, SampleModel defaultSM, ColorModel defaultCM) throws IOException {
        SampleModel sm = defaultSM.createCompatibleSampleModel(1, 1);
        WritableRaster raster = RasterFactory.createWritableRaster((SampleModel)sm, null);
        BufferedImage sampleImage = new BufferedImage(defaultCM, raster, defaultCM.isAlphaPremultiplied(), null);
        BufferedOutputStream outStream = null;
        ObjectOutputStream ooStream = null;
        SerializableRenderedImage sri = null;
        try {
            outStream = new BufferedOutputStream(new FileOutputStream(sampleImageFile));
            ooStream = new ObjectOutputStream(outStream);
            sri = new SerializableRenderedImage((RenderedImage)sampleImage, true);
            ooStream.writeObject(sri);
        }
        finally {
            try {
                if (ooStream != null) {
                    ooStream.close();
                }
            }
            catch (Throwable e) {
                IOUtils.closeQuietly((OutputStream)ooStream);
            }
            try {
                if (outStream != null) {
                    ((OutputStream)outStream).close();
                }
            }
            catch (Throwable e) {
                IOUtils.closeQuietly((OutputStream)outStream);
            }
            try {
                if (sri != null) {
                    sri.dispose();
                }
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RenderedImage loadSampleImage(File sampleImageFile) {
        InputStream inStream = null;
        ObjectInputStream oiStream = null;
        try {
            if (Utils.checkFileReadable(sampleImageFile)) {
                inStream = new BufferedInputStream(new FileInputStream(sampleImageFile));
                oiStream = new ObjectInputStream(inStream);
                RenderedImage renderedImage = (RenderedImage)oiStream.readObject();
                return renderedImage;
            }
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("Unable to find sample image for path " + sampleImageFile);
            }
            RenderedImage renderedImage = null;
            return renderedImage;
        }
        catch (FileNotFoundException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            RenderedImage renderedImage = null;
            return renderedImage;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            RenderedImage renderedImage = null;
            return renderedImage;
        }
        catch (ClassNotFoundException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            RenderedImage renderedImage = null;
            return renderedImage;
        }
        finally {
            block42: {
                block41: {
                    try {
                        if (inStream != null) {
                            inStream.close();
                        }
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block41;
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
                try {
                    if (oiStream != null) {
                        oiStream.close();
                    }
                }
                catch (Throwable e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block42;
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
            }
        }
    }

    public static Map<String, Serializable> createDataStoreParamsFromPropertiesFile(Properties properties, DataStoreFactorySpi spi) throws IOException {
        DataAccessFactory.Param[] paramsInfo;
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        for (DataAccessFactory.Param p : paramsInfo = spi.getParametersInfo()) {
            if (properties.containsKey(p.key)) {
                params.put(p.key, (Serializable)Converters.convert(properties.getProperty(p.key), p.type));
                continue;
            }
            if (!p.required || p.sample != null) continue;
            throw new IOException("Required parameter missing: " + p.toString());
        }
        return params;
    }

    public static Map<String, Serializable> filterDataStoreParams(Properties properties, DataStoreFactorySpi spi) throws IOException {
        DataAccessFactory.Param[] paramsInfo;
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        for (DataAccessFactory.Param p : paramsInfo = spi.getParametersInfo()) {
            if (properties.containsKey(p.key)) {
                params.put(p.key, (Serializable)Converters.convert(properties.get(p.key), p.type));
                continue;
            }
            if (!p.required || p.sample != null) continue;
            throw new IOException("Required parameter missing: " + p.toString());
        }
        return params;
    }

    static URL checkSource(Object source, Hints hints) {
        URL sourceURL = null;
        File sourceFile = null;
        if (source instanceof File) {
            sourceFile = (File)source;
            sourceURL = DataUtilities.fileToURL(sourceFile);
        } else if (source instanceof URL) {
            sourceURL = (URL)source;
            if (sourceURL.getProtocol().equals("file")) {
                sourceFile = DataUtilities.urlToFile(sourceURL);
            }
        } else if (source instanceof String) {
            String tempSource = (String)source;
            File tempFile = new File(tempSource);
            if (!tempFile.exists()) {
                try {
                    sourceURL = new URL(tempSource);
                    source = DataUtilities.urlToFile(sourceURL);
                }
                catch (MalformedURLException e) {
                    sourceURL = null;
                    source = null;
                }
            } else {
                sourceURL = DataUtilities.fileToURL(tempFile);
                sourceFile = tempFile;
            }
        }
        if (sourceFile != null) {
            if (!sourceFile.isDirectory()) {
                sourceURL = DataUtilities.fileToURL(sourceFile);
            } else {
                String locationPath = sourceFile.getAbsolutePath();
                String defaultIndexName = Utils.getDefaultIndexName(locationPath);
                boolean datastoreFound = false;
                boolean buildMosaic = false;
                File dataStoreProperties = new File(locationPath, "datastore.properties");
                File[] properties = sourceFile.listFiles((FilenameFilter)FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"datastore.properties")), FileFilterUtils.makeFileOnly((IOFileFilter)FileFilterUtils.suffixFileFilter((String)".properties"))}));
                if (Utils.checkFileReadable(dataStoreProperties)) {
                    datastoreFound = true;
                    boolean found = false;
                    for (File propFile : properties) {
                        if (!Utils.checkFileReadable(propFile) || null == Utils.loadMosaicProperties(DataUtilities.fileToURL(propFile), DEFAULT_LOCATION_ATTRIBUTE)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        buildMosaic = true;
                    }
                } else {
                    buildMosaic = true;
                    datastoreFound = false;
                }
                File shapeFile = null;
                if (!datastoreFound) {
                    for (File propFile : properties) {
                        if (null == Utils.loadMosaicProperties(DataUtilities.fileToURL(propFile), DEFAULT_LOCATION_ATTRIBUTE)) continue;
                        shapeFile = new File(locationPath, FilenameUtils.getBaseName((String)propFile.getName()) + ".shp");
                        if (!Utils.checkFileReadable(shapeFile) && Utils.checkFileReadable(propFile)) {
                            buildMosaic = true;
                            continue;
                        }
                        buildMosaic = false;
                        break;
                    }
                }
                if (buildMosaic) {
                    File mosaicDirectory = new File(locationPath);
                    if (!mosaicDirectory.exists() || mosaicDirectory.isFile() || !mosaicDirectory.canWrite()) {
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, "Unable to create the mosaic, check the location:\nlocation is:" + locationPath + "\n" + "location exists:" + mosaicDirectory.exists() + "\n" + "location is a directory:" + mosaicDirectory.isDirectory() + "\n" + "location is writable:" + mosaicDirectory.canWrite() + "\n" + "location is readable:" + mosaicDirectory.canRead() + "\n" + "location is hidden:" + mosaicDirectory.isHidden() + "\n");
                        }
                        return null;
                    }
                    Utils.createMosaic(locationPath, defaultIndexName, DEFAULT_WILCARD, false, hints);
                    File propertiesFile = new File(locationPath, defaultIndexName + ".properties");
                    if (!Utils.checkFileReadable(propertiesFile) && !Utils.checkMosaicHasBeenInitialized(locationPath, defaultIndexName)) {
                        sourceURL = null;
                        return sourceURL;
                    }
                    sourceURL = Utils.updateSourceURL(sourceURL, datastoreFound, locationPath, defaultIndexName);
                } else {
                    sourceURL = datastoreFound ? DataUtilities.fileToURL(dataStoreProperties) : DataUtilities.fileToURL(shapeFile);
                }
            }
        }
        return sourceURL;
    }

    private static String getDefaultIndexName(String locationPath) {
        if (locationPath == null) {
            return null;
        }
        File file = new File(locationPath);
        if (file.isDirectory()) {
            URL indexerUrl;
            Properties config;
            File indexer = new File(file, INDEXER_PROPERTIES);
            if (indexer.exists() && (config = Utils.loadPropertiesFromURL(indexerUrl = DataUtilities.fileToURL(indexer))) != null && config.get("Name") != null) {
                return (String)config.get("Name");
            }
            indexer = new File(file, INDEXER_XML);
            String name = IndexerUtils.getParameter("Name", indexer);
            if (name != null) {
                return name;
            }
        }
        return FilenameUtils.getName((String)locationPath);
    }

    private static URL updateSourceURL(URL sourceURL, boolean datastoreFound, String locationPath, String defaultIndexName) {
        File dataStoreProperties;
        File shapeFile;
        sourceURL = !datastoreFound ? (!Utils.checkFileReadable(shapeFile = new File(locationPath, defaultIndexName + ".shp")) ? null : DataUtilities.fileToURL(shapeFile)) : (!Utils.checkFileReadable(dataStoreProperties = new File(locationPath, "datastore.properties")) ? null : DataUtilities.fileToURL(dataStoreProperties));
        return sourceURL;
    }

    private static boolean checkMosaicHasBeenInitialized(String locationPath, String defaultIndexName) {
        String canBeEmpty;
        URL url;
        Properties properties;
        String canBeEmpty2;
        File mosaicFile = new File(locationPath, defaultIndexName + ".xml");
        if (Utils.checkFileReadable(mosaicFile)) {
            return true;
        }
        mosaicFile = new File(locationPath, defaultIndexName + ".properties");
        if (Utils.checkFileReadable(mosaicFile)) {
            return true;
        }
        File indexFile = new File(locationPath, INDEXER_XML);
        if (Utils.checkFileReadable(indexFile) && (canBeEmpty2 = IndexerUtils.getParameter("CanBeEmpty", indexFile)) != null && Boolean.parseBoolean(canBeEmpty2)) {
            return true;
        }
        indexFile = new File(locationPath, INDEXER_PROPERTIES);
        return Utils.checkFileReadable(indexFile) && (properties = Utils.loadPropertiesFromURL(url = DataUtilities.fileToURL(indexFile))) != null && (canBeEmpty = properties.getProperty("CanBeEmpty", null)) != null && Boolean.parseBoolean(canBeEmpty);
    }

    private Utils(Cache ehcache) {
        Utils.ehcache = ehcache;
    }

    /*
     * Exception decompiling
     */
    static Histogram getHistogram(String file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static boolean areaIsDifferent(Geometry granuleFootprint, AffineTransform baseGridToWorld, ReferencedEnvelope granuleBBOX) {
        double bboxArea;
        Envelope envelope = granuleFootprint.getEnvelope().getEnvelopeInternal();
        double deltaMinX = Math.abs(envelope.getMinX() - granuleBBOX.getMinX());
        double deltaMinY = Math.abs(envelope.getMinY() - granuleBBOX.getMinY());
        double deltaMaxX = Math.abs(envelope.getMaxX() - granuleBBOX.getMaxX());
        double deltaMaxY = Math.abs(envelope.getMaxY() - granuleBBOX.getMaxY());
        double resX = XAffineTransform.getScaleX0((AffineTransform)baseGridToWorld);
        double resY = XAffineTransform.getScaleY0((AffineTransform)baseGridToWorld);
        double toleranceX = resX / 20.0;
        double toleranceY = resY / 20.0;
        double cellArea = resX * resY;
        if (deltaMinX > toleranceX || deltaMaxX > toleranceX || deltaMinY > toleranceY || deltaMaxY > toleranceY) {
            return true;
        }
        double footprintArea = granuleFootprint.getArea();
        return Math.abs(footprintArea - (bboxArea = granuleBBOX.getHeight() * granuleBBOX.getWidth())) > cellArea;
    }

    static Rectangle toRectangle(Shape shape) {
        int i;
        if (shape instanceof Rectangle) {
            return (Rectangle)shape;
        }
        if (shape == null) {
            return null;
        }
        PathIterator iter = shape.getPathIterator(new AffineTransform());
        double[] coords = new double[2];
        if (iter.isDone()) {
            return null;
        }
        iter.next();
        int action = iter.currentSegment(coords);
        if (action != 0 && action != 1) {
            return null;
        }
        double minx = coords[0];
        double miny = coords[1];
        double maxx = minx;
        double maxy = miny;
        double prevx = minx;
        double prevy = miny;
        for (i = 0; i < 4 && !iter.isDone(); ++i) {
            iter.next();
            action = iter.currentSegment(coords);
            if (action == 4) break;
            if (action != 1) {
                return null;
            }
            double x = coords[0];
            double y = coords[1];
            if (!(prevx == x && prevy != y || prevx != x && prevy == y)) {
                return null;
            }
            if (x < minx) {
                minx = x;
            } else if (x > maxx) {
                maxx = x;
            }
            if (y < miny) {
                miny = y;
            } else if (y > maxy) {
                maxy = y;
            }
            prevx = x;
            prevy = y;
        }
        iter.next();
        if (!iter.isDone() || i != 3) {
            return null;
        }
        return new Rectangle2D.Double(minx, miny, maxx - minx, maxy - miny).getBounds();
    }

    public static ImageLayout getImageLayoutHint(RenderingHints renderHints) {
        if (renderHints == null || !renderHints.containsKey(JAI.KEY_IMAGE_LAYOUT)) {
            return null;
        }
        return (ImageLayout)renderHints.get(JAI.KEY_IMAGE_LAYOUT);
    }

    public static TileCache getTileCacheHint(RenderingHints renderHints) {
        if (renderHints == null || !renderHints.containsKey(JAI.KEY_TILE_CACHE)) {
            return null;
        }
        return (TileCache)renderHints.get(JAI.KEY_TILE_CACHE);
    }

    public static BorderExtender getBorderExtenderHint(RenderingHints renderHints) {
        if (renderHints == null || !renderHints.containsKey(JAI.KEY_BORDER_EXTENDER)) {
            return null;
        }
        return (BorderExtender)renderHints.get(JAI.KEY_BORDER_EXTENDER);
    }

    public static TileScheduler getTileSchedulerHint(RenderingHints renderHints) {
        if (renderHints == null || !renderHints.containsKey(JAI.KEY_TILE_SCHEDULER)) {
            return null;
        }
        return (TileScheduler)renderHints.get(JAI.KEY_TILE_SCHEDULER);
    }

    public static Range<? extends Number> createRange(Object firstValue, Object secondValue) {
        Class<?> target2Class;
        Class<?> targetClass = firstValue.getClass();
        if (targetClass != (target2Class = secondValue.getClass())) {
            throw new IllegalArgumentException("The 2 values need to belong to the same class:\nfirstClass = " + targetClass.toString() + "; secondClass = " + targetClass.toString());
        }
        if (targetClass == Byte.class) {
            return new Range(Byte.class, (Comparable)((Byte)firstValue), (Comparable)((Byte)secondValue));
        }
        if (targetClass == Short.class) {
            return new Range(Short.class, (Comparable)((Short)firstValue), (Comparable)((Short)secondValue));
        }
        if (targetClass == Integer.class) {
            return new Range(Integer.class, (Comparable)((Integer)firstValue), (Comparable)((Integer)secondValue));
        }
        if (targetClass == Long.class) {
            return new Range(Long.class, (Comparable)((Long)firstValue), (Comparable)((Long)secondValue));
        }
        if (targetClass == Float.class) {
            return new Range(Float.class, (Comparable)((Float)firstValue), (Comparable)((Float)secondValue));
        }
        if (targetClass == Double.class) {
            return new Range(Double.class, (Comparable)((Double)firstValue), (Comparable)((Double)secondValue));
        }
        return null;
    }

    public static boolean minimalIndexCheck(Object source) {
        File sourceFile = null;
        URL sourceURL = null;
        if (source instanceof File) {
            sourceFile = (File)source;
        } else if (source instanceof URL) {
            sourceURL = (URL)source;
            if (sourceURL.getProtocol().equals("file")) {
                sourceFile = DataUtilities.urlToFile(sourceURL);
            }
        } else if (source instanceof String) {
            String tempSource = (String)source;
            File tempFile = new File(tempSource);
            if (!tempFile.exists()) {
                try {
                    sourceURL = new URL(tempSource);
                    source = DataUtilities.urlToFile(sourceURL);
                }
                catch (MalformedURLException e) {
                    sourceURL = null;
                    source = null;
                }
            } else {
                sourceURL = DataUtilities.fileToURL(tempFile);
                sourceFile = tempFile;
            }
        }
        File indexerProperties = new File(sourceFile, INDEXER_PROPERTIES);
        if (Utils.checkFileReadable(indexerProperties)) {
            return true;
        }
        File indexerXML = new File(sourceFile, INDEXER_XML);
        return Utils.checkFileReadable(indexerXML);
    }

    public static boolean homogeneousCheck(int numberOfLevels, double[][] resolutionLevels, double[][] compareLevels) {
        for (int k = 0; k < numberOfLevels; ++k) {
            if (!(Math.abs(resolutionLevels[k][0] - compareLevels[k][0]) > 0.01 * compareLevels[k][0]) && !(Math.abs(resolutionLevels[k][1] - compareLevels[k][1]) > 0.01 * compareLevels[k][1])) continue;
            return false;
        }
        return true;
    }

    public static Indexer unmarshal(File indexerFile) throws JAXBException {
        Unmarshaller unmarshaller = null;
        Indexer indexer = null;
        if (indexerFile != null) {
            unmarshaller = CONTEXT.createUnmarshaller();
            indexer = (Indexer)unmarshaller.unmarshal(indexerFile);
        }
        return indexer;
    }

    static boolean checkColorModels(ColorModel defaultCM, byte[][] defaultPalette, MosaicConfigurationBean configuration, ColorModel actualCM) {
        if (defaultCM instanceof ComponentColorModel && actualCM instanceof ComponentColorModel) {
            ComponentColorModel defCCM = (ComponentColorModel)defaultCM;
            ComponentColorModel actualCCM = (ComponentColorModel)actualCM;
            int numColorComponents = defCCM.getNumColorComponents();
            if (numColorComponents != actualCCM.getNumColorComponents()) {
                return false;
            }
            for (int i = 0; i < numColorComponents; ++i) {
                if (defaultCM.getComponentSize(i) == defaultCM.getComponentSize(i)) continue;
                return false;
            }
            return defCCM.hasAlpha() != actualCCM.hasAlpha() || defCCM.isAlphaPremultiplied() != actualCCM.isAlphaPremultiplied() || defCCM.getTransparency() != actualCCM.getTransparency() || defCCM.getTransferType() != actualCCM.getTransferType() || defCCM.getPixelSize() != actualCCM.getPixelSize();
        }
        if (defaultCM instanceof IndexColorModel && actualCM instanceof IndexColorModel) {
            IndexColorModel defICM = (IndexColorModel)defaultCM;
            IndexColorModel actualICM = (IndexColorModel)actualCM;
            if (defICM.getNumColorComponents() != actualICM.getNumColorComponents() || defICM.hasAlpha() != actualICM.hasAlpha() || !defICM.getColorSpace().equals(actualICM.getColorSpace()) || defICM.getTransferType() != actualICM.getTransferType()) {
                return true;
            }
            if (defICM.getMapSize() != actualICM.getMapSize() || defICM.getTransparency() != actualICM.getTransparency() || defICM.getTransferType() != actualICM.getTransferType() || defICM.getTransparentPixel() != actualICM.getTransparentPixel()) {
                configuration.setExpandToRGB(true);
                return false;
            }
            int numBands = actualICM.getNumColorComponents();
            byte[][] actualPalette = new byte[3][actualICM.getMapSize()];
            actualICM.getReds(actualPalette[0]);
            actualICM.getGreens(actualPalette[0]);
            actualICM.getBlues(actualPalette[0]);
            if (numBands == 4) {
                actualICM.getAlphas(defaultPalette[0]);
            }
            block1: for (int i = 0; i < defICM.getMapSize(); ++i) {
                for (int j = 0; j < numBands; ++j) {
                    if (actualPalette[j][i] == defaultPalette[j][i]) continue;
                    configuration.setExpandToRGB(true);
                    continue block1;
                }
            }
            return false;
        }
        return true;
    }

    public static boolean isH2Store(DataStoreFactorySpi spi) {
        String spiName = spi == null ? null : spi.getClass().getName();
        return "org.geotools.data.h2.H2DataStoreFactory".equals(spiName) || "org.geotools.data.h2.H2JNDIDataStoreFactory".equals(spiName);
    }

    public static void fixH2DatabaseLocation(Map<String, Serializable> params, String parentLocation) throws MalformedURLException {
        if (params.containsKey(DATABASE_KEY)) {
            String dbname = (String)((Object)params.get(DATABASE_KEY));
            params.put(DATABASE_KEY, (Serializable)((Object)("file:" + new File(DataUtilities.urlToFile(new URL(parentLocation)), dbname).getPath())));
        }
    }

    public static boolean isOracleStore(DataStoreFactorySpi spi) {
        String spiName = spi == null ? null : spi.getClass().getName();
        return "org.geotools.data.oracle.OracleNGOCIDataStoreFactory".equals(spiName) || "org.geotools.data.oracle.OracleNGJNDIDataStoreFactory".equals(spiName) || "org.geotools.data.oracle.OracleNGDataStoreFactory".equals(spiName);
    }

    public static boolean isPostgisStore(DataStoreFactorySpi spi) {
        String spiName = spi == null ? null : spi.getClass().getName();
        return "org.geotools.data.postgis.PostgisNGJNDIDataStoreFactory".equals(spiName) || "org.geotools.data.postgis.PostgisNGDataStoreFactory".equals(spiName);
    }

    public static PAMDataset mergePamDatasets(PAMDataset[] pamDatasets) {
        PAMDataset merged = pamDatasets[0];
        if (pamDatasets.length > 1 && (merged = Utils.initRasterBands(pamDatasets[0])) != null) {
            for (PAMDataset pamDataset : pamDatasets) {
                Utils.updatePamDatasets(pamDataset, merged);
            }
        }
        return merged;
    }

    private static void updatePamDatasets(PAMDataset inputPamDataset, PAMDataset outputPamDataset) {
        List inputRasterBands = inputPamDataset.getPAMRasterBand();
        List outputRasterBands = outputPamDataset.getPAMRasterBand();
        for (int i = 0; i < inputRasterBands.size(); ++i) {
            Utils.updateRasterBand((PAMDataset.PAMRasterBand)inputRasterBands.get(i), (PAMDataset.PAMRasterBand)outputRasterBands.get(i));
        }
    }

    private static void updateRasterBand(PAMDataset.PAMRasterBand inputPamRasterBand, PAMDataset.PAMRasterBand outputPamRasterBand) {
        List mdiInputs = inputPamRasterBand.getMetadata().getMDI();
        List mdiOutputs = outputPamRasterBand.getMetadata().getMDI();
        for (int i = 0; i < mdiInputs.size(); ++i) {
            PAMDataset.PAMRasterBand.Metadata.MDI mdiInput = (PAMDataset.PAMRasterBand.Metadata.MDI)mdiInputs.get(i);
            PAMDataset.PAMRasterBand.Metadata.MDI mdiOutput = (PAMDataset.PAMRasterBand.Metadata.MDI)mdiOutputs.get(i);
            Utils.updateMDI(mdiInput, mdiOutput);
        }
    }

    private static void updateMDI(PAMDataset.PAMRasterBand.Metadata.MDI mdiInput, PAMDataset.PAMRasterBand.Metadata.MDI mdiOutput) {
        Double current = Double.parseDouble(mdiInput.getValue());
        String value = mdiOutput.getValue();
        if (value != null) {
            Double output = Double.parseDouble(value);
            if (mdiInput.getKey().toUpperCase().endsWith("_MAXIMUM")) {
                if (current < output) {
                    current = output;
                }
            } else if (output < current) {
                current = output;
            }
        }
        mdiOutput.setValue(Double.toString(current));
    }

    private static PAMDataset initRasterBands(PAMDataset samplePam) {
        PAMDataset merged = null;
        if (samplePam != null) {
            merged = new PAMDataset();
            List samplePamRasterBands = samplePam.getPAMRasterBand();
            int numBands = samplePamRasterBands.size();
            List pamRasterBands = merged.getPAMRasterBand();
            PAMDataset.PAMRasterBand sampleBand = (PAMDataset.PAMRasterBand)samplePamRasterBands.get(0);
            List sampleMetadata = sampleBand.getMetadata().getMDI();
            for (int i = 0; i < numBands; ++i) {
                PAMDataset.PAMRasterBand band = new PAMDataset.PAMRasterBand();
                PAMDataset.PAMRasterBand.Metadata metadata = new PAMDataset.PAMRasterBand.Metadata();
                List mdiList = metadata.getMDI();
                for (PAMDataset.PAMRasterBand.Metadata.MDI mdi : sampleMetadata) {
                    PAMDataset.PAMRasterBand.Metadata.MDI addedMdi = new PAMDataset.PAMRasterBand.Metadata.MDI();
                    addedMdi.setKey(mdi.getKey());
                    mdiList.add(addedMdi);
                }
                band.setMetadata(metadata);
                pamRasterBands.add(band);
            }
        }
        return merged;
    }

    public static IOFileFilter getCleanupFilter() {
        return CLEANUP_FILTER;
    }

    public static void fixH2MVCCParam(Map<String, Serializable> params) {
        if (params != null) {
            params.put(MVCC_KEY, Boolean.valueOf(true));
        }
    }

    public static void fixPostgisDBCreationParams(Map<String, Serializable> datastoreParams) {
        datastoreParams.put("create database", Boolean.valueOf(true));
    }

    public static void dropDB(DataStoreFactorySpi spi, Properties properties) throws IOException {
        if (Utils.isPostgisStore(spi)) {
            Map<String, Serializable> params = Utils.filterDataStoreParams(properties, spi);
            try {
                MethodUtils.invokeMethod((Object)spi, (String)"dropDatabase", params);
            }
            catch (NoSuchMethodException e) {
                throw new IOException("Unable to drop the database: ", e);
            }
            catch (IllegalAccessException e) {
                throw new IOException("Unable to drop the database: ", e);
            }
            catch (InvocationTargetException e) {
                throw new IOException("Unable to drop the database: ", e);
            }
        }
    }

    public static ImageReaderSpi getReaderSpiFromStream(ImageReaderSpi suggestedSPI, ImageInputStream inStream) throws IOException {
        ImageReaderSpi readerSPI = null;
        inStream.mark();
        if (suggestedSPI != null && suggestedSPI.canDecodeInput(inStream)) {
            readerSPI = suggestedSPI;
            inStream.reset();
        } else {
            inStream.mark();
            ImageReader reader = ImageIOExt.getImageioReader((ImageInputStream)inStream);
            if (reader != null) {
                readerSPI = reader.getOriginatingProvider();
            }
            inStream.reset();
        }
        return readerSPI;
    }

    public static ImageInputStreamSpi getInputStreamSPIFromURL(URL granuleUrl) throws IOException {
        ImageInputStreamSpi streamSPI = ImageIOExt.getImageInputStreamSPI((Object)granuleUrl, (boolean)true);
        if (streamSPI == null) {
            File file = DataUtilities.urlToFile(granuleUrl);
            if (file != null && LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, Utils.getFileInfo(file));
            }
            throw new IllegalArgumentException("Unable to get an input stream for the provided granule " + granuleUrl.toString());
        }
        return streamSPI;
    }

    public static byte[][] extractPalette(IndexColorModel indexColorModel) {
        Utilities.ensureNonNull((String)"indexColorModel", (Object)indexColorModel);
        byte[][] palette = new byte[3][indexColorModel.getMapSize()];
        int numBands = indexColorModel.getNumColorComponents();
        indexColorModel.getReds(palette[0]);
        indexColorModel.getGreens(palette[0]);
        indexColorModel.getBlues(palette[0]);
        if (numBands == 4) {
            indexColorModel.getAlphas(palette[0]);
        }
        return palette;
    }

    static {
        RGB_TO_GRAY_MATRIX = new double[][]{{0.114, 0.587, 0.299, 0.0}};
        LOGGER = Logging.getLogger((String)Utils.class.toString());
        String prop = System.getProperty("org.geotools.imagemosaic.optimizecrop");
        OPTIMIZE_CROP = prop == null || !prop.equalsIgnoreCase("FALSE");
        try {
            CONTEXT = JAXBContext.newInstance((String)"org.geotools.gce.imagemosaic.catalog.index");
        }
        catch (JAXBException e) {
            LOGGER.log(Level.FINER, e.getMessage(), e);
        }
        CLEANUP_FILTER = Utils.initCleanUpFilter();
        SHAPE_SPI = new ShapefileDataStoreFactory();
        TRANSPARENT = new Color(0, 0, 0, 0);
        UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
        OBJECT_FACTORY = new ObjectFactory();
    }

    public static class BBOXFilterExtractor
    extends DefaultFilterVisitor {
        private ReferencedEnvelope bbox;

        public ReferencedEnvelope getBBox() {
            return this.bbox;
        }

        @Override
        public Object visit(BBOX filter, Object data) {
            ReferencedEnvelope bbox = ReferencedEnvelope.reference(filter.getBounds());
            this.bbox = this.bbox != null ? (ReferencedEnvelope)this.bbox.intersection(bbox) : bbox;
            return super.visit(filter, data);
        }
    }

    public static class Prop {
        public static final String LOCATION_ATTRIBUTE = "LocationAttribute";
        public static final String ENVELOPE2D = "Envelope2D";
        public static final String LEVELS_NUM = "LevelsNum";
        public static final String LEVELS = "Levels";
        public static final String SUGGESTED_SPI = "SuggestedSPI";
        public static final String EXP_RGB = "ExpandToRGB";
        public static final String ABSOLUTE_PATH = "AbsolutePath";
        public static final String AUXILIARY_FILE = "AuxiliaryFile";
        public static final String NAME = "Name";
        public static final String INDEX_NAME = "Name";
        public static final String FOOTPRINT_MANAGEMENT = "FootprintManagement";
        public static final String HETEROGENEOUS = "Heterogeneous";
        public static final String TIME_ATTRIBUTE = "TimeAttribute";
        public static final String ELEVATION_ATTRIBUTE = "ElevationAttribute";
        public static final String ADDITIONAL_DOMAIN_ATTRIBUTES = "AdditionalDomainAttributes";
        public static final String USE_EXISTING_SCHEMA = "UseExistingSchema";
        public static final String TYPENAME = "TypeName";
        public static final String PATH_TYPE = "PathType";
        public static final String PARENT_LOCATION = "ParentLocation";
        public static final String ROOT_MOSAIC_DIR = "RootMosaicDirectory";
        public static final String INDEXING_DIRECTORIES = "IndexingDirectories";
        public static final String HARVEST_DIRECTORY = "HarvestingDirectory";
        public static final String CAN_BE_EMPTY = "CanBeEmpty";
        public static final String CHECK_AUXILIARY_METADATA = "CheckAuxiliaryMetadata";
        public static final String RECURSIVE = "Recursive";
        public static final String WILDCARD = "Wildcard";
        public static final String SCHEMA = "Schema";
        public static final String RESOLUTION_LEVELS = "ResolutionLevels";
        public static final String PROPERTY_COLLECTORS = "PropertyCollectors";
        public static final String CACHING = "Caching";
        public static final String WRAP_STORE = "WrapStore";
    }
}

