/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.GeneralGridEnvelope;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.ReadResolutionCalculator;
import org.geotools.data.DataSourceException;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.metadata.iso.spatial.PixelTranslation;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.geometry.XRectangle2D;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public class SpatialRequestHelper {
    private static final Logger LOGGER = Logging.getLogger(SpatialRequestHelper.class);
    private ReferencedEnvelope requestedBBox;
    private ReferencedEnvelope computedBBox;
    private Rectangle requestedRasterArea;
    private Rectangle computedRasterArea;
    private CoordinateReferenceSystem requestCRS;
    private AffineTransform requestedGridToWorld;
    private double[] computedResolution;
    private GeneralEnvelope requestedBBOXInCoverageGeographicCRS;
    private MathTransform requestCRSToCoverageGeographicCRS2D;
    private MathTransform destinationToSourceTransform;
    private final CoverageProperties coverageProperties;
    private boolean accurateResolution;
    private boolean emptyRequest;
    private boolean needsReprojection = false;
    private GeneralEnvelope approximateRequestedBBoInNativeCRS;
    private AffineTransform computedGridToWorld;
    private GridGeometry2D requestedGridGeometry;

    public SpatialRequestHelper(CoverageProperties coverageProperties) {
        this.coverageProperties = coverageProperties;
    }

    public void setRequestedGridGeometry(GridGeometry2D gridGeometry) {
        Utilities.ensureNonNull((String)"girdGeometry", (Object)gridGeometry);
        this.requestedBBox = new ReferencedEnvelope((Envelope)gridGeometry.getEnvelope2D());
        this.requestedRasterArea = gridGeometry.getGridRange2D().getBounds();
        this.requestedGridGeometry = gridGeometry;
        this.requestedGridToWorld = (AffineTransform)gridGeometry.getGridToCRS2D();
    }

    public void compute() throws DataSourceException {
        if (this.requestedBBox == null) {
            this.requestedBBox = new ReferencedEnvelope(this.coverageProperties.bbox, this.coverageProperties.crs2D);
            this.requestedRasterArea = (Rectangle)this.coverageProperties.rasterArea.clone();
            this.computedResolution = (double[])this.coverageProperties.fullResolution.clone();
            this.computedBBox = new ReferencedEnvelope(this.coverageProperties.bbox, this.coverageProperties.crs2D);
            this.computedRasterArea = (Rectangle)this.coverageProperties.rasterArea.clone();
            this.computedGridToWorld = this.requestedGridToWorld = (AffineTransform)this.coverageProperties.gridToWorld2D;
            return;
        }
        this.inspectCoordinateReferenceSystems();
        this.computeCropBBOX();
        if (this.emptyRequest || this.computedBBox == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "RequestedBBox empty or null");
            }
            return;
        }
        this.computeRasterArea();
        if (this.emptyRequest || this.computedRasterArea == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "CropRasterArea empty or null");
            }
            return;
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            StringBuilder sb = new StringBuilder("Adjusted Requested Envelope = ").append(this.requestedBBox.toString()).append("\n").append("Requested raster dimension = ").append(this.requestedRasterArea.toString()).append("\n").append("Corresponding raster source region = ").append(this.computedRasterArea.toString()).append("\n").append("Corresponding source Envelope = ").append(this.computedBBox.toString());
            LOGGER.log(Level.FINER, sb.toString());
        }
        this.computeResolution();
    }

    private void inspectCoordinateReferenceSystems() throws DataSourceException {
        this.requestCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)this.requestedBBox.getCoordinateReferenceSystem());
        if (!CRS.equalsIgnoreMetadata((Object)this.requestCRS, (Object)this.coverageProperties.crs2D)) {
            try {
                this.destinationToSourceTransform = CRS.findMathTransform((CoordinateReferenceSystem)this.requestCRS, (CoordinateReferenceSystem)this.coverageProperties.crs2D, (boolean)true);
            }
            catch (FactoryException e) {
                throw new DataSourceException("Unable to inspect request CRS", e);
            }
        }
        if (this.destinationToSourceTransform != null) {
            if (this.destinationToSourceTransform.isIdentity()) {
                this.destinationToSourceTransform = null;
                this.requestedBBox = new ReferencedEnvelope(this.requestedBBox, this.coverageProperties.crs2D);
            } else {
                this.needsReprojection = true;
                if (this.destinationToSourceTransform instanceof AffineTransform) {
                    AffineTransform mutableTransform = (AffineTransform)this.requestedGridToWorld.clone();
                    mutableTransform.preConcatenate((AffineTransform)this.destinationToSourceTransform);
                    try {
                        MathTransform tempTransform = PixelTranslation.translate((MathTransform)ProjectiveTransform.create((AffineTransform)mutableTransform), (PixelInCell)PixelInCell.CELL_CENTER, (PixelInCell)PixelInCell.CELL_CORNER);
                        this.requestedBBox = new ReferencedEnvelope((Envelope)CRS.transform((MathTransform)tempTransform, (Envelope)new GeneralEnvelope((Rectangle2D)this.requestedRasterArea)));
                    }
                    catch (Exception e) {
                        throw new DataSourceException("Unable to inspect request CRS", e);
                    }
                    this.destinationToSourceTransform = null;
                    this.needsReprojection = false;
                }
            }
        }
    }

    private void computeRasterArea() throws DataSourceException {
        if (this.emptyRequest || this.computedBBox == null) {
            throw new IllegalStateException("IllegalState, unable to compute raster area for null bbox");
        }
        try {
            MathTransform2D requestedWorldToGrid = (MathTransform2D)PixelTranslation.translate((MathTransform)ProjectiveTransform.create((AffineTransform)this.requestedGridToWorld), (PixelInCell)PixelInCell.CELL_CENTER, (PixelInCell)PixelInCell.CELL_CORNER).inverse();
            if (!this.needsReprojection) {
                this.computedRasterArea = new GeneralGridEnvelope((Envelope)CRS.transform((MathTransform)requestedWorldToGrid, (Envelope)new GeneralEnvelope((Envelope)this.computedBBox)), PixelInCell.CELL_CORNER, false).toRectangle();
            } else {
                GeneralEnvelope cropBBOXInRequestCRS = CRS.transform((Envelope)this.computedBBox, (CoordinateReferenceSystem)this.requestCRS);
                cropBBOXInRequestCRS.intersect((Envelope)this.requestedBBox);
                this.computedRasterArea = new GeneralGridEnvelope((Envelope)CRS.transform((MathTransform)requestedWorldToGrid, (Envelope)cropBBOXInRequestCRS), PixelInCell.CELL_CORNER, false).toRectangle();
                XRectangle2D.intersect((Rectangle2D)this.computedRasterArea, (Rectangle2D)this.requestedRasterArea, (Rectangle2D)this.computedRasterArea);
            }
        }
        catch (Exception e) {
            throw new DataSourceException(e);
        }
        if (this.computedRasterArea.isEmpty()) {
            this.emptyRequest = true;
            return;
        }
    }

    private void computeResolution() {
        try {
            GridGeometry2D gridGeometry;
            if (this.needsReprojection) {
                GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper((GridEnvelope)new GridEnvelope2D(this.computedRasterArea), (Envelope)this.computedBBox);
                this.computedGridToWorld = geMapper.createAffineTransform();
                gridGeometry = this.accurateResolution ? this.requestedGridGeometry : new GridGeometry2D((GridEnvelope)new GridEnvelope2D(this.computedRasterArea), (Envelope)this.computedBBox);
            } else {
                gridGeometry = this.requestedGridGeometry;
                this.computedGridToWorld = this.requestedGridToWorld;
            }
            ReadResolutionCalculator calculator = new ReadResolutionCalculator(gridGeometry, this.coverageProperties.crs2D, this.coverageProperties.fullResolution);
            calculator.setAccurateResolution(this.accurateResolution);
            this.computedResolution = calculator.computeRequestedResolution(ReferencedEnvelope.reference(this.computedBBox));
            return;
        }
        catch (Throwable e) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Unable to compute requested resolution", e);
            }
            LOGGER.log(Level.WARNING, "Unable to compute requested resolution, using highest available");
            this.computedResolution = this.coverageProperties.fullResolution;
            return;
        }
    }

    private double[] computeClassicResolution() {
        return new double[]{XAffineTransform.getScaleX0((AffineTransform)this.computedGridToWorld), XAffineTransform.getScaleY0((AffineTransform)this.computedGridToWorld)};
    }

    private double[] computeAccurateResolution() throws TransformException, NoninvertibleTransformException {
        GeneralEnvelope cropBboxTarget = CRS.transform((Envelope)this.computedBBox, (CoordinateReferenceSystem)this.requestCRS);
        double[] requestedResolution = new double[]{XAffineTransform.getScaleX0((AffineTransform)this.requestedGridToWorld), XAffineTransform.getScaleY0((AffineTransform)this.requestedGridToWorld)};
        double[] points = new double[36];
        for (int i = 0; i < 3; ++i) {
            double x = i == 0 ? cropBboxTarget.getMinimum(0) : (i == 1 ? cropBboxTarget.getMedian(0) : cropBboxTarget.getMaximum(0));
            for (int j = 0; j < 3; ++j) {
                double y = j == 0 ? cropBboxTarget.getMinimum(1) : (j == 1 ? cropBboxTarget.getMedian(1) : cropBboxTarget.getMaximum(1));
                int k = (i * 3 + j) * 4;
                points[k] = x - requestedResolution[0] / 2.0;
                points[k + 1] = y - requestedResolution[1] / 2.0;
                points[k + 2] = x + requestedResolution[0] / 2.0;
                points[k + 3] = y + requestedResolution[1] / 2.0;
            }
        }
        this.destinationToSourceTransform.transform(points, 0, points, 0, 18);
        double mx = Double.MAX_VALUE;
        double my = Double.MAX_VALUE;
        for (int i = 0; i < 36; i += 4) {
            double dx = points[i + 2] - points[i];
            double dy = points[i + 3] - points[i + 1];
            if (dx < mx) {
                mx = dx;
            }
            if (!(dy < my)) continue;
            my = dy;
        }
        return new double[]{mx, my};
    }

    private void computeCropBBOX() throws DataSourceException {
        try {
            if (this.needsReprojection) {
                GeneralEnvelope requestedBBoxInCoverageCRS = CRS.transform((Envelope)this.requestedBBox, (CoordinateReferenceSystem)this.coverageProperties.crs2D);
                this.computedBBox = new ReferencedEnvelope((Envelope)requestedBBoxInCoverageCRS);
            } else {
                this.computedBBox = new ReferencedEnvelope(this.requestedBBox);
            }
            if (!this.computedBBox.intersects(this.coverageProperties.bbox)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("The computed CropBoundingBox " + (Object)((Object)this.computedBBox) + " Doesn't intersect the coverage BoundingBox " + (Object)((Object)this.coverageProperties.bbox) + " resulting in an empty request");
                }
                this.computedBBox = null;
                this.emptyRequest = true;
                return;
            }
            this.computedBBox = new ReferencedEnvelope(this.computedBBox.intersection(this.coverageProperties.bbox), this.coverageProperties.crs2D);
            if (this.computedBBox.isEmpty()) {
                this.emptyRequest = true;
            }
            return;
        }
        catch (TransformException te) {
            block14: {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, te.getLocalizedMessage(), te);
                }
                try {
                    if (this.coverageProperties.geographicCRS != null && this.coverageProperties.geographicBBox != null) {
                        if (!CRS.equalsIgnoreMetadata((Object)this.coverageProperties.geographicCRS, (Object)this.requestCRS)) {
                            this.requestedBBOXInCoverageGeographicCRS = CRS.transform((Envelope)this.requestedBBox, (CoordinateReferenceSystem)this.coverageProperties.geographicCRS);
                            this.requestedBBOXInCoverageGeographicCRS.setCoordinateReferenceSystem(this.coverageProperties.geographicCRS);
                        }
                        if (this.requestedBBOXInCoverageGeographicCRS == null) {
                            this.requestedBBOXInCoverageGeographicCRS = new GeneralEnvelope(this.requestCRS);
                        }
                        if (!this.requestedBBOXInCoverageGeographicCRS.intersects((Envelope)this.coverageProperties.geographicBBox, true)) {
                            this.computedBBox = null;
                            this.emptyRequest = true;
                            return;
                        }
                        this.requestedBBOXInCoverageGeographicCRS.intersect((Envelope)this.coverageProperties.geographicBBox);
                        this.requestedBBOXInCoverageGeographicCRS.setCoordinateReferenceSystem(this.coverageProperties.geographicCRS);
                        this.approximateRequestedBBoInNativeCRS = CRS.transform((Envelope)this.requestedBBOXInCoverageGeographicCRS, (CoordinateReferenceSystem)this.coverageProperties.crs2D);
                        this.approximateRequestedBBoInNativeCRS.setCoordinateReferenceSystem(this.coverageProperties.crs2D);
                        this.computedBBox = new ReferencedEnvelope((Envelope)this.approximateRequestedBBoInNativeCRS);
                        return;
                    }
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block14;
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
            }
            LOGGER.log(Level.INFO, "We did not manage to crop the requested envelope, we fall back onto loading the whole coverage.");
            this.computedBBox = null;
            return;
        }
    }

    public boolean isEmpty() {
        return this.emptyRequest;
    }

    public boolean isNeedsReprojection() {
        return this.needsReprojection;
    }

    public boolean isAccurateResolution() {
        return this.accurateResolution;
    }

    public void setAccurateResolution(boolean accurateResolution) {
        this.accurateResolution = accurateResolution;
    }

    public double[] getComputedResolution() {
        return this.computedResolution != null ? (double[])this.computedResolution.clone() : null;
    }

    public Rectangle getComputedRasterArea() {
        return (Rectangle)(this.computedRasterArea != null ? this.computedRasterArea.clone() : this.computedRasterArea);
    }

    public BoundingBox getComputedBBox() {
        return this.computedBBox;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SpatialRequestHelper [");
        if (this.requestedBBox != null) {
            builder.append("requestedBBox=");
            builder.append((Object)this.requestedBBox);
            builder.append(", ");
        }
        if (this.computedBBox != null) {
            builder.append("cropBBox=");
            builder.append((Object)this.computedBBox);
            builder.append(", ");
        }
        if (this.requestedRasterArea != null) {
            builder.append("requestedRasterArea=");
            builder.append(this.requestedRasterArea);
            builder.append(", ");
        }
        if (this.computedRasterArea != null) {
            builder.append("destinationRasterArea=");
            builder.append(this.computedRasterArea);
            builder.append(", ");
        }
        if (this.requestCRS != null) {
            builder.append("requestCRS=");
            builder.append(this.requestCRS);
            builder.append(", ");
        }
        if (this.requestedGridToWorld != null) {
            builder.append("requestedGridToWorld=");
            builder.append(this.requestedGridToWorld);
            builder.append(", ");
        }
        if (this.computedResolution != null) {
            builder.append("requestedResolution=");
            builder.append(Arrays.toString(this.computedResolution));
            builder.append(", ");
        }
        if (this.requestedBBOXInCoverageGeographicCRS != null) {
            builder.append("requestedBBOXInCoverageGeographicCRS=");
            builder.append(this.requestedBBOXInCoverageGeographicCRS);
            builder.append(", ");
        }
        if (this.requestCRSToCoverageGeographicCRS2D != null) {
            builder.append("requestCRSToCoverageGeographicCRS2D=");
            builder.append(this.requestCRSToCoverageGeographicCRS2D);
            builder.append(", ");
        }
        if (this.destinationToSourceTransform != null) {
            builder.append("destinationToSourceTransform=");
            builder.append(this.destinationToSourceTransform);
            builder.append(", ");
        }
        if (this.coverageProperties != null) {
            builder.append("coverageProperties=");
            builder.append(this.coverageProperties);
            builder.append(", ");
        }
        builder.append("accurateResolution=");
        builder.append(this.accurateResolution);
        builder.append(", empty=");
        builder.append(this.emptyRequest);
        builder.append(", needsReprojection=");
        builder.append(this.needsReprojection);
        builder.append(", ");
        if (this.approximateRequestedBBoInNativeCRS != null) {
            builder.append("approximateRequestedBBoInNativeCRS=");
            builder.append(this.approximateRequestedBBoInNativeCRS);
        }
        builder.append("]");
        return builder.toString();
    }

    public AffineTransform getComputedGridToWorld() {
        return this.computedGridToWorld;
    }

    public static class CoverageProperties {
        ReferencedEnvelope bbox;
        Rectangle rasterArea;
        double[] fullResolution;
        MathTransform2D gridToWorld2D;
        CoordinateReferenceSystem crs2D;
        ReferencedEnvelope geographicBBox;
        CoordinateReferenceSystem geographicCRS;

        public ReferencedEnvelope getBbox() {
            return this.bbox;
        }

        public void setBBox(ReferencedEnvelope bbox) {
            this.bbox = bbox;
        }

        public Rectangle getRasterArea() {
            return this.rasterArea;
        }

        public void setRasterArea(Rectangle rasterArea) {
            this.rasterArea = rasterArea;
        }

        public double[] getFullResolution() {
            return this.fullResolution;
        }

        public void setFullResolution(double[] fullResolution) {
            this.fullResolution = fullResolution;
        }

        public MathTransform2D getGridToWorld2D() {
            return this.gridToWorld2D;
        }

        public void setGridToWorld2D(MathTransform2D gridToWorld2D) {
            this.gridToWorld2D = gridToWorld2D;
        }

        public CoordinateReferenceSystem getCrs2D() {
            return this.crs2D;
        }

        public void setCrs2D(CoordinateReferenceSystem crs2d) {
            this.crs2D = crs2d;
        }

        public ReferencedEnvelope getGeographicBBox() {
            return this.geographicBBox;
        }

        public void setGeographicBBox(ReferencedEnvelope geographicBBox) {
            this.geographicBBox = geographicBBox;
        }

        public CoordinateReferenceSystem getGeographicCRS2D() {
            return this.geographicCRS;
        }

        public void setGeographicCRS2D(CoordinateReferenceSystem geographicCRS2D) {
            this.geographicCRS = geographicCRS2D;
        }
    }
}

