/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.util.Assert;
import it.geosolutions.imageio.pam.PAMDataset;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.measure.unit.Unit;
import javax.media.jai.BorderExtender;
import javax.media.jai.Histogram;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.media.jai.TileCache;
import javax.media.jai.TileScheduler;
import javax.media.jai.operator.ConstantDescriptor;
import javax.media.jai.operator.FormatDescriptor;
import javax.media.jai.operator.MosaicDescriptor;
import javax.media.jai.operator.MosaicType;
import javax.media.jai.operator.TranslateDescriptor;
import org.apache.commons.io.FilenameUtils;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.factory.Hints;
import org.geotools.filter.SortByImpl;
import org.geotools.gce.imagemosaic.FootprintBehavior;
import org.geotools.gce.imagemosaic.GranuleDescriptor;
import org.geotools.gce.imagemosaic.GranuleLoader;
import org.geotools.gce.imagemosaic.MergeBehavior;
import org.geotools.gce.imagemosaic.OverviewsController;
import org.geotools.gce.imagemosaic.RasterLayerRequest;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.gce.imagemosaic.ReadParamsController;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalogVisitor;
import org.geotools.gce.imagemosaic.processing.ArtifactsFilterDescriptor;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.resources.coverage.FeatureUtilities;
import org.geotools.resources.geometry.XRectangle2D;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.util.NumberRange;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.jaitools.imageutils.ImageLayout2;
import org.jaitools.imageutils.ROIGeometry;
import org.opengis.coverage.ColorInterpretation;
import org.opengis.coverage.SampleDimension;
import org.opengis.coverage.SampleDimensionType;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.opengis.filter.spatial.BBOX;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.CodeList;
import org.opengis.util.InternationalString;

class RasterLayerResponse {
    private static final Logger LOGGER = Logging.getLogger(RasterLayerResponse.class);
    private GridCoverage2D gridCoverage;
    private RasterLayerRequest request;
    private GridCoverageFactory coverageFactory;
    private GeneralEnvelope coverageEnvelope;
    private RasterManager rasterManager;
    private Color finalTransparentColor;
    private ReferencedEnvelope mosaicBBox;
    private Rectangle rasterBounds;
    private MathTransform2D finalGridToWorldCorner;
    private MathTransform2D finalWorldToGridCorner;
    private int imageChoice = 0;
    private ImageReadParam baseReadParameters = new ImageReadParam();
    private boolean multithreadingAllowed;
    private FootprintBehavior footprintBehavior = FootprintBehavior.None;
    private int defaultArtifactsFilterThreshold = Integer.MIN_VALUE;
    private double artifactsFilterPTileThreshold = 0.1;
    private boolean oversampledRequest;
    private MathTransform baseGridToWorld;
    private Interpolation interpolation;
    private boolean needsReprojection;
    private double[] backgroundValues;
    private Hints hints;
    private String granulesPaths;

    public RasterLayerResponse(RasterLayerRequest request, RasterManager rasterManager) {
        this.request = request;
        this.coverageEnvelope = rasterManager.spatialDomainManager.coverageEnvelope;
        this.coverageFactory = rasterManager.getCoverageFactory();
        this.rasterManager = rasterManager;
        this.hints = rasterManager.getHints();
        this.baseGridToWorld = rasterManager.spatialDomainManager.coverageGridToWorld2D;
        this.finalTransparentColor = request.getOutputTransparentColor();
        this.multithreadingAllowed = request.isMultithreadingAllowed();
        this.footprintBehavior = request.getFootprintBehavior();
        this.backgroundValues = request.getBackgroundValues();
        this.interpolation = request.getInterpolation();
        this.needsReprojection = request.spatialRequestHelper.isNeedsReprojection();
        this.defaultArtifactsFilterThreshold = request.getDefaultArtifactsFilterThreshold();
        this.artifactsFilterPTileThreshold = request.getArtifactsFilterPTileThreshold();
    }

    public GridCoverage2D createResponse() throws IOException {
        this.processRequest();
        return this.gridCoverage;
    }

    public RasterLayerRequest getOriginatingCoverageRequest() {
        return this.request;
    }

    private void processRequest() throws IOException {
        if (this.request.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Request is empty: " + this.request.toString());
            }
            this.gridCoverage = null;
            return;
        }
        MosaicOutput mosaic = this.prepareResponse();
        if (mosaic == null || mosaic.image == null) {
            this.gridCoverage = null;
            return;
        }
        MosaicOutput finalMosaic = this.postProcessRaster(mosaic);
        this.gridCoverage = this.prepareCoverage(finalMosaic);
    }

    private MosaicOutput postProcessRaster(MosaicOutput mosaickedImage) {
        if (this.finalTransparentColor != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Support for alpha on final mosaic");
            }
            return new MosaicOutput(new ImageWorker(mosaickedImage.image).makeColorTransparent(this.finalTransparentColor).getRenderedImage(), mosaickedImage.pamDataset);
        }
        return mosaickedImage;
    }

    private MosaicOutput prepareResponse() throws DataSourceException {
        try {
            this.chooseOverview();
            this.initBBOX();
            this.initTransformations();
            this.initRasterBounds();
            Query query = this.initQuery();
            this.handleAdditionalFilters(query);
            this.handleSortByClause(query);
            MosaicProducer visitor = new MosaicProducer();
            this.rasterManager.getGranuleDescriptors(query, visitor);
            MosaicOutput returnValue = visitor.produce();
            if (returnValue != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Loaded bbox " + this.mosaicBBox.toString() + " while crop bbox " + this.request.spatialRequestHelper.getComputedBBox().toString());
                }
                return returnValue;
            }
            LOGGER.fine("We got no granules, let's do a dry run with no filters");
            MosaicProducer dryRunVisitor = new MosaicProducer(true);
            Utils.BBOXFilterExtractor bboxExtractor = new Utils.BBOXFilterExtractor();
            query.getFilter().accept((FilterVisitor)bboxExtractor, null);
            query.setFilter((Filter)FeatureUtilities.DEFAULT_FILTER_FACTORY.bbox((Expression)FeatureUtilities.DEFAULT_FILTER_FACTORY.property(this.rasterManager.getGranuleCatalog().getType(this.rasterManager.getTypeName()).getGeometryDescriptor().getName()), (BoundingBox)bboxExtractor.getBBox()));
            query.setMaxFeatures(1);
            this.rasterManager.getGranuleDescriptors(query, dryRunVisitor);
            if (dryRunVisitor.granulesNumber > 0) {
                LOGGER.fine("Dry run got a target granule, returning null as the additional filters did filter all the granules out");
                return null;
            }
            return this.createBlankResponse();
        }
        catch (Exception e) {
            throw new DataSourceException("Unable to create this mosaic", e);
        }
    }

    private void initRasterBounds() throws TransformException {
        GeneralEnvelope tempRasterBounds = CRS.transform((MathTransform)this.finalWorldToGridCorner, (org.opengis.geometry.Envelope)this.mosaicBBox);
        this.rasterBounds = tempRasterBounds.toRectangle2D().getBounds();
        if (this.rasterBounds.width == 0) {
            ++this.rasterBounds.width;
        }
        if (this.rasterBounds.height == 0) {
            ++this.rasterBounds.height;
        }
        if (this.oversampledRequest) {
            this.rasterBounds.grow(2, 2);
        }
    }

    private void initTransformations() throws Exception {
        AffineTransform g2w;
        if (!this.request.isHeterogeneousGranules()) {
            OverviewsController.OverviewLevel baseLevel = this.rasterManager.overviewsController.resolutionsLevels.get(0);
            OverviewsController.OverviewLevel selectedLevel = this.rasterManager.overviewsController.resolutionsLevels.get(this.imageChoice);
            double resX = baseLevel.resolutionX;
            double resY = baseLevel.resolutionY;
            double[] requestRes = this.request.spatialRequestHelper.getComputedResolution();
            g2w = new AffineTransform((AffineTransform)this.baseGridToWorld);
            g2w.concatenate(CoverageUtilities.CENTER_TO_CORNER);
            if (requestRes[0] < resX || requestRes[1] < resY) {
                this.oversampledRequest = true;
            } else {
                g2w.concatenate(AffineTransform.getScaleInstance(selectedLevel.scaleFactor, selectedLevel.scaleFactor));
                g2w.concatenate(AffineTransform.getScaleInstance(this.baseReadParameters.getSourceXSubsampling(), this.baseReadParameters.getSourceYSubsampling()));
            }
        } else {
            g2w = new AffineTransform(this.request.spatialRequestHelper.isNeedsReprojection() ? this.request.spatialRequestHelper.getComputedGridToWorld() : this.request.spatialRequestHelper.getComputedGridToWorld());
            g2w.concatenate(CoverageUtilities.CENTER_TO_CORNER);
        }
        this.finalGridToWorldCorner = new AffineTransform2D(g2w);
        this.finalWorldToGridCorner = this.finalGridToWorldCorner.inverse();
    }

    private void initBBOX() {
        BoundingBox cropBBOX = this.request.spatialRequestHelper.getComputedBBox();
        this.mosaicBBox = cropBBOX != null ? ReferencedEnvelope.reference(cropBBOX) : new ReferencedEnvelope((org.opengis.geometry.Envelope)this.coverageEnvelope);
    }

    private void chooseOverview() throws IOException, TransformException {
        this.imageChoice = this.request.spatialRequestHelper.getComputedBBox() != null && this.request.spatialRequestHelper.getComputedRasterArea() != null && !this.request.isHeterogeneousGranules() ? ReadParamsController.setReadParams(this.request.spatialRequestHelper.getComputedResolution(), this.request.getOverviewPolicy(), this.request.getDecimationPolicy(), this.baseReadParameters, this.request.rasterManager, this.request.rasterManager.overviewsController) : 0;
        assert (this.imageChoice >= 0);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Loading level " + this.imageChoice + " with subsampling factors " + this.baseReadParameters.getSourceXSubsampling() + " " + this.baseReadParameters.getSourceYSubsampling());
        }
    }

    private Query initQuery() throws Exception {
        GeneralEnvelope levelRasterArea_ = CRS.transform((MathTransform)this.finalWorldToGridCorner, (org.opengis.geometry.Envelope)this.rasterManager.spatialDomainManager.coverageBBox);
        GridEnvelope2D levelRasterArea = new GridEnvelope2D(new Envelope2D((org.opengis.geometry.Envelope)levelRasterArea_), PixelInCell.CELL_CORNER);
        XRectangle2D.intersect((Rectangle2D)levelRasterArea, (Rectangle2D)this.rasterBounds, (Rectangle2D)this.rasterBounds);
        String typeName = this.rasterManager.getTypeName();
        BBOX bbox = null;
        if (typeName != null) {
            Query query = new Query(typeName);
            if (this.request.getMaximumNumberOfGranules() > 0) {
                query.setMaxFeatures(this.request.getMaximumNumberOfGranules());
            }
            bbox = FeatureUtilities.DEFAULT_FILTER_FACTORY.bbox((Expression)FeatureUtilities.DEFAULT_FILTER_FACTORY.property(this.rasterManager.getGranuleCatalog().getType(typeName).getGeometryDescriptor().getName()), (BoundingBox)this.mosaicBBox);
            query.setFilter((Filter)bbox);
            return query;
        }
        throw new IllegalStateException("GranuleCatalog feature type was null!!!");
    }

    private void handleAdditionalFilters(Query query) {
        boolean hasFilter;
        List<?> times = this.request.getRequestedTimes();
        List<?> elevations = this.request.getElevation();
        Map<String, List> additionalDomains = this.request.getRequestedAdditionalDomains();
        Filter filter = this.request.getFilter();
        boolean hasTime = times != null && times.size() > 0;
        boolean hasElevation = elevations != null && elevations.size() > 0;
        boolean hasAdditionalDomains = additionalDomains.size() > 0;
        boolean bl = hasFilter = filter != null && !Filter.INCLUDE.equals(filter);
        if (hasElevation) {
            Filter elevationF = this.rasterManager.elevationDomainManager.createFilter("ELEVATION_DOMAIN", elevations);
            query.setFilter((Filter)FeatureUtilities.DEFAULT_FILTER_FACTORY.and(query.getFilter(), elevationF));
        }
        if (hasFilter) {
            query.setFilter((Filter)FeatureUtilities.DEFAULT_FILTER_FACTORY.and(query.getFilter(), filter));
        }
        if (hasTime) {
            Filter timeFilter = this.rasterManager.timeDomainManager.createFilter("TIME_DOMAIN", times);
            query.setFilter((Filter)FeatureUtilities.DEFAULT_FILTER_FACTORY.and(query.getFilter(), timeFilter));
        }
        if (hasAdditionalDomains) {
            ArrayList<Filter> additionalFilter = new ArrayList<Filter>();
            for (Map.Entry<String, List> entry : additionalDomains.entrySet()) {
                String domainName = entry.getKey() + "_DOMAIN";
                additionalFilter.add(this.rasterManager.domainsManager.createFilter(domainName, entry.getValue()));
            }
            query.setFilter((Filter)FeatureUtilities.DEFAULT_FILTER_FACTORY.and(query.getFilter(), (Filter)FeatureUtilities.DEFAULT_FILTER_FACTORY.and(additionalFilter)));
        }
    }

    private void handleSortByClause(Query query) {
        Utilities.ensureNonNull((String)"query", (Object)query);
        LOGGER.fine("Prepping to manage SortBy Clause");
        String sortByClause = this.request.getSortClause();
        if (sortByClause != null && sortByClause.length() > 0) {
            String[] elements = sortByClause.split(",");
            if (elements != null && elements.length > 0) {
                ArrayList<SortByImpl> clauses = new ArrayList<SortByImpl>(elements.length);
                for (String element : elements) {
                    if (element == null || element.length() <= 0) continue;
                    try {
                        String attribute;
                        element = element.trim();
                        if (element.endsWith(" A")) {
                            attribute = element.substring(0, element.length() - 2);
                            clauses.add(new SortByImpl(FeatureUtilities.DEFAULT_FILTER_FACTORY.property(attribute), SortOrder.ASCENDING));
                            LOGGER.fine("Added clause ASCENDING on attribute:" + attribute);
                            continue;
                        }
                        if (element.contains(" D")) {
                            attribute = element.substring(0, element.length() - 2);
                            clauses.add(new SortByImpl(FeatureUtilities.DEFAULT_FILTER_FACTORY.property(attribute), SortOrder.DESCENDING));
                            LOGGER.fine("Added clause DESCENDING on attribute:" + attribute);
                            continue;
                        }
                        LOGGER.fine("Ignoring sort clause :" + element);
                    }
                    catch (Exception e) {
                        if (!LOGGER.isLoggable(Level.INFO)) continue;
                        LOGGER.log(Level.INFO, e.getLocalizedMessage(), e);
                    }
                }
                SortBy[] sb = clauses.toArray(new SortBy[0]);
                if (this.rasterManager.getGranuleCatalog().getQueryCapabilities(this.rasterManager.getTypeName()).supportsSorting(sb)) {
                    query.setSortBy(sb);
                }
            } else {
                LOGGER.fine("No SortBy Clause");
            }
        }
    }

    private MosaicOutput createBlankResponse() {
        Color inputTransparentColor;
        Object finalImage;
        LOGGER.fine("Creating constant image for area with no data");
        ImageLayout2 il = new ImageLayout2();
        il.setColorModel(this.rasterManager.defaultCM);
        Dimension tileSize = this.request.getTileDimensions();
        if (tileSize == null) {
            tileSize = JAI.getDefaultTileSize();
        }
        il.setTileGridXOffset(0).setTileGridYOffset(0).setTileWidth((int)tileSize.getWidth()).setTileHeight((int)tileSize.getHeight());
        RenderingHints renderingHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, il);
        Number[] values = ImageUtilities.getBackgroundValues((SampleModel)this.rasterManager.defaultSM, (double[])this.backgroundValues);
        if (ImageUtilities.isMediaLibAvailable()) {
            finalImage = ConstantDescriptor.create((Float)Float.valueOf(this.rasterBounds.width), (Float)Float.valueOf(this.rasterBounds.height), (Number[])values, (RenderingHints)renderingHints);
            if (this.rasterBounds.x != 0 || this.rasterBounds.y != 0) {
                finalImage = TranslateDescriptor.create((RenderedImage)finalImage, (Float)Float.valueOf(this.rasterBounds.x), (Float)Float.valueOf(this.rasterBounds.y), (Interpolation)Interpolation.getInstance((int)0), null);
            }
            if (this.rasterManager.defaultCM != null) {
                il.setColorModel(this.rasterManager.defaultCM);
                il.setSampleModel(this.rasterManager.defaultCM.createCompatibleSampleModel(tileSize.width, tileSize.height));
                finalImage = FormatDescriptor.create((RenderedImage)finalImage, (Integer)il.getSampleModel(null).getDataType(), (RenderingHints)renderingHints);
            }
        } else {
            il.setWidth(this.rasterBounds.width).setHeight(this.rasterBounds.height);
            if (this.rasterBounds.x != 0 || this.rasterBounds.y != 0) {
                il.setMinX(this.rasterBounds.x).setMinY(this.rasterBounds.y);
            }
            if (this.rasterManager.defaultCM != null) {
                il.setColorModel(this.rasterManager.defaultCM);
                il.setSampleModel(this.rasterManager.defaultCM.createCompatibleSampleModel(tileSize.width, tileSize.height));
            }
            double[] bkgValues = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                bkgValues[i] = values[i].doubleValue();
            }
            Assert.isTrue((boolean)il.isValid(268));
            finalImage = MosaicDescriptor.create((RenderedImage[])new RenderedImage[0], (MosaicType)MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, (double[][])new double[][]{{CoverageUtilities.getMosaicThreshold((int)il.getSampleModel(null).getDataType())}}, (double[])bkgValues, (RenderingHints)renderingHints);
        }
        if (!((inputTransparentColor = this.request.getInputTransparentColor()) == null || this.footprintBehavior != null && this.footprintBehavior.handleFootprints())) {
            boolean hasAlpha;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Support for alpha on blank image");
            }
            if (!(hasAlpha = (finalImage = new ImageWorker((RenderedImage)finalImage).makeColorTransparent(inputTransparentColor).getRenderedImage()).getColorModel().hasAlpha())) {
                finalImage = new ImageWorker((RenderedImage)finalImage).forceComponentColorModel(true).makeColorTransparent(inputTransparentColor).getRenderedImage();
                hasAlpha = finalImage.getColorModel().hasAlpha();
            }
            assert (hasAlpha);
        } else if (this.footprintBehavior != null && !this.footprintBehavior.handleFootprints()) {
            finalImage = this.footprintBehavior.postProcessBlankResponse((RenderedImage)finalImage, renderingHints);
        }
        return new MosaicOutput((RenderedImage)finalImage, null);
    }

    private GridCoverage2D prepareCoverage(MosaicOutput mosaicOutput) throws IOException {
        RenderedImage image = mosaicOutput.image;
        SampleModel sm = image.getSampleModel();
        ColorModel cm = image.getColorModel();
        int numBands = sm.getNumBands();
        GridSampleDimension[] bands = new GridSampleDimension[numBands];
        HashSet bandNames = new HashSet();
        for (int i = 0; i < numBands; ++i) {
            double noData;
            ColorInterpretation colorInterpretation = null;
            String bandName = null;
            if (cm != null) {
                colorInterpretation = TypeMap.getColorInterpretation((ColorModel)cm, (int)i);
                if (colorInterpretation == null) {
                    throw new IOException("Unrecognized sample dimension type");
                }
                bandName = colorInterpretation.name();
                if (colorInterpretation == ColorInterpretation.UNDEFINED || bandNames.contains(bandName)) {
                    bandName = "Band" + (i + 1);
                }
            } else {
                bandName = "Band" + (i + 1);
                colorInterpretation = ColorInterpretation.UNDEFINED;
            }
            SampleDimensionType st = TypeMap.getSampleDimensionType((SampleModel)sm, (int)i);
            double min = -1.7976931348623157E308;
            double max = Double.MAX_VALUE;
            if (this.backgroundValues != null) {
                noData = this.backgroundValues[this.backgroundValues.length > i ? i : 0];
            } else if (st.compareTo((CodeList)SampleDimensionType.REAL_32BITS) == 0) {
                noData = Double.NaN;
            } else if (st.compareTo((CodeList)SampleDimensionType.REAL_64BITS) == 0) {
                noData = Double.NaN;
            } else if (st.compareTo((CodeList)SampleDimensionType.SIGNED_16BITS) == 0) {
                noData = -32768.0;
                min = -32768.0;
                max = 32767.0;
            } else if (st.compareTo((CodeList)SampleDimensionType.SIGNED_32BITS) == 0) {
                noData = -2.147483648E9;
                min = -2.147483648E9;
                max = 2.147483647E9;
            } else if (st.compareTo((CodeList)SampleDimensionType.SIGNED_8BITS) == 0) {
                noData = -128.0;
                min = -128.0;
                max = 127.0;
            } else {
                noData = 0.0;
                min = 0.0;
                if (st.compareTo((CodeList)SampleDimensionType.UNSIGNED_1BIT) == 0) {
                    max = 1.0;
                } else if (st.compareTo((CodeList)SampleDimensionType.UNSIGNED_2BITS) == 0) {
                    max = 3.0;
                } else if (st.compareTo((CodeList)SampleDimensionType.UNSIGNED_4BITS) == 0) {
                    max = 7.0;
                } else if (st.compareTo((CodeList)SampleDimensionType.UNSIGNED_8BITS) == 0) {
                    max = 255.0;
                } else if (st.compareTo((CodeList)SampleDimensionType.UNSIGNED_16BITS) == 0) {
                    max = 65535.0;
                } else if (st.compareTo((CodeList)SampleDimensionType.UNSIGNED_32BITS) == 0) {
                    max = Math.pow(2.0, 32.0) - 1.0;
                }
            }
            bands[i] = new SimplifiedGridSampleDimension(bandName, st, colorInterpretation, noData, min, max, 1.0, 0.0, null).geophysics(true);
        }
        HashMap<String, String> properties = null;
        if (this.granulesPaths != null) {
            properties = new HashMap<String, String>();
            properties.put("OriginalFileSource", this.granulesPaths);
        }
        if (mosaicOutput.pamDataset != null) {
            properties.put("PamDataset", (String)mosaicOutput.pamDataset);
        }
        return this.coverageFactory.create((CharSequence)this.rasterManager.getCoverageIdentifier(), image, new GridGeometry2D((GridEnvelope)new GridEnvelope2D(PlanarImage.wrapRenderedImage((RenderedImage)image).getBounds()), PixelInCell.CELL_CORNER, (MathTransform)this.finalGridToWorldCorner, this.mosaicBBox.getCoordinateReferenceSystem(), this.hints), bands, null, properties);
    }

    private class MosaicProducer
    implements GranuleCatalogVisitor {
        private int granulesNumber;
        private MergeBehavior mergeBehavior;
        private List<GranuleCollector> granuleCollectors = new ArrayList<GranuleCollector>();

        private MosaicProducer() {
            this(false);
        }

        private MosaicProducer(boolean dryRun) {
            Map<String, List> requestedAdditionalDomains;
            this.mergeBehavior = RasterLayerResponse.this.request.getMergeBehavior();
            if (this.mergeBehavior.equals((Object)MergeBehavior.STACK) && !(requestedAdditionalDomains = RasterLayerResponse.this.request.getRequestedAdditionalDomains()).isEmpty()) {
                And andFilter;
                Set<Map.Entry<String, List>> entries = requestedAdditionalDomains.entrySet();
                this.checkMultipleSelection(entries);
                Map.Entry<String, List> multipleSelectionEntry = null;
                ArrayList<Filter> filters = new ArrayList<Filter>(entries.size());
                for (Map.Entry<String, List> entry : entries) {
                    if (entry.getValue().size() > 1) {
                        multipleSelectionEntry = entry;
                        continue;
                    }
                    String domainName = entry.getKey() + "_DOMAIN";
                    filters.add(((RasterLayerResponse)RasterLayerResponse.this).rasterManager.domainsManager.createFilter(domainName, Arrays.asList(entry.getValue())));
                }
                And and = andFilter = filters.size() > 0 ? FeatureUtilities.DEFAULT_FILTER_FACTORY.and(filters) : null;
                if (multipleSelectionEntry == null) {
                    this.granuleCollectors.add(new GranuleCollector((Filter)andFilter, dryRun));
                } else {
                    String domainName = multipleSelectionEntry.getKey() + "_DOMAIN";
                    List values = multipleSelectionEntry.getValue();
                    for (Object o : values) {
                        Filter valueFilter = ((RasterLayerResponse)RasterLayerResponse.this).rasterManager.domainsManager.createFilter(domainName, Arrays.asList(o));
                        Filter combinedFilter = andFilter == null ? valueFilter : FeatureUtilities.DEFAULT_FILTER_FACTORY.and((Filter)andFilter, valueFilter);
                        this.granuleCollectors.add(new GranuleCollector(combinedFilter, dryRun));
                    }
                }
            }
            if (this.granuleCollectors.isEmpty()) {
                this.granuleCollectors.add(new GranuleCollector((Filter)Filter.INCLUDE, dryRun));
            }
        }

        private void checkMultipleSelection(Set<Map.Entry<String, List>> entries) {
            int multipleDimensionsSelections = 0;
            for (Map.Entry<String, List> entry : entries) {
                if (entry.getValue().size() <= 1 || ++multipleDimensionsSelections <= 1) continue;
                throw new IllegalStateException("Unable to handle dimensions stacking for more than 1 dimension");
            }
        }

        @Override
        public void visit(GranuleDescriptor granuleDescriptor, Object o) {
            Polygon bb = JTS.toGeometry((BoundingBox)RasterLayerResponse.this.mosaicBBox);
            Geometry inclusionGeometry = granuleDescriptor.getFootprint();
            if (!RasterLayerResponse.this.footprintBehavior.handleFootprints() || inclusionGeometry == null || RasterLayerResponse.this.footprintBehavior.handleFootprints() && inclusionGeometry.intersects((Geometry)bb)) {
                boolean found = false;
                for (GranuleCollector collector : this.granuleCollectors) {
                    if (!collector.accept(granuleDescriptor)) continue;
                    ++this.granulesNumber;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new IllegalStateException("Unable to locate a filter for this granule:\n" + granuleDescriptor.toString());
                }
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("We rejected for non ROI inclusion the granule " + granuleDescriptor.toString());
            }
        }

        private MosaicOutput produce() throws IOException {
            if (this.granulesNumber == 0) {
                LOGGER.log(Level.FINE, "Unable to load any granuleDescriptor");
                return null;
            }
            LOGGER.fine("Producing the final mosaic, step 1, loop through granule collectors");
            ArrayList<MosaicElement> mosaicInputs = new ArrayList<MosaicElement>();
            GranuleCollector first = null;
            int size = this.granuleCollectors.size();
            for (GranuleCollector collector : this.granuleCollectors) {
                MosaicElement preparedMosaic;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Using collector with filter:" + collector.granuleFilter.toString());
                }
                if ((preparedMosaic = new Mosaicker(collector.collectGranules(), MergeBehavior.FLAT).createMosaic()) != null) {
                    mosaicInputs.add(preparedMosaic);
                    if (first != null) continue;
                    first = collector;
                    continue;
                }
                --size;
            }
            LOGGER.fine("Producing the final mosaic, step 2, final mosaicking");
            if (size == 1) {
                return new MosaicOutput((MosaicElement)mosaicInputs.get(0));
            }
            if (size == 0) {
                return null;
            }
            MosaicInputs mosaickingInputs = new MosaicInputs(first.doInputTransparency, first.hasAlpha, mosaicInputs, first.sourceThreshold);
            return new MosaicOutput(new Mosaicker(mosaickingInputs, this.mergeBehavior).createMosaic());
        }
    }

    private class Mosaicker {
        private final List<MosaicElement> inputs;
        private final double[][] sourceThreshold;
        private final boolean doInputTransparency;
        private final boolean hasAlpha;
        private final MergeBehavior mergeBehavior;

        private Mosaicker(MosaicInputs inputs, MergeBehavior mergeBehavior) {
            this.inputs = new ArrayList<MosaicElement>(inputs.sources);
            this.sourceThreshold = inputs.sourceThreshold;
            this.doInputTransparency = inputs.doInputTransparency;
            this.hasAlpha = inputs.hasAlpha;
            this.mergeBehavior = mergeBehavior;
        }

        private RenderingHints prepareHints() {
            ImageLayout layout = new ImageLayout(((RasterLayerResponse)RasterLayerResponse.this).rasterBounds.x, ((RasterLayerResponse)RasterLayerResponse.this).rasterBounds.y, ((RasterLayerResponse)RasterLayerResponse.this).rasterBounds.width, ((RasterLayerResponse)RasterLayerResponse.this).rasterBounds.height);
            Dimension tileDimensions = RasterLayerResponse.this.request.getTileDimensions();
            if (tileDimensions == null) {
                tileDimensions = (Dimension)JAI.getDefaultTileSize().clone();
            }
            layout.setTileGridXOffset(0).setTileGridYOffset(0);
            layout.setTileHeight(tileDimensions.width).setTileWidth(tileDimensions.height);
            RenderingHints localHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
            if (RasterLayerResponse.this.hints != null && !RasterLayerResponse.this.hints.isEmpty()) {
                TileScheduler tileScheduler;
                TileCache tc = Utils.getTileCacheHint((RenderingHints)RasterLayerResponse.this.hints);
                if (tc != null) {
                    localHints.add(new RenderingHints(JAI.KEY_TILE_CACHE, tc));
                }
                localHints.add(ImageUtilities.BORDER_EXTENDER_HINTS);
                BorderExtender be = Utils.getBorderExtenderHint((RenderingHints)RasterLayerResponse.this.hints);
                if (be != null) {
                    localHints.add(new RenderingHints(JAI.KEY_BORDER_EXTENDER, be));
                }
                if ((tileScheduler = Utils.getTileSchedulerHint((RenderingHints)RasterLayerResponse.this.hints)) != null) {
                    localHints.add(new RenderingHints(JAI.KEY_TILE_SCHEDULER, tileScheduler));
                }
            }
            return localHints;
        }

        private MosaicElement createMosaic() throws IOException {
            int size = this.inputs.size();
            if (size <= 0) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to load any granuleDescriptor ");
                }
                return null;
            }
            RenderingHints localHints = this.prepareHints();
            if (size == 1 && Utils.OPTIMIZE_CROP) {
                RenderedImage mosaic;
                Rectangle imageBounds;
                Rectangle bounds;
                MosaicElement in = this.inputs.get(0);
                if (in == null) {
                    throw new NullPointerException("The list of MosaicElements contains one element but it's null");
                }
                PAMDataset pamDataset = in.pamDataset;
                ROI roi = in.roi;
                if (roi != null && (bounds = Utils.toRectangle(roi.getAsShape())) != null && (imageBounds = PlanarImage.wrapRenderedImage((RenderedImage)(mosaic = in.source)).getBounds()).equals(bounds)) {
                    if (!RasterLayerResponse.this.rasterBounds.contains(imageBounds)) {
                        XRectangle2D.intersect((Rectangle2D)imageBounds, (Rectangle2D)RasterLayerResponse.this.rasterBounds, (Rectangle2D)imageBounds);
                        if (imageBounds.isEmpty()) {
                            return null;
                        }
                        ImageWorker iw = new ImageWorker(mosaic);
                        iw.setRenderingHints(localHints);
                        iw.crop((float)imageBounds.x, (float)imageBounds.y, (float)imageBounds.width, (float)imageBounds.height);
                        mosaic = iw.getRenderedImage();
                        imageBounds = PlanarImage.wrapRenderedImage((RenderedImage)mosaic).getBounds();
                    }
                    if (!imageBounds.contains(RasterLayerResponse.this.rasterBounds)) {
                        PlanarImage[] planarImageArray;
                        RenderedImage[] renderedImageArray = new RenderedImage[]{mosaic};
                        double[] dArray = RasterLayerResponse.this.backgroundValues;
                        if (this.hasAlpha || this.doInputTransparency) {
                            PlanarImage[] planarImageArray2 = new PlanarImage[1];
                            planarImageArray = planarImageArray2;
                            planarImageArray2[0] = in.alphaChannel;
                        } else {
                            PlanarImage[] planarImageArray3 = new PlanarImage[1];
                            planarImageArray = planarImageArray3;
                            planarImageArray3[0] = null;
                        }
                        mosaic = MergeBehavior.FLAT.process(renderedImageArray, dArray, this.sourceThreshold, planarImageArray, new ROI[]{in.roi}, RasterLayerResponse.this.request.isBlend() ? MosaicDescriptor.MOSAIC_TYPE_BLEND : MosaicDescriptor.MOSAIC_TYPE_OVERLAY, localHints);
                        roi = roi.add((ROI)new ROIGeometry((Geometry)JTS.toGeometry(new ReferencedEnvelope(RasterLayerResponse.this.rasterBounds, null))));
                        if (RasterLayerResponse.this.footprintBehavior != FootprintBehavior.None) {
                            RenderedOp rop = (RenderedOp)mosaic;
                            rop.setProperty("ROI", (Object)in.roi);
                        }
                    }
                    return new MosaicElement(in.alphaChannel, roi, mosaic, pamDataset);
                }
            }
            RenderedImage[] sources = new RenderedImage[size];
            PlanarImage[] alphas = new PlanarImage[size];
            ROI[] rois = new ROI[size];
            PAMDataset[] pams = new PAMDataset[size];
            int realROIs = 0;
            for (int i = 0; i < size; ++i) {
                MosaicElement mosaicElement = this.inputs.get(i);
                sources[i] = mosaicElement.source;
                alphas[i] = mosaicElement.alphaChannel;
                rois[i] = mosaicElement.roi;
                pams[i] = mosaicElement.pamDataset;
                if (mosaicElement.roi == null) continue;
                ++realROIs;
            }
            if (realROIs == 0) {
                rois = null;
            }
            RenderedImage mosaic = this.mergeBehavior.process(sources, RasterLayerResponse.this.backgroundValues, this.sourceThreshold, (PlanarImage[])(this.hasAlpha || this.doInputTransparency ? alphas : null), rois, RasterLayerResponse.this.request.isBlend() ? MosaicDescriptor.MOSAIC_TYPE_BLEND : MosaicDescriptor.MOSAIC_TYPE_OVERLAY, localHints);
            ROI overallROI = this.mosaicROIs(rois);
            if (RasterLayerResponse.this.footprintBehavior != FootprintBehavior.None) {
                RenderedOp rop = (RenderedOp)mosaic;
                rop.setProperty("ROI", (Object)overallROI);
            }
            RenderedImage postProcessed = RasterLayerResponse.this.footprintBehavior.postProcessMosaic(mosaic, overallROI, localHints);
            if (this.hasAlpha || this.doInputTransparency) {
                return new MosaicElement(new ImageWorker(postProcessed).retainLastBand().getPlanarImage(), overallROI, postProcessed, Utils.mergePamDatasets(pams));
            }
            return new MosaicElement(null, overallROI, postProcessed, Utils.mergePamDatasets(pams));
        }

        private ROI mosaicROIs(ROI[] inputROIArray) {
            if (inputROIArray == null || inputROIArray.length == 0) {
                return null;
            }
            ArrayList<ROI> rois = new ArrayList<ROI>();
            for (ROI roi : inputROIArray) {
                if (roi == null) continue;
                rois.add(roi);
            }
            int roiCount = rois.size();
            if (roiCount == 0) {
                return null;
            }
            if (roiCount == 1) {
                return (ROI)rois.get(0);
            }
            PlanarImage[] images = new PlanarImage[rois.size()];
            int i = 0;
            for (ROI roi : rois) {
                images[i++] = roi.getAsImage();
            }
            ROI[] roisArray = rois.toArray(new ROI[rois.size()]);
            RenderedOp overallROI = MosaicDescriptor.create((RenderedImage[])images, (MosaicType)MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, (ROI[])roisArray, (double[][])new double[][]{{1.0}}, (double[])new double[]{0.0}, (RenderingHints)RasterLayerResponse.this.hints);
            return new ROI((RenderedImage)overallROI);
        }
    }

    private class GranuleCollector {
        private int granulesNumber;
        private final Filter granuleFilter;
        private final boolean dryRun;
        private final List<Future<GranuleDescriptor.GranuleLoadingResult>> granulesFutures = new ArrayList<Future<GranuleDescriptor.GranuleLoadingResult>>();
        private double[][] sourceThreshold;
        private boolean hasAlpha;
        private boolean doInputTransparency;
        private int[] alphaIndex = new int[1];
        private Color inputTransparentColor;

        private GranuleCollector(Filter granuleFilter, boolean dryRun) {
            this.granuleFilter = granuleFilter;
            this.dryRun = dryRun;
            this.inputTransparentColor = RasterLayerResponse.this.request.getInputTransparentColor();
            this.doInputTransparency = this.inputTransparentColor != null && !RasterLayerResponse.this.footprintBehavior.handleFootprints();
        }

        private boolean accept(GranuleDescriptor granuleDescriptor) {
            Utilities.ensureNonNull((String)"granuleDescriptor", (Object)granuleDescriptor);
            if (this.granuleFilter.evaluate((Object)granuleDescriptor.originator)) {
                Object imageIndex = granuleDescriptor.originator.getAttribute("imageindex");
                if (imageIndex != null && imageIndex instanceof Integer) {
                    RasterLayerResponse.this.imageChoice = (Integer)imageIndex;
                }
                GranuleLoader loader = new GranuleLoader(RasterLayerResponse.this.baseReadParameters, RasterLayerResponse.this.imageChoice, RasterLayerResponse.this.mosaicBBox, RasterLayerResponse.this.finalWorldToGridCorner, granuleDescriptor, RasterLayerResponse.this.request, RasterLayerResponse.this.hints);
                if (!this.dryRun) {
                    if (RasterLayerResponse.this.multithreadingAllowed && ((RasterLayerResponse)RasterLayerResponse.this).rasterManager.parentReader.multiThreadedLoader != null) {
                        this.granulesFutures.add(((RasterLayerResponse)RasterLayerResponse.this).rasterManager.parentReader.multiThreadedLoader.submit(loader));
                    } else {
                        FutureTask<GranuleDescriptor.GranuleLoadingResult> task = new FutureTask<GranuleDescriptor.GranuleLoadingResult>(loader);
                        this.granulesFutures.add(task);
                        task.run();
                    }
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("We added the granule " + granuleDescriptor.toString());
                }
                ++this.granulesNumber;
                return true;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("We filtered out the granule " + granuleDescriptor.toString());
            }
            return false;
        }

        private MosaicInputs collectGranules() throws IOException {
            if (this.granulesNumber <= 0) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "granules number <= 0");
                }
                return null;
            }
            StringBuilder paths = new StringBuilder();
            ArrayList<MosaicElement> returnValues = new ArrayList<MosaicElement>();
            for (Future<GranuleDescriptor.GranuleLoadingResult> future : this.granulesFutures) {
                try {
                    GranuleDescriptor.GranuleLoadingResult result = future.get();
                    if (result == null) {
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        LOGGER.log(Level.FINE, "Unable to load the raster for granule with request " + RasterLayerResponse.this.request.toString());
                        continue;
                    }
                    RenderedImage loadedImage = result.getRaster();
                    if (loadedImage == null) {
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        LOGGER.log(Level.FINE, "Unable to load the raster for granuleDescriptor " + result.granuleUrl + " with request " + RasterLayerResponse.this.request.toString());
                        continue;
                    }
                    if (this.sourceThreshold == null) {
                        ColorModel cm = loadedImage.getColorModel();
                        this.hasAlpha = cm.hasAlpha();
                        if (this.hasAlpha) {
                            this.alphaIndex[0] = cm.getNumComponents() - 1;
                        }
                        this.sourceThreshold = new double[][]{{CoverageUtilities.getMosaicThreshold((int)loadedImage.getSampleModel().getDataType())}};
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Adding to mosaic granule " + result.granuleUrl);
                    }
                    File inputFile = DataUtilities.urlToFile(result.granuleUrl);
                    String canonicalPath = inputFile.getCanonicalPath();
                    paths.append(canonicalPath).append(",");
                    MosaicElement input = this.preProcessGranuleRaster(loadedImage, result, canonicalPath);
                    returnValues.add(input);
                }
                catch (Exception e) {
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.info("Adding to mosaic failed, original request was " + RasterLayerResponse.this.request);
                    }
                    throw new IOException(e);
                }
                RasterLayerResponse.this.granulesPaths = paths.length() > 1 ? paths.substring(0, paths.length() - 1) : "";
            }
            if ((returnValues == null || returnValues.isEmpty()) && LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("The MosaicElement list is null or empty");
            }
            return new MosaicInputs(this.doInputTransparency, this.hasAlpha, returnValues, this.sourceThreshold);
        }

        private MosaicElement preProcessGranuleRaster(RenderedImage granule, GranuleDescriptor.GranuleLoadingResult result, String canonicalPath) {
            if (((RasterLayerResponse)RasterLayerResponse.this).rasterManager.expandMe && granule.getColorModel() instanceof IndexColorModel) {
                granule = new ImageWorker(granule).forceComponentColorModel().getRenderedImage();
            }
            if (this.doInputTransparency) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Support for alpha on input granule " + result.granuleUrl);
                }
                granule = new ImageWorker(granule).makeColorTransparent(this.inputTransparentColor).getRenderedImage();
                this.hasAlpha = granule.getColorModel().hasAlpha();
                if (!granule.getColorModel().hasAlpha()) {
                    granule = new ImageWorker(granule).forceComponentColorModel(true).makeColorTransparent(this.inputTransparentColor).getRenderedImage();
                    this.hasAlpha = granule.getColorModel().hasAlpha();
                }
                assert (this.hasAlpha);
            }
            PlanarImage alphaChannel = null;
            if (this.hasAlpha || this.doInputTransparency) {
                ImageWorker w = new ImageWorker(granule);
                if (granule.getSampleModel() instanceof MultiPixelPackedSampleModel || granule.getColorModel() instanceof IndexColorModel) {
                    w.forceComponentColorModel();
                    granule = w.getRenderedImage();
                }
                this.alphaIndex[0] = granule.getColorModel().getNumComponents() - 1;
                assert (this.alphaIndex[0] < granule.getSampleModel().getNumBands());
                alphaChannel = w.retainBands(this.alphaIndex).getPlanarImage();
            }
            Rectangle bounds = PlanarImage.wrapRenderedImage((RenderedImage)granule).getBounds();
            Polygon mask = JTS.toGeometry(new Envelope(bounds.getMinX(), bounds.getMaxX(), bounds.getMinY(), bounds.getMaxY()));
            ROIGeometry imageROI = new ROIGeometry((Geometry)mask);
            if (RasterLayerResponse.this.footprintBehavior.handleFootprints()) {
                ROI footprint = result.getFootprint();
                if (footprint != null) {
                    imageROI = imageROI.contains(footprint.getBounds2D().getBounds()) ? footprint : imageROI.intersect(footprint);
                }
                if (RasterLayerResponse.this.defaultArtifactsFilterThreshold != Integer.MIN_VALUE && result.isDoFiltering()) {
                    int artifactThreshold = RasterLayerResponse.this.defaultArtifactsFilterThreshold;
                    if (RasterLayerResponse.this.artifactsFilterPTileThreshold != -1.0 && canonicalPath != null) {
                        String path = FilenameUtils.getFullPath((String)canonicalPath);
                        String baseName = FilenameUtils.getBaseName((String)canonicalPath);
                        String histogramPath = path + baseName + "." + "histogram";
                        Histogram histogram = Utils.getHistogram(histogramPath);
                        if (histogram != null) {
                            double[] p = histogram.getPTileThreshold(RasterLayerResponse.this.artifactsFilterPTileThreshold);
                            artifactThreshold = (int)p[0];
                        }
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Filtering granules artifacts");
                    }
                    granule = ArtifactsFilterDescriptor.create(granule, (ROI)imageROI, new double[]{0.0}, artifactThreshold, 3, (RenderingHints)RasterLayerResponse.this.hints);
                }
            }
            return new MosaicElement(alphaChannel, (ROI)imageROI, granule, result.getPamDataset());
        }
    }

    private class MosaicInputs {
        private final boolean doInputTransparency;
        private final boolean hasAlpha;
        private final List<MosaicElement> sources;
        private final double[][] sourceThreshold;

        private MosaicInputs(boolean doInputTransparency, boolean hasAlpha, List<MosaicElement> sources, double[][] sourceThreshold) {
            this.doInputTransparency = doInputTransparency;
            this.hasAlpha = hasAlpha;
            this.sources = sources;
            this.sourceThreshold = sourceThreshold;
        }
    }

    private class MosaicElement {
        PlanarImage alphaChannel;
        ROI roi;
        RenderedImage source;
        PAMDataset pamDataset;

        private MosaicElement(PlanarImage alphaChannel, ROI roi, RenderedImage source, PAMDataset pamDataset) {
            this.alphaChannel = alphaChannel;
            this.roi = roi;
            this.source = source;
            this.pamDataset = pamDataset;
        }
    }

    private static final class SimplifiedGridSampleDimension
    extends GridSampleDimension
    implements SampleDimension {
        private static final long serialVersionUID = 2227219522016820587L;
        private double nodata;
        private double minimum;
        private double maximum;
        private double scale;
        private double offset;
        private Unit<?> unit;
        private SampleDimensionType type;
        private ColorInterpretation color;
        private Category bkg;

        public SimplifiedGridSampleDimension(CharSequence description, SampleDimensionType type, ColorInterpretation color, double nodata, double minimum, double maximum, double scale, double offset, Unit<?> unit) {
            Category[] categoryArray;
            if (!Double.isNaN(nodata)) {
                Category[] categoryArray2 = new Category[1];
                categoryArray = categoryArray2;
                categoryArray2[0] = new Category((CharSequence)Vocabulary.formatInternational((int)147), new Color[]{new Color(0, 0, 0, 0)}, NumberRange.create((double)nodata, (double)nodata), NumberRange.create((double)nodata, (double)nodata));
            } else {
                categoryArray = null;
            }
            super(description, categoryArray, unit);
            this.nodata = nodata;
            this.minimum = minimum;
            this.maximum = maximum;
            this.scale = scale;
            this.offset = offset;
            this.unit = unit;
            this.type = type;
            this.color = color;
            this.bkg = new Category((CharSequence)"Background", Utils.TRANSPARENT, 0);
        }

        public double getMaximumValue() {
            return this.maximum;
        }

        public double getMinimumValue() {
            return this.minimum;
        }

        public double[] getNoDataValues() throws IllegalStateException {
            return new double[]{this.nodata};
        }

        public double getOffset() throws IllegalStateException {
            return this.offset;
        }

        public NumberRange<? extends Number> getRange() {
            return super.getRange();
        }

        public SampleDimensionType getSampleDimensionType() {
            return this.type;
        }

        public MathTransform1D getSampleToGeophysics() {
            return super.getSampleToGeophysics();
        }

        public Unit<?> getUnits() {
            return this.unit;
        }

        public double getScale() {
            return this.scale;
        }

        public ColorInterpretation getColorInterpretation() {
            return this.color;
        }

        public Category getBackground() {
            return this.bkg;
        }

        public InternationalString[] getCategoryNames() throws IllegalStateException {
            return new InternationalString[]{SimpleInternationalString.wrap((CharSequence)"Background")};
        }
    }

    class MosaicOutput {
        RenderedImage image;
        PAMDataset pamDataset;

        public MosaicOutput(MosaicElement element) {
            this.image = element.source;
            this.pamDataset = element.pamDataset;
        }

        public MosaicOutput(RenderedImage image, PAMDataset pamDataset) {
            this.image = image;
            this.pamDataset = pamDataset;
        }

        public RenderedImage getImage() {
            return this.image;
        }

        public void setImage(RenderedImage image) {
            this.image = image;
        }

        public PAMDataset getPamDataset() {
            return this.pamDataset;
        }

        public void setPamDataset(PAMDataset pamDataset) {
            this.pamDataset = pamDataset;
        }
    }
}

