/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageReaderSpi;
import javax.media.jai.ImageLayout;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.DefaultHarvestedSource;
import org.geotools.coverage.grid.io.DimensionDescriptor;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.coverage.grid.io.HarvestedSource;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.factory.Hints;
import org.geotools.gce.imagemosaic.CatalogManager;
import org.geotools.gce.imagemosaic.ImageMosaicConfigHandler;
import org.geotools.gce.imagemosaic.ImageMosaicDescriptor;
import org.geotools.gce.imagemosaic.ImageMosaicDirectoryWalker;
import org.geotools.gce.imagemosaic.ImageMosaicEventHandlers;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.ImageMosaicWalker;
import org.geotools.gce.imagemosaic.MosaicConfigurationBean;
import org.geotools.gce.imagemosaic.OverviewsController;
import org.geotools.gce.imagemosaic.PathType;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.CatalogConfigurationBean;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalogFactory;
import org.geotools.gce.imagemosaic.catalog.MultiLevelROIProvider;
import org.geotools.gce.imagemosaic.catalog.MultiLevelROIProviderFactory;
import org.geotools.gce.imagemosaic.catalogbuilder.CatalogBuilderConfiguration;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;

public class ImageMosaicReader
extends AbstractGridCoverage2DReader
implements StructuredGridCoverage2DReader {
    Set<String> names = new HashSet<String>();
    String defaultName = null;
    public static final String UNSPECIFIED = "_UN$PECIFIED_";
    Map<String, RasterManager> rasterManagers = new ConcurrentHashMap<String, RasterManager>();
    private static final Logger LOGGER = Logging.getLogger(ImageMosaicReader.class);
    URL sourceURL;
    File parentDirectory;
    boolean expandMe;
    PathType pathType;
    ExecutorService multiThreadedLoader;
    String locationAttributeName = "location";
    int maxAllowedTiles = (Integer)ImageMosaicFormat.MAX_ALLOWED_TILES.getDefaultValue();
    ImageReaderSpi suggestedSPI;
    GranuleCatalog granuleCatalog;
    boolean cachingIndex;
    boolean imposedBBox;
    boolean heterogeneousGranules;
    boolean checkAuxiliaryMetadata = false;
    String typeName;

    public RasterManager getRasterManager(String name) {
        if (name != null && this.rasterManagers.containsKey(name)) {
            return this.rasterManagers.get(name);
        }
        return null;
    }

    public String[] getGridCoverageNames() {
        return this.names.toArray(new String[0]);
    }

    public ImageMosaicReader(Object source, Hints uHints) throws IOException {
        super(source, uHints);
        Object executor;
        if (this.hints.containsKey((Object)Hints.EXECUTOR_SERVICE) && (executor = uHints.get((Object)Hints.EXECUTOR_SERVICE)) != null && executor instanceof ExecutorService) {
            this.multiThreadedLoader = (ExecutorService)executor;
            if (LOGGER.isLoggable(Level.FINE) && this.multiThreadedLoader instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor tpe = (ThreadPoolExecutor)this.multiThreadedLoader;
                LOGGER.fine("Using ThreadPoolExecutor with the following settings: core pool size = " + tpe.getCorePoolSize() + "\nmax pool size = " + tpe.getMaximumPoolSize() + "\nkeep alive time " + tpe.getKeepAliveTime(TimeUnit.MILLISECONDS));
            }
        }
        if (this.hints.containsKey((Object)Hints.MAX_ALLOWED_TILES)) {
            this.maxAllowedTiles = (Integer)this.hints.get((Object)Hints.MAX_ALLOWED_TILES);
        }
        if (source instanceof ImageMosaicDescriptor) {
            this.initReaderFromDescriptor((ImageMosaicDescriptor)source, uHints);
        } else {
            try {
                Hints localHints = new Hints((RenderingHints)uHints);
                if (localHints != null) {
                    localHints.add((RenderingHints)new Hints((RenderingHints.Key)Utils.MOSAIC_READER, (Object)this));
                }
                this.initReaderFromURL(source, localHints);
            }
            catch (Exception e) {
                throw new DataSourceException(e);
            }
        }
    }

    private void initReaderFromDescriptor(ImageMosaicDescriptor source, Hints uHints) throws IOException {
        Utilities.ensureNonNull((String)"source", (Object)source);
        MosaicConfigurationBean configuration = source.getConfiguration();
        if (configuration == null) {
            throw new DataSourceException("Unable to create reader for this mosaic since we could not parse the configuration.");
        }
        this.extractProperties(configuration);
        GranuleCatalog catalog = source.getCatalog();
        if (catalog == null) {
            throw new DataSourceException("Unable to create reader for this mosaic since the inner catalog is null.");
        }
        SimpleFeatureType schema = catalog.getType(configuration.getCatalogConfigurationBean().getTypeName());
        if (schema == null) {
            throw new DataSourceException("Unable to create reader for this mosaic since the inner catalog schema is null.");
        }
        this.granuleCatalog = catalog;
        this.setGridGeometry(this.typeName);
        this.addRasterManager(configuration, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initReaderFromURL(Object source, Hints hints) throws Exception {
        this.sourceURL = Utils.checkSource(source, hints);
        if (this.sourceURL == null) {
            throw new DataSourceException("This plugin accepts File, URL or String. The string may describe a File or an URL");
        }
        MosaicConfigurationBean configuration = null;
        try {
            File parent;
            File sourceFile;
            if (this.sourceURL.getProtocol().equals("file") && !(sourceFile = DataUtilities.urlToFile(this.sourceURL)).exists()) {
                throw new DataSourceException("The specified sourceURL doesn't refer to an existing file");
            }
            if (this.sourceURL != null) {
                this.parentDirectory = DataUtilities.urlToFile(this.sourceURL);
                if (!this.parentDirectory.isDirectory()) {
                    this.parentDirectory = this.parentDirectory.getParentFile();
                }
            }
            if ((configuration = Utils.loadMosaicProperties(this.sourceURL, this.locationAttributeName)) == null) {
                parent = DataUtilities.urlToFile(this.sourceURL).getParentFile();
                File[] properties = parent.listFiles((FilenameFilter)FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"indexer.properties")), FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"datastore.properties")), FileFilterUtils.makeFileOnly((IOFileFilter)FileFilterUtils.suffixFileFilter((String)".properties"))})}));
                File datastoreProperties = new File(parent, "datastore.properties");
                ArrayList<MosaicConfigurationBean> beans = new ArrayList<MosaicConfigurationBean>();
                for (File propFile : properties) {
                    if (!Utils.checkFileReadable(propFile) || Utils.loadMosaicProperties(DataUtilities.fileToURL(propFile), "") == null || (configuration = Utils.loadMosaicProperties(DataUtilities.fileToURL(propFile), this.locationAttributeName)) == null) continue;
                    beans.add(configuration);
                }
                if (beans.isEmpty() && !datastoreProperties.exists()) {
                    throw new DataSourceException("No mosaic properties file or datastore properties file have been found");
                }
                GranuleCatalog catalog = null;
                Properties params = CatalogManager.createGranuleCatalogProperties(datastoreProperties);
                Object typeNames = params.get("TypeNames");
                if (typeNames != null) {
                    params.put("TypeNames", Boolean.valueOf(typeNames.toString()));
                } else {
                    params.put("TypeNames", Boolean.TRUE);
                }
                catalog = beans.size() > 0 ? GranuleCatalogFactory.createGranuleCatalog(this.sourceURL, ((MosaicConfigurationBean)beans.get(0)).getCatalogConfigurationBean(), params, this.getHints()) : CatalogManager.createGranuleCatalogFromDatastore(parent, datastoreProperties, true, this.getHints());
                MultiLevelROIProvider rois = MultiLevelROIProviderFactory.createFootprintProvider(parent);
                catalog.setMultiScaleROIProvider(rois);
                if (this.granuleCatalog != null) {
                    this.granuleCatalog.dispose();
                }
                this.granuleCatalog = catalog;
                if (this.granuleCatalog == null) {
                    throw new DataSourceException("Unable to create index for this URL " + this.sourceURL);
                }
                for (MosaicConfigurationBean bean : beans) {
                    this.addRasterManager(bean, true);
                }
            } else {
                this.granuleCatalog = CatalogManager.createCatalog(this.sourceURL, configuration, this.hints);
                parent = DataUtilities.urlToFile(this.sourceURL).getParentFile();
                MultiLevelROIProvider rois = MultiLevelROIProviderFactory.createFootprintProvider(parent);
                this.granuleCatalog.setMultiScaleROIProvider(rois);
                this.addRasterManager(configuration, true);
            }
        }
        catch (Throwable e) {
            try {
                if (this.granuleCatalog != null) {
                    this.granuleCatalog.dispose();
                }
            }
            catch (Throwable e1) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, e1.getLocalizedMessage(), e1);
                }
            }
            finally {
                this.granuleCatalog = null;
            }
            try {
                this.disposeManagers();
            }
            catch (Throwable e1) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, e1.getLocalizedMessage(), e1);
                }
            }
            finally {
                this.rasterManagers = null;
            }
            throw new DataSourceException(e);
        }
    }

    private void setGridGeometry(ReferencedEnvelope envelope, GranuleCatalog catalog, String typeName) {
        Utilities.ensureNonNull((String)"index", (Object)catalog);
        BoundingBox bounds = catalog.getBounds(typeName);
        if (bounds.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a mosaic out of an empty index");
        }
        this.crs = bounds.getCoordinateReferenceSystem();
        if (envelope == null) {
            this.originalEnvelope = new GeneralEnvelope((Envelope)bounds);
        } else {
            this.originalEnvelope = new GeneralEnvelope((Envelope)envelope);
            this.originalEnvelope.setCoordinateReferenceSystem(this.crs);
        }
        this.originalGridRange = new GridEnvelope2D(new Rectangle((int)(this.originalEnvelope.getSpan(0) / this.highestRes[0]), (int)(this.originalEnvelope.getSpan(1) / this.highestRes[1])));
        this.raster2Model = new AffineTransform2D(this.highestRes[0], 0.0, 0.0, -this.highestRes[1], this.originalEnvelope.getLowerCorner().getOrdinate(0) + 0.5 * this.highestRes[0], this.originalEnvelope.getUpperCorner().getOrdinate(1) - 0.5 * this.highestRes[1]);
    }

    private void setGridGeometry(String typeName) {
        this.setGridGeometry(null, this.granuleCatalog, typeName);
    }

    private void extractProperties(MosaicConfigurationBean configuration) throws IOException {
        this.numOverviews = configuration.getLevelsNum() - 1;
        double[][] resolutions = configuration.getLevels();
        this.overViewResolutions = this.numOverviews >= 1 ? new double[this.numOverviews][2] : (double[][])null;
        this.highestRes = new double[2];
        this.highestRes[0] = resolutions[0][0];
        this.highestRes[1] = resolutions[0][1];
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Highest res " + this.highestRes[0] + " " + this.highestRes[1]);
        }
        if (this.numOverviews > 0) {
            for (int i = 0; i < this.numOverviews; ++i) {
                this.overViewResolutions[i][0] = resolutions[i + 1][0];
                this.overViewResolutions[i][1] = resolutions[i + 1][1];
            }
        }
        this.coverageName = configuration.getName();
        this.expandMe = configuration.isExpandToRGB();
        this.checkAuxiliaryMetadata = configuration.isCheckAuxiliaryMetadata();
        CatalogConfigurationBean catalogConfigurationBean = configuration.getCatalogConfigurationBean();
        this.heterogeneousGranules = catalogConfigurationBean.isHeterogeneous();
        this.pathType = catalogConfigurationBean.isAbsolutePath() ? PathType.ABSOLUTE : PathType.RELATIVE;
        this.locationAttributeName = catalogConfigurationBean.getLocationAttribute();
        String suggestedSPIClass = catalogConfigurationBean.getSuggestedSPI();
        if (suggestedSPIClass != null) {
            try {
                Class<?> clazz = Class.forName(suggestedSPIClass);
                this.suggestedSPI = clazz.newInstance() instanceof ImageReaderSpi ? (ImageReaderSpi)clazz.newInstance() : null;
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
                this.suggestedSPI = null;
            }
        }
        this.cachingIndex = catalogConfigurationBean.isCaching();
        this.imposedBBox = configuration.getEnvelope() != null;
        this.typeName = catalogConfigurationBean.getTypeName();
    }

    public ImageMosaicReader(Object source) throws IOException {
        this(source, null);
    }

    public Format getFormat() {
        return new ImageMosaicFormat();
    }

    public GridCoverage2D read(GeneralParameterValue[] params) throws IOException {
        return this.read(UNSPECIFIED, params);
    }

    public GridCoverage2D read(String coverageName, GeneralParameterValue[] params) throws IOException {
        Collection<GridCoverage2D> response;
        if (this.rasterManagers == null) {
            throw new IOException("Looks like this reader has been already disposed or it has not been properly initialized.");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            if (this.sourceURL != null) {
                LOGGER.fine("Reading mosaic from " + this.sourceURL.toString());
            } else {
                LOGGER.fine("Reading mosaic");
            }
            double[][] levels = this.getResolutionLevels(coverageName);
            if (levels != null) {
                double[] highRes = levels[0];
                LOGGER.fine("Highest res " + highRes[0] + " " + highRes[1]);
            }
        }
        if (this.maxAllowedTiles != (Integer)ImageMosaicFormat.MAX_ALLOWED_TILES.getDefaultValue()) {
            if (params != null) {
                boolean found = false;
                for (GeneralParameterValue pv : params) {
                    if (!pv.getDescriptor().getName().equals(ImageMosaicFormat.MAX_ALLOWED_TILES.getName())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    GeneralParameterValue[] temp = new GeneralParameterValue[params.length + 1];
                    System.arraycopy(params, 0, temp, 0, params.length);
                    ParameterValue tempVal = ImageMosaicFormat.MAX_ALLOWED_TILES.createValue();
                    tempVal.setValue(this.maxAllowedTiles);
                    temp[params.length] = tempVal;
                }
            } else {
                ParameterValue tempVal = ImageMosaicFormat.MAX_ALLOWED_TILES.createValue();
                tempVal.setValue(this.maxAllowedTiles);
                params = new GeneralParameterValue[]{tempVal};
            }
        }
        if ((response = this.read(params, coverageName)).isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("The response is empty. ==> returning a null GridCoverage");
            }
            return null;
        }
        return response.iterator().next();
    }

    private Collection<GridCoverage2D> read(GeneralParameterValue[] params, String coverageName) throws IOException {
        coverageName = this.checkUnspecifiedCoverage(coverageName);
        return this.getRasterManager(coverageName).read(params);
    }

    Hints getHints() {
        return this.hints;
    }

    double[] getHighestRes() {
        return this.highestRes;
    }

    double[][] getOverviewsResolution() {
        return this.overViewResolutions;
    }

    int getNumberOfOvervies() {
        return this.numOverviews;
    }

    MathTransform getRaster2Model() {
        return this.raster2Model;
    }

    GridCoverageFactory getGridCoverageFactory() {
        return this.coverageFactory;
    }

    public int getGridCoverageCount() {
        return this.names.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose() {
        super.dispose();
        ImageMosaicReader imageMosaicReader = this;
        synchronized (imageMosaicReader) {
            block6: {
                try {
                    if (this.granuleCatalog != null) {
                        this.granuleCatalog.dispose();
                    }
                    this.disposeManagers();
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block6;
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
            }
        }
    }

    private void disposeManagers() {
        if (this.rasterManagers != null) {
            Set<String> keys = this.rasterManagers.keySet();
            for (String key : keys) {
                this.rasterManagers.get(key).dispose();
            }
            this.rasterManagers.clear();
            this.rasterManagers = null;
        }
    }

    public String[] getMetadataNames() {
        return this.getMetadataNames(UNSPECIFIED);
    }

    public String[] getMetadataNames(String coverageName) {
        String name = this.checkUnspecifiedCoverage(coverageName);
        RasterManager manager = this.getRasterManager(name);
        return manager != null ? manager.getMetadataNames() : null;
    }

    public String getMetadataValue(String name) {
        return this.getMetadataValue(UNSPECIFIED, name);
    }

    public String getMetadataValue(String coverageName, String name) {
        coverageName = this.checkUnspecifiedCoverage(coverageName);
        RasterManager manager = this.getRasterManager(coverageName);
        return manager.getMetadataValue(name);
    }

    public Set<ParameterDescriptor<List>> getDynamicParameters() {
        return this.getDynamicParameters(UNSPECIFIED);
    }

    public Set<ParameterDescriptor<List>> getDynamicParameters(String coverageName) {
        coverageName = this.checkUnspecifiedCoverage(coverageName);
        RasterManager manager = this.getRasterManager(coverageName);
        return manager.domainsManager != null ? manager.domainsManager.getDynamicParameters() : Collections.emptySet();
    }

    public boolean isParameterSupported(Identifier name) {
        return this.isParameterSupported(UNSPECIFIED, name);
    }

    public int getNumOverviews(String coverageName) {
        coverageName = this.checkUnspecifiedCoverage(coverageName);
        RasterManager manager = this.getRasterManager(coverageName);
        return manager.overviewsController.getNumberOfOverviews();
    }

    public int getNumOverviews() {
        return this.getNumOverviews(UNSPECIFIED);
    }

    public double[] getReadingResolutions(OverviewPolicy policy, double[] requestedResolution) {
        return this.getReadingResolutions(UNSPECIFIED, policy, requestedResolution);
    }

    public double[] getReadingResolutions(String coverageName, OverviewPolicy policy, double[] requestedResolution) {
        coverageName = this.checkUnspecifiedCoverage(coverageName);
        RasterManager manager = this.getRasterManager(coverageName);
        int numOverviews = this.getNumOverviews(coverageName);
        OverviewsController overviewsController = manager.overviewsController;
        OverviewsController.OverviewLevel level = null;
        if (numOverviews > 0) {
            int imageIdx = overviewsController.pickOverviewLevel(policy, requestedResolution);
            level = overviewsController.getLevel(imageIdx);
        } else {
            level = overviewsController.getLevel(0);
        }
        return new double[]{level.resolutionX, level.resolutionY};
    }

    public boolean isParameterSupported(String coverageName, Identifier parameterName) {
        coverageName = this.checkUnspecifiedCoverage(coverageName);
        RasterManager manager = this.getRasterManager(coverageName);
        return manager.domainsManager != null ? manager.domainsManager.isParameterSupported(parameterName) : false;
    }

    private String checkUnspecifiedCoverage(String coverageName) {
        if (coverageName.equalsIgnoreCase(UNSPECIFIED)) {
            if (this.getGridCoverageCount() > 1) {
                throw new IllegalArgumentException("Need to specify the coverageName for a reader related to multiple coverages");
            }
            return this.defaultName;
        }
        if (!this.names.contains(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName is unavailable");
        }
        return coverageName;
    }

    protected RasterManager addRasterManager(MosaicConfigurationBean configuration, boolean init) throws IOException {
        Utilities.ensureNonNull((String)"MosaicConfigurationBean", (Object)configuration);
        String name = configuration.getName();
        RasterManager rasterManager = new RasterManager(this, configuration);
        this.rasterManagers.put(name, rasterManager);
        this.names.add(name);
        if (this.defaultName == null) {
            this.defaultName = name;
        }
        if (init) {
            rasterManager.initialize(false);
        }
        return rasterManager;
    }

    public GranuleSource getGranules(String coverageName, boolean readOnly) throws IOException, UnsupportedOperationException {
        RasterManager manager;
        if (coverageName == null) {
            coverageName = this.defaultName;
        }
        if ((manager = this.getRasterManager(coverageName)) != null) {
            return manager.getGranuleSource(readOnly, this.getHints());
        }
        return null;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void createCoverage(String coverageName, SimpleFeatureType indexSchema) throws IOException, UnsupportedOperationException {
        RasterManager manager = this.getRasterManager(coverageName);
        if (manager == null) {
            throw new IOException("This implementation requires to create a RasterManager for a coverage before creating the store. " + coverageName);
        }
        manager.createStore(indexSchema);
    }

    public boolean removeCoverage(String coverageName, boolean delete) throws IOException {
        return this.removeCoverage(coverageName, delete, true);
    }

    private boolean removeCoverage(String coverageName, boolean forceDelete, boolean checkForReferences) throws IOException {
        RasterManager manager = this.getRasterManager(coverageName);
        if (manager != null) {
            manager.removeStore(coverageName, forceDelete, checkForReferences);
            this.rasterManagers.remove(coverageName);
            this.names.remove(coverageName);
            if (this.defaultName == coverageName) {
                Iterator<String> iterator = this.names.iterator();
                this.defaultName = iterator.hasNext() ? iterator.next() : null;
            }
            return true;
        }
        throw new IOException("No Raster manager have been found for the specified coverageName. " + coverageName);
    }

    public GeneralEnvelope getOriginalEnvelope() {
        return this.getOriginalEnvelope(UNSPECIFIED);
    }

    public GeneralEnvelope getOriginalEnvelope(String coverageName) {
        String name = this.checkUnspecifiedCoverage(coverageName);
        RasterManager manager = this.getRasterManager(name);
        return manager.spatialDomainManager.coverageEnvelope;
    }

    public GridEnvelope getOriginalGridRange() {
        return this.getOriginalGridRange(UNSPECIFIED);
    }

    public GridEnvelope getOriginalGridRange(String coverageName) {
        String name = this.checkUnspecifiedCoverage(coverageName);
        RasterManager manager = this.getRasterManager(name);
        return manager.spatialDomainManager.gridEnvelope;
    }

    public MathTransform getOriginalGridToWorld(PixelInCell pixInCell) {
        return this.getOriginalGridToWorld(UNSPECIFIED, pixInCell);
    }

    public MathTransform getOriginalGridToWorld(String coverageName, PixelInCell pixInCell) {
        String name = this.checkUnspecifiedCoverage(coverageName);
        RasterManager manager = this.getRasterManager(name);
        return manager.spatialDomainManager.getOriginalGridToWorld(pixInCell);
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.getCoordinateReferenceSystem(UNSPECIFIED);
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem(String coverageName) {
        String name = this.checkUnspecifiedCoverage(coverageName);
        RasterManager manager = this.getRasterManager(name);
        return manager.spatialDomainManager.coverageCRS;
    }

    public ImageLayout getImageLayout() throws IOException {
        return this.getImageLayout(UNSPECIFIED);
    }

    public ImageLayout getImageLayout(String coverageName) throws IOException {
        String name = this.checkUnspecifiedCoverage(coverageName);
        RasterManager manager = this.getRasterManager(name);
        return manager.defaultImageLayout;
    }

    public double[][] getResolutionLevels() throws IOException {
        return this.getResolutionLevels(UNSPECIFIED);
    }

    public double[][] getResolutionLevels(String coverageName) throws IOException {
        String name = this.checkUnspecifiedCoverage(coverageName);
        RasterManager manager = this.getRasterManager(name);
        return manager.levels;
    }

    public List<HarvestedSource> harvest(String defaultCoverage, Object source, Hints hints) throws IOException, UnsupportedOperationException {
        HarvestedResource resource = HarvestedResource.getResourceFromObject(source);
        ArrayList<HarvestedSource> result = new ArrayList<HarvestedSource>();
        if (resource == null) {
            result.add((HarvestedSource)new DefaultHarvestedSource(source, false, "Unrecognized source type"));
            return result;
        }
        if (source instanceof File && !((File)source).exists() || this.singleFileList(source)) {
            result.add((HarvestedSource)new DefaultHarvestedSource(source, false, "Specified file path does not exist"));
            return result;
        }
        resource.harvest(defaultCoverage, source, hints, result, this);
        String coverage = defaultCoverage != null ? defaultCoverage : this.defaultName;
        RasterManager rasterManager = this.rasterManagers.get(coverage);
        rasterManager.initialize(true);
        return result;
    }

    private boolean singleFileList(Object source) {
        File file;
        Collection collection;
        return source instanceof Collection && (collection = (Collection)source).size() == 1 && !(file = (File)collection.iterator().next()).exists();
    }

    public List<DimensionDescriptor> getDimensionDescriptors(String coverageName) throws IOException {
        RasterManager manager = this.getRasterManager(coverageName);
        return manager.getDimensionDescriptors();
    }

    public void delete(boolean deleteData) throws IOException {
        String[] coverageNames;
        for (String coverageName : coverageNames = this.getGridCoverageNames()) {
            this.removeCoverage(coverageName, deleteData, true);
        }
        this.dispose();
        this.removeDB();
        if (deleteData) {
            File[] list;
            for (File file : list = this.parentDirectory.listFiles()) {
                FileUtils.deleteQuietly((File)file);
            }
        } else {
            this.finalizeCleanup();
        }
    }

    private void removeDB() throws IOException {
        File parent = DataUtilities.urlToFile(this.sourceURL).getParentFile();
        File datastoreProperties = new File(parent, "datastore.properties");
        if (datastoreProperties != null && datastoreProperties.exists() && datastoreProperties.canRead()) {
            CatalogManager.dropDatastore(datastoreProperties);
        }
        ArrayList beans = new ArrayList();
    }

    private void finalizeCleanup() {
        IOFileFilter filesFilter = Utils.getCleanupFilter();
        Collection files = FileUtils.listFiles((File)this.parentDirectory, (IOFileFilter)filesFilter, null);
        for (File file : files) {
            FileUtils.deleteQuietly((File)file);
        }
    }

    public boolean removeCoverage(String coverageName) throws IOException, UnsupportedOperationException {
        return this.removeCoverage(coverageName, false);
    }

    private static class ImageMosaicFileCollectionWalker
    extends ImageMosaicWalker {
        private Collection<File> files;

        public ImageMosaicFileCollectionWalker(ImageMosaicConfigHandler configHandler, ImageMosaicEventHandlers eventHandler, Collection<File> files) {
            super(configHandler, eventHandler);
            this.files = files;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block28: {
                String message;
                block27: {
                    this.configHandler.indexingPreamble();
                    this.startTransaction();
                    this.setNumFiles(this.files.size());
                    for (File file : this.files) {
                        if (this.getStop()) break;
                        if (this.checkFile(file)) {
                            this.handleFile(file);
                            continue;
                        }
                        this.skipFile(file.getAbsolutePath());
                    }
                    if (this.getStop()) {
                        this.rollbackTransaction();
                        break block27;
                    }
                    this.commitTransaction();
                }
                try {
                    this.closeTransaction();
                }
                catch (Exception e) {
                    message = "Unable to close transaction" + e.getLocalizedMessage();
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, message, e);
                    }
                    this.eventHandler.fireException(e);
                }
                try {
                    this.configHandler.indexingPostamble(!this.getStop());
                }
                catch (Exception e) {
                    message = "Unable to close indexing" + e.getLocalizedMessage();
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, message, e);
                    }
                    this.eventHandler.fireException(e);
                }
                break block28;
                catch (IOException e) {
                    String message2;
                    try {
                        LOGGER.log(Level.WARNING, e.getMessage(), e);
                        try {
                            this.rollbackTransaction();
                        }
                        catch (IOException e1) {
                            throw new IllegalStateException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        String message3;
                        try {
                            this.closeTransaction();
                        }
                        catch (Exception e2) {
                            message3 = "Unable to close transaction" + e2.getLocalizedMessage();
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.log(Level.WARNING, message3, e2);
                            }
                            this.eventHandler.fireException(e2);
                        }
                        try {
                            this.configHandler.indexingPostamble(!this.getStop());
                        }
                        catch (Exception e3) {
                            message3 = "Unable to close indexing" + e3.getLocalizedMessage();
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.log(Level.WARNING, message3, e3);
                            }
                            this.eventHandler.fireException(e3);
                        }
                        throw throwable;
                    }
                    try {
                        this.closeTransaction();
                    }
                    catch (Exception e4) {
                        message2 = "Unable to close transaction" + e4.getLocalizedMessage();
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.log(Level.WARNING, message2, e4);
                        }
                        this.eventHandler.fireException(e4);
                    }
                    try {
                        this.configHandler.indexingPostamble(!this.getStop());
                    }
                    catch (Exception e5) {
                        message2 = "Unable to close indexing" + e5.getLocalizedMessage();
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.log(Level.WARNING, message2, e5);
                        }
                        this.eventHandler.fireException(e5);
                    }
                }
            }
        }
    }

    public static enum HarvestedResource {
        FILE{

            @Override
            public void harvest(String defaultCoverage, Object source, Hints hints, List<HarvestedSource> result, ImageMosaicReader reader) {
                File file = source instanceof Collection ? (File)((Collection)source).iterator().next() : (File)source;
                File directory = file.getParentFile();
                IOFileFilter filter = FileFilterUtils.nameFileFilter((String)file.getName());
                HarvestedResource.harvestCalculation(defaultCoverage, result, reader, directory, filter);
            }
        }
        ,
        DIRECTORY{

            @Override
            public void harvest(String defaultCoverage, Object source, Hints hints, List<HarvestedSource> result, ImageMosaicReader reader) {
                File directory = source instanceof Collection ? (File)((Collection)source).iterator().next() : (File)source;
                HarvestedResource.harvestCalculation(defaultCoverage, result, reader, directory, null);
            }
        }
        ,
        FILE_COLLECTION{

            @Override
            public void harvest(String defaultCoverage, Object source, Hints hints, final List<HarvestedSource> result, final ImageMosaicReader reader) {
                Collection files = (Collection)source;
                CatalogBuilderConfiguration configuration = new CatalogBuilderConfiguration();
                configuration.setParameter("AbsolutePath", Boolean.toString(true));
                Iterator it = files.iterator();
                String indexingPath = ((File)it.next()).getAbsolutePath();
                configuration.setParameter("HarvestingDirectory", indexingPath);
                if (defaultCoverage == null) {
                    String[] coverageNames = reader.getGridCoverageNames();
                    defaultCoverage = coverageNames != null && coverageNames.length > 0 ? coverageNames[0] : "index";
                }
                configuration.setParameter("Name", defaultCoverage);
                configuration.setHints(new Hints((RenderingHints.Key)Utils.MOSAIC_READER, (Object)reader));
                File mosaicSource = DataUtilities.urlToFile(reader.sourceURL);
                if (!mosaicSource.isDirectory()) {
                    mosaicSource = mosaicSource.getParentFile();
                }
                configuration.setParameter("RootMosaicDirectory", mosaicSource.getAbsolutePath());
                ImageMosaicEventHandlers eventHandler = new ImageMosaicEventHandlers();
                ImageMosaicConfigHandler catalogHandler = new ImageMosaicConfigHandler(configuration, eventHandler){

                    @Override
                    protected GranuleCatalog buildCatalog() throws IOException {
                        return reader.granuleCatalog;
                    }
                };
                ImageMosaicFileCollectionWalker walker = new ImageMosaicFileCollectionWalker(catalogHandler, eventHandler, files);
                eventHandler.addProcessingEventListener(new ImageMosaicEventHandlers.ProcessingEventListener(){

                    @Override
                    public void getNotification(ImageMosaicEventHandlers.ProcessingEvent event) {
                        if (event instanceof ImageMosaicEventHandlers.FileProcessingEvent) {
                            ImageMosaicEventHandlers.FileProcessingEvent fileEvent = (ImageMosaicEventHandlers.FileProcessingEvent)event;
                            result.add(new DefaultHarvestedSource((Object)fileEvent.getFile(), fileEvent.isIngested(), fileEvent.getMessage()));
                        }
                    }

                    @Override
                    public void exceptionOccurred(ImageMosaicEventHandlers.ExceptionEvent event) {
                    }
                });
                walker.run();
            }
        };


        public abstract void harvest(String var1, Object var2, Hints var3, List<HarvestedSource> var4, ImageMosaicReader var5);

        public static HarvestedResource getResourceFromObject(Object source) {
            if (source instanceof File) {
                return HarvestedResource.getResourceFromFile((File)source);
            }
            if (source instanceof String) {
                File file = new File((String)source);
                return HarvestedResource.getResourceFromFile(file);
            }
            if (source instanceof Collection) {
                Collection files;
                block8: {
                    files = null;
                    try {
                        files = (Collection)source;
                    }
                    catch (ClassCastException e) {
                        if (!LOGGER.isLoggable(Level.WARNING)) break block8;
                        LOGGER.log(Level.WARNING, e.getMessage(), e);
                    }
                }
                if (files != null) {
                    int fileSize = files.size();
                    if (fileSize < 1) {
                        return null;
                    }
                    if (fileSize == 1) {
                        return HarvestedResource.getResourceFromFile((File)files.iterator().next());
                    }
                    return FILE_COLLECTION;
                }
            }
            return null;
        }

        private static HarvestedResource getResourceFromFile(File file) {
            if (file != null) {
                if (file.isDirectory()) {
                    return DIRECTORY;
                }
                return FILE;
            }
            return null;
        }

        private static void harvestCalculation(String defaultCoverage, final List<HarvestedSource> result, final ImageMosaicReader reader, File directory, IOFileFilter filter) {
            CatalogBuilderConfiguration configuration = new CatalogBuilderConfiguration();
            configuration.setParameter("AbsolutePath", Boolean.toString(false));
            String indexingPath = directory.getAbsolutePath();
            configuration.setParameter("HarvestingDirectory", indexingPath);
            if (defaultCoverage == null) {
                String[] coverageNames = reader.getGridCoverageNames();
                defaultCoverage = coverageNames != null && coverageNames.length > 0 ? coverageNames[0] : "index";
            }
            configuration.setParameter("Name", defaultCoverage);
            configuration.setHints(new Hints((RenderingHints.Key)Utils.MOSAIC_READER, (Object)reader));
            File mosaicSource = DataUtilities.urlToFile(reader.sourceURL);
            if (!mosaicSource.isDirectory()) {
                mosaicSource = mosaicSource.getParentFile();
            }
            configuration.setParameter("RootMosaicDirectory", mosaicSource.getAbsolutePath());
            ImageMosaicEventHandlers eventHandler = new ImageMosaicEventHandlers();
            ImageMosaicConfigHandler catalogHandler = new ImageMosaicConfigHandler(configuration, eventHandler){

                @Override
                protected GranuleCatalog buildCatalog() throws IOException {
                    return reader.granuleCatalog;
                }
            };
            ImageMosaicDirectoryWalker walker = new ImageMosaicDirectoryWalker(catalogHandler, eventHandler, filter);
            eventHandler.addProcessingEventListener(new ImageMosaicEventHandlers.ProcessingEventListener(){

                @Override
                public void getNotification(ImageMosaicEventHandlers.ProcessingEvent event) {
                    if (event instanceof ImageMosaicEventHandlers.FileProcessingEvent) {
                        ImageMosaicEventHandlers.FileProcessingEvent fileEvent = (ImageMosaicEventHandlers.FileProcessingEvent)event;
                        result.add(new DefaultHarvestedSource((Object)fileEvent.getFile(), fileEvent.isIngested(), fileEvent.getMessage()));
                    }
                }

                @Override
                public void exceptionOccurred(ImageMosaicEventHandlers.ExceptionEvent event) {
                }
            });
            walker.run();
        }
    }
}

