/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.data.DataAccess;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataUtilities;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.Hints;
import org.geotools.gce.imagemosaic.FootprintBehavior;
import org.geotools.gce.imagemosaic.ImageMosaicDescriptor;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.MergeBehavior;
import org.geotools.gce.imagemosaic.MosaicConfigurationBean;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.CatalogConfigurationBean;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.util.Converters;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class ImageMosaicFormat
extends AbstractGridFormat
implements Format {
    static final double DEFAULT_ARTIFACTS_FILTER_PTILE_THRESHOLD = 0.1;
    private static final Logger LOGGER = Logging.getLogger((String)ImageMosaicFormat.class.toString());
    public static final ParameterDescriptor<Filter> FILTER = new DefaultParameterDescriptor("Filter", Filter.class, null, null);
    public static final ParameterDescriptor<Boolean> FADING = new DefaultParameterDescriptor("Fading", Boolean.class, (Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}, (Object)Boolean.FALSE);
    public static final ParameterDescriptor<Color> OUTPUT_TRANSPARENT_COLOR = new DefaultParameterDescriptor("OutputTransparentColor", Color.class, null, null);
    public static final ParameterDescriptor<Integer> MAX_ALLOWED_TILES = new DefaultParameterDescriptor("MaxAllowedTiles", Integer.class, null, (Object)-1);
    public static final ParameterDescriptor<Integer> DEFAULT_ARTIFACTS_FILTER_THRESHOLD = new DefaultParameterDescriptor("DefaultArtifactsFilterThreshold", Integer.class, null, (Object)Integer.MIN_VALUE);
    public static final ParameterDescriptor<Double> ARTIFACTS_FILTER_PTILE_THRESHOLD = new DefaultParameterDescriptor("ArtifactsFilterPtileThreshold", Double.class, null, (Object)0.1);
    public static final ParameterDescriptor<Boolean> ALLOW_MULTITHREADING = new DefaultParameterDescriptor("AllowMultithreading", Boolean.class, (Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}, (Object)Boolean.FALSE);
    public static final ParameterDescriptor<String> FOOTPRINT_BEHAVIOR = new DefaultParameterDescriptor("FootprintBehavior", String.class, (Object[])FootprintBehavior.valuesAsStrings(), (Object)FootprintBehavior.None.name());
    public static final ParameterDescriptor<double[]> BACKGROUND_VALUES = new DefaultParameterDescriptor("BackgroundValues", double[].class, null, null);
    public static final ParameterDescriptor<Interpolation> INTERPOLATION = AbstractGridFormat.INTERPOLATION;
    public static final ParameterDescriptor<Boolean> ACCURATE_RESOLUTION = new DefaultParameterDescriptor("Accurate resolution computation", Boolean.class, (Object[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}, (Object)Boolean.FALSE);
    public static final ParameterDescriptor<String> SORT_BY = new DefaultParameterDescriptor("SORTING", String.class, null, null);
    public static final ParameterDescriptor<String> MERGE_BEHAVIOR = new DefaultParameterDescriptor("MergeBehavior", String.class, (Object[])MergeBehavior.valuesAsStrings(), (Object)MergeBehavior.getDefault().toString());

    public ImageMosaicFormat() {
        this.setInfo();
    }

    private void setInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("name", "ImageMosaic");
        info.put("description", "Image mosaicking plugin");
        info.put("vendor", "Geotools");
        info.put("docURL", "");
        info.put("version", "1.0");
        this.mInfo = info;
        this.readParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D, INPUT_TRANSPARENT_COLOR, OUTPUT_TRANSPARENT_COLOR, USE_JAI_IMAGEREAD, BACKGROUND_VALUES, SUGGESTED_TILE_SIZE, ALLOW_MULTITHREADING, MAX_ALLOWED_TILES, TIME, ELEVATION, FILTER, ACCURATE_RESOLUTION, SORT_BY, MERGE_BEHAVIOR, FOOTPRINT_BEHAVIOR}));
        this.writeParameters = null;
    }

    public ImageMosaicReader getReader(Object source) {
        return this.getReader(source, null);
    }

    public GridCoverageWriter getWriter(Object destination) {
        throw new UnsupportedOperationException("This plugin does not support writing.");
    }

    public boolean accepts(Object source, Hints hints) {
        Utilities.ensureNonNull((String)"source", (Object)source);
        if (source instanceof ImageMosaicDescriptor) {
            return ImageMosaicFormat.checkDescriptor((ImageMosaicDescriptor)source);
        }
        return this.checkForUrl(source, hints);
    }

    public boolean accepts(Object source) {
        return this.accepts(source, null);
    }

    private static boolean checkDescriptor(ImageMosaicDescriptor source) {
        GranuleCatalog catalog = source.getCatalog();
        MosaicConfigurationBean configuration = source.getConfiguration();
        if (configuration == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Mosaic configuration is missing");
            }
            return false;
        }
        if (configuration.getLevels() == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("resolution leves is unavailable ");
            }
            return false;
        }
        if (catalog == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Granule Catalog is unavailable ");
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkForUrl(Object source, Hints hints) {
        try {
            File file;
            if (hints != null && hints.containsKey((Object)Utils.EXCLUDE_MOSAIC) && ((Boolean)hints.get((Object)Utils.EXCLUDE_MOSAIC)).booleanValue()) {
                return false;
            }
            boolean indexerFound = Utils.minimalIndexCheck(source);
            if (indexerFound) {
                return true;
            }
            ImageMosaicReader reader = this.getReader(source, hints);
            if (reader != null) {
                reader.dispose();
                return true;
            }
            URL sourceURL = Utils.checkSource(source, hints);
            if (sourceURL == null) {
                return false;
            }
            if (source instanceof File && !(file = (File)source).exists()) {
                return false;
            }
            DataAccess tileIndexStore = null;
            CoordinateReferenceSystem crs = null;
            boolean shapefile = true;
            try {
                boolean bl;
                File sourceF = DataUtilities.urlToFile(sourceURL);
                if (!FilenameUtils.getName((String)sourceF.getAbsolutePath()).equalsIgnoreCase("datastore.properties")) {
                    URL testPropertiesUrl = DataUtilities.changeUrlExt(sourceURL, "properties");
                    File testFile = DataUtilities.urlToFile(testPropertiesUrl);
                    if (!testFile.exists()) {
                        boolean SPIClass = false;
                        return SPIClass;
                    }
                    ShapefileDataStore store = new ShapefileDataStore(sourceURL);
                    store.setTimeZone(Utils.UTC_TIME_ZONE);
                    tileIndexStore = store;
                } else {
                    DataAccessFactory.Param[] paramsInfo;
                    shapefile = false;
                    Properties properties = new Properties();
                    FileInputStream stream = new FileInputStream(sourceF);
                    try {
                        properties.load(stream);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)stream);
                    }
                    String SPIClass = properties.getProperty("SPI");
                    DataStoreFactorySpi spi = (DataStoreFactorySpi)Class.forName(SPIClass).newInstance();
                    HashMap<String, Serializable> params = new HashMap<String, Serializable>();
                    for (DataAccessFactory.Param p : paramsInfo = spi.getParametersInfo()) {
                        if (properties.containsKey(p.key)) {
                            params.put(p.key, (Serializable)Converters.convert(properties.getProperty(p.key), p.type));
                            continue;
                        }
                        if (!p.required || p.sample != null) continue;
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Required parameter missing: " + p.toString());
                        }
                        boolean bl2 = false;
                        return bl2;
                    }
                    if (Utils.isH2Store(spi)) {
                        Utils.fixH2DatabaseLocation(params, DataUtilities.fileToURL(sourceF.getParentFile()).toExternalForm());
                    }
                    if ((tileIndexStore = spi.createDataStore(params)) == null) {
                        boolean arr$ = false;
                        return arr$;
                    }
                }
                URL propsUrl = null;
                if (shapefile) {
                    propsUrl = DataUtilities.changeUrlExt(sourceURL, "properties");
                } else {
                    File[] properties;
                    File parent = DataUtilities.urlToFile(sourceURL).getParentFile();
                    for (File propFile : properties = parent.listFiles((FilenameFilter)FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"indexer.properties")), FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"datastore.properties")), FileFilterUtils.makeFileOnly((IOFileFilter)FileFilterUtils.suffixFileFilter((String)".properties"))})}))) {
                        if (!Utils.checkFileReadable(propFile) || Utils.loadMosaicProperties(DataUtilities.fileToURL(propFile), "") == null) continue;
                        propsUrl = DataUtilities.fileToURL(propFile);
                        break;
                    }
                }
                MosaicConfigurationBean configuration = Utils.loadMosaicProperties(propsUrl, "location");
                if (configuration == null) {
                    boolean properties = false;
                    return properties;
                }
                CatalogConfigurationBean catalogBean = configuration.getCatalogConfigurationBean();
                String typeName = catalogBean.getTypeName();
                if (typeName == null) {
                    String[] typeNames = tileIndexStore.getTypeNames();
                    if (typeNames.length <= 0) {
                        boolean i$ = false;
                        return i$;
                    }
                    typeName = typeNames[0];
                }
                if (typeName == null) {
                    boolean typeNames = false;
                    return typeNames;
                }
                SimpleFeatureSource featureSource = null;
                try {
                    featureSource = tileIndexStore.getFeatureSource(typeName);
                }
                catch (Exception e) {
                    featureSource = tileIndexStore.getFeatureSource(typeName.toUpperCase());
                }
                if (featureSource == null) {
                    boolean e = false;
                    return e;
                }
                SimpleFeatureType schema = (SimpleFeatureType)featureSource.getSchema();
                if (schema == null) {
                    boolean e = false;
                    return e;
                }
                crs = ((SimpleFeatureType)featureSource.getSchema()).getGeometryDescriptor().getCoordinateReferenceSystem();
                if (crs == null) {
                    boolean e = false;
                    return e;
                }
                String locationAttributeName = catalogBean.getLocationAttribute();
                if (schema.getDescriptor(locationAttributeName) == null && schema.getDescriptor(locationAttributeName.toUpperCase()) == null) {
                    bl = false;
                    return bl;
                }
                bl = true;
                return bl;
            }
            finally {
                block70: {
                    try {
                        if (tileIndexStore != null) {
                            tileIndexStore.dispose();
                        }
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block70;
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
            }
        }
        catch (Throwable e) {
            if (!LOGGER.isLoggable(Level.FINE)) return false;
            LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            return false;
        }
    }

    public ImageMosaicReader getReader(Object source, Hints hints) {
        try {
            ImageMosaicReader reader = new ImageMosaicReader(source, hints);
            return reader;
        }
        catch (MalformedURLException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        throw new UnsupportedOperationException("Unsupported method.");
    }

    public GridCoverageWriter getWriter(Object destination, Hints hints) {
        throw new UnsupportedOperationException("This plugin does not support writing.");
    }
}

