/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.geotools.gce.image.WorldImageFormat;
import org.geotools.gce.imagemosaic.ImageMosaicConfigHandler;
import org.geotools.gce.imagemosaic.ImageMosaicEventHandlers;
import org.geotools.gce.imagemosaic.ImageMosaicWalker;
import org.geotools.gce.imagemosaic.Utils;

public class ImageMosaicDirectoryWalker
extends ImageMosaicWalker {
    private IOFileFilter fileFilter;

    @Override
    public void run() {
        try {
            String[] indexDirectories;
            IOFileFilter finalFilter = this.createDefaultGranuleExclusionFilter();
            int numFiles = 0;
            String harvestDirectory = this.configHandler.getRunConfiguration().getParameter("HarvestingDirectory");
            String indexDirs = this.configHandler.getRunConfiguration().getParameter("IndexingDirectories");
            if (harvestDirectory != null) {
                indexDirs = harvestDirectory;
            }
            for (String indexingDirectory : indexDirectories = indexDirs.split("\\s*,\\s*")) {
                indexingDirectory = Utils.checkDirectory(indexingDirectory, false);
                File directoryToScan = new File(indexingDirectory);
                Collection files = FileUtils.listFiles((File)directoryToScan, (IOFileFilter)finalFilter, (IOFileFilter)(Boolean.parseBoolean(this.configHandler.getRunConfiguration().getParameter("Recursive")) ? TrueFileFilter.INSTANCE : FalseFileFilter.INSTANCE));
                numFiles += files.size();
            }
            if (numFiles > 0) {
                this.setNumFiles(numFiles);
                ArrayList<String> indexingDirectories = new ArrayList<String>(Arrays.asList(indexDirectories));
                new MosaicDirectoryWalker(indexingDirectories, (FileFilter)finalFilter, this);
            } else {
                LOGGER.log(Level.INFO, "No files to process!");
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    private IOFileFilter createDefaultGranuleExclusionFilter() {
        WildcardFileFilter specialWildCardFileFilter = new WildcardFileFilter(this.configHandler.getRunConfiguration().getParameter("Wildcard"), IOCase.INSENSITIVE);
        IOFileFilter dirFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.directoryFileFilter(), HiddenFileFilter.VISIBLE});
        IOFileFilter filesFilter = Utils.excludeFilters(FileFilterUtils.makeSVNAware((IOFileFilter)FileFilterUtils.makeFileOnly((IOFileFilter)FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{specialWildCardFileFilter, HiddenFileFilter.VISIBLE}))), FileFilterUtils.suffixFileFilter((String)"shp"), FileFilterUtils.suffixFileFilter((String)"dbf"), FileFilterUtils.suffixFileFilter((String)"sbn"), FileFilterUtils.suffixFileFilter((String)"sbx"), FileFilterUtils.suffixFileFilter((String)"shx"), FileFilterUtils.suffixFileFilter((String)"qix"), FileFilterUtils.suffixFileFilter((String)"lyr"), FileFilterUtils.suffixFileFilter((String)"prj"), FileFilterUtils.nameFileFilter((String)"error.txt"), FileFilterUtils.nameFileFilter((String)"error.txt.lck"), FileFilterUtils.suffixFileFilter((String)"properties"), FileFilterUtils.suffixFileFilter((String)"svn-base"), FileFilterUtils.suffixFileFilter((String)"ncx"), FileFilterUtils.suffixFileFilter((String)"ncx2"), FileFilterUtils.suffixFileFilter((String)"ncx3"), FileFilterUtils.suffixFileFilter((String)"gbx9"));
        filesFilter = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{filesFilter, FileFilterUtils.nameFileFilter((String)"indexer.properties")});
        Set extensions = WorldImageFormat.getWorldExtension((String)"png");
        for (String ext : extensions) {
            filesFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{filesFilter, FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)ext.substring(1)))});
        }
        extensions = WorldImageFormat.getWorldExtension((String)"gif");
        for (String ext : extensions) {
            filesFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{filesFilter, FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)ext.substring(1)))});
        }
        extensions = WorldImageFormat.getWorldExtension((String)"jpg");
        for (String ext : extensions) {
            filesFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{filesFilter, FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)ext.substring(1)))});
        }
        extensions = WorldImageFormat.getWorldExtension((String)"tiff");
        for (String ext : extensions) {
            filesFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{filesFilter, FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)ext.substring(1)))});
        }
        extensions = WorldImageFormat.getWorldExtension((String)"bmp");
        for (String ext : extensions) {
            filesFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{filesFilter, FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)ext.substring(1)))});
        }
        filesFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{filesFilter, FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)"sdw")), FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)"aux")), FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)"wld")), FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)"svn"))});
        if (this.fileFilter != null) {
            filesFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{this.fileFilter, filesFilter});
        }
        IOFileFilter finalFilter = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{dirFilter, filesFilter});
        return finalFilter;
    }

    public ImageMosaicDirectoryWalker(ImageMosaicConfigHandler configHandler, ImageMosaicEventHandlers eventHandler, IOFileFilter filter) {
        super(configHandler, eventHandler);
        this.fileFilter = filter;
    }

    public ImageMosaicDirectoryWalker(ImageMosaicConfigHandler catalogHandler, ImageMosaicEventHandlers eventHandler) {
        this(catalogHandler, eventHandler, null);
    }

    final class MosaicDirectoryWalker
    extends DirectoryWalker {
        private ImageMosaicWalker walker;

        protected void handleCancelled(File startDirectory, Collection results, DirectoryWalker.CancelException cancel) throws IOException {
            super.handleCancelled(startDirectory, results, cancel);
            if (ImageMosaicWalker.LOGGER.isLoggable(Level.INFO)) {
                ImageMosaicWalker.LOGGER.info("Stop requested when walking directory " + startDirectory);
            }
            super.handleEnd(results);
        }

        protected boolean handleIsCancelled(File file, int depth, Collection results) throws IOException {
            return !ImageMosaicDirectoryWalker.this.checkStop();
        }

        protected void handleFile(File fileBeingProcessed, int depth, Collection results) throws IOException {
            this.walker.handleFile(fileBeingProcessed);
            super.handleFile(fileBeingProcessed, depth, results);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public MosaicDirectoryWalker(List<String> indexingDirectories, FileFilter filter, ImageMosaicWalker walker) throws IOException {
            block25: {
                String message;
                block24: {
                    super(filter, Integer.MAX_VALUE);
                    this.walker = walker;
                    ImageMosaicDirectoryWalker.this.startTransaction();
                    ImageMosaicDirectoryWalker.this.configHandler.indexingPreamble();
                    for (String indexingDirectory : indexingDirectories) {
                        this.walk(new File(indexingDirectory), null);
                        if (!ImageMosaicDirectoryWalker.this.getStop()) continue;
                        break;
                    }
                    if (ImageMosaicDirectoryWalker.this.getStop()) {
                        ImageMosaicDirectoryWalker.this.rollbackTransaction();
                        break block24;
                    }
                    ImageMosaicDirectoryWalker.this.commitTransaction();
                }
                try {
                    ImageMosaicDirectoryWalker.this.configHandler.indexingPostamble(!ImageMosaicDirectoryWalker.this.getStop());
                }
                catch (Exception e) {
                    message = "Unable to close indexing" + e.getLocalizedMessage();
                    if (ImageMosaicWalker.LOGGER.isLoggable(Level.WARNING)) {
                        ImageMosaicWalker.LOGGER.log(Level.WARNING, message, e);
                    }
                    ImageMosaicDirectoryWalker.this.eventHandler.fireException(e);
                }
                try {
                    ImageMosaicDirectoryWalker.this.closeTransaction();
                }
                catch (Exception e) {
                    message = "Unable to close indexing" + e.getLocalizedMessage();
                    if (ImageMosaicWalker.LOGGER.isLoggable(Level.WARNING)) {
                        ImageMosaicWalker.LOGGER.log(Level.WARNING, message, e);
                    }
                    ImageMosaicDirectoryWalker.this.eventHandler.fireException(e);
                }
                break block25;
                catch (Exception e) {
                    String message2;
                    try {
                        ImageMosaicWalker.LOGGER.log(Level.WARNING, "Failure occurred while collecting the granules", e);
                        ImageMosaicDirectoryWalker.this.rollbackTransaction();
                    }
                    catch (Throwable throwable) {
                        String message3;
                        try {
                            ImageMosaicDirectoryWalker.this.configHandler.indexingPostamble(!ImageMosaicDirectoryWalker.this.getStop());
                        }
                        catch (Exception e2) {
                            message3 = "Unable to close indexing" + e2.getLocalizedMessage();
                            if (ImageMosaicWalker.LOGGER.isLoggable(Level.WARNING)) {
                                ImageMosaicWalker.LOGGER.log(Level.WARNING, message3, e2);
                            }
                            ImageMosaicDirectoryWalker.this.eventHandler.fireException(e2);
                        }
                        try {
                            ImageMosaicDirectoryWalker.this.closeTransaction();
                        }
                        catch (Exception e3) {
                            message3 = "Unable to close indexing" + e3.getLocalizedMessage();
                            if (ImageMosaicWalker.LOGGER.isLoggable(Level.WARNING)) {
                                ImageMosaicWalker.LOGGER.log(Level.WARNING, message3, e3);
                            }
                            ImageMosaicDirectoryWalker.this.eventHandler.fireException(e3);
                        }
                        throw throwable;
                    }
                    try {
                        ImageMosaicDirectoryWalker.this.configHandler.indexingPostamble(!ImageMosaicDirectoryWalker.this.getStop());
                    }
                    catch (Exception e4) {
                        message2 = "Unable to close indexing" + e4.getLocalizedMessage();
                        if (ImageMosaicWalker.LOGGER.isLoggable(Level.WARNING)) {
                            ImageMosaicWalker.LOGGER.log(Level.WARNING, message2, e4);
                        }
                        ImageMosaicDirectoryWalker.this.eventHandler.fireException(e4);
                    }
                    try {
                        ImageMosaicDirectoryWalker.this.closeTransaction();
                    }
                    catch (Exception e5) {
                        message2 = "Unable to close indexing" + e5.getLocalizedMessage();
                        if (ImageMosaicWalker.LOGGER.isLoggable(Level.WARNING)) {
                            ImageMosaicWalker.LOGGER.log(Level.WARNING, message2, e5);
                        }
                        ImageMosaicDirectoryWalker.this.eventHandler.fireException(e5);
                    }
                }
            }
        }
    }
}

