/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RegistryElementDescriptor;
import javax.media.jai.operator.MosaicDescriptor;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.InvalidGridGeometryException;
import org.geotools.coverage.grid.ViewType;
import org.geotools.coverage.processing.CoverageProcessingException;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.coverage.processing.operation.GridCoverage2DRIA;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.ImagingParameterDescriptors;
import org.geotools.parameter.ImagingParameters;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.util.Utilities;
import org.jaitools.imageutils.ImageLayout2;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

public class Mosaic
extends OperationJAI {
    public static final String POLICY = "policy";
    public static final String GEOMETRY = "geometry";
    public static final String SOURCES_NAME = "Sources";
    public static final String OUTNODATA_NAME = "outputNoData";
    public static final String ALPHA_NAME = "alphas";
    public static final ParameterDescriptor SOURCES = new DefaultParameterDescriptor<Object>(Citations.JAI, "Sources", Collection.class, null, null, null, null, null, true);
    public static final ParameterDescriptor<GridGeometry> GG = new DefaultParameterDescriptor<Object>(Citations.JAI, "geometry", GridGeometry.class, null, null, null, null, null, false);
    public static final ParameterDescriptor<String> GEOMETRY_POLICY = new DefaultParameterDescriptor<Object>(Citations.JAI, "policy", String.class, null, null, null, null, null, false);
    public static final ParameterDescriptor<double[]> OUTPUT_NODATA = new DefaultParameterDescriptor<Object>(Citations.JAI, "outputNoData", double[].class, null, null, null, null, null, false);
    public static final ParameterDescriptor<Collection> ALPHA = new DefaultParameterDescriptor<Object>(Citations.JAI, "alphas", Collection.class, null, null, null, null, null, false);
    private static Set<ParameterDescriptor> REPLACED_DESCRIPTORS;

    public Mosaic() {
        super((OperationDescriptor)new MosaicDescriptor(), new ImagingParameterDescriptors((RegistryElementDescriptor)Mosaic.getOperationDescriptor("Mosaic"), REPLACED_DESCRIPTORS));
    }

    @Override
    public Coverage doOperation(ParameterValueGroup parameters, Hints hints) throws CoverageProcessingException {
        ArrayList<GridCoverage2D> sourceCollection = new ArrayList<GridCoverage2D>();
        ViewType primarySourceType = this.extractSources(parameters, sourceCollection);
        int numSources = sourceCollection.size();
        GridCoverage2D[] sources = new GridCoverage2D[numSources];
        sourceCollection.toArray(sources);
        GridCoverage2D firstCoverage = sources[0];
        CoordinateReferenceSystem crs = firstCoverage.getCoordinateReferenceSystem();
        for (int i = 0; i < sources.length; ++i) {
            GridCoverage2D source = sources[i];
            CoordinateReferenceSystem crsSource = source.getCoordinateReferenceSystem();
            if (CRS.equalsIgnoreMetadata(crs, crsSource)) continue;
            throw new CoverageProcessingException("Input Coverages have different CRS");
        }
        Params params = this.prepareParameters(parameters, sources, hints);
        GridCoverage2D coverage = this.deriveGridCoverage(sources, params);
        if (primarySourceType != null) {
            coverage = coverage.view(primarySourceType);
        }
        return coverage;
    }

    private ViewType extractSources(ParameterValueGroup parameters, Collection<GridCoverage2D> sources) throws ParameterNotFoundException, InvalidParameterValueException {
        Utilities.ensureNonNull((String)"parameters", (Object)parameters);
        Utilities.ensureNonNull((String)"sources", sources);
        Object srcCoverages = parameters.parameter("sources").getValue();
        if (!(srcCoverages instanceof Collection) || ((Collection)srcCoverages).isEmpty() || !(((Collection)srcCoverages).iterator().next() instanceof GridCoverage2D)) {
            throw new InvalidParameterValueException(Errors.format((int)57, (Object)"sources"), "sources", srcCoverages);
        }
        Collection sourceCoverages = (Collection)srcCoverages;
        ViewType type = null;
        boolean computeOnGeophysicsValues = this.computeOnGeophysicsValues(parameters);
        int i = 0;
        for (GridCoverage2D source : sourceCoverages) {
            if (source != null) {
                if (computeOnGeophysicsValues) {
                    GridCoverage2D old = source;
                    source = source.view(ViewType.GEOPHYSICS);
                    if (i == 0) {
                        type = old == source ? ViewType.GEOPHYSICS : ViewType.PACKED;
                    }
                }
                sources.add(source);
            }
            ++i;
        }
        return type;
    }

    private Params prepareParameters(ParameterValueGroup parameters, GridCoverage2D[] sources, Hints hints) {
        ImagingParameters copy = (ImagingParameters)this.descriptor.createValue();
        ParameterBlockJAI block = (ParameterBlockJAI)copy.parameters;
        GridGeometryPolicy policy = null;
        Object externalGG = parameters.parameter(GEOMETRY).getValue();
        GridGeometry2D gg = null;
        if (externalGG != null && externalGG instanceof GridGeometry2D) {
            gg = (GridGeometry2D)externalGG;
            policy = GridGeometryPolicy.EXTERNAL;
        } else {
            Object ggPolicy = parameters.parameter(POLICY).getValue();
            if (ggPolicy != null && ggPolicy instanceof String) {
                policy = GridGeometryPolicy.getPolicyFromString((String)ggPolicy);
            }
        }
        if (policy == null) {
            policy = GridGeometryPolicy.FIRST;
        }
        Object alphaBandList = parameters.parameter(ALPHA_NAME).getValue();
        GridCoverage2D[] alphaCovs = null;
        if (alphaBandList != null && alphaBandList instanceof Collection) {
            Collection alphas = (Collection)alphaBandList;
            alphaCovs = new GridCoverage2D[alphas.size()];
            alphas.toArray(alphaCovs);
        }
        ResampledRasters rr = policy.resampleGridGeometry(sources, alphaCovs, gg, parameters, hints);
        RenderedImage[] rasters = rr.getRasters();
        GridGeometry2D finalGeometry = rr.getFinalGeometry();
        if (finalGeometry == null) {
            throw new CoverageProcessingException("No final GridGeometry found");
        }
        int numSources = rasters.length;
        for (int i = 0; i < numSources; ++i) {
            block.setSource((Object)rasters[i], i);
        }
        double[] nodata = null;
        Object outputNodata = parameters.parameter(OUTNODATA_NAME).getValue();
        nodata = outputNodata != null && outputNodata instanceof double[] ? (double[])outputNodata : CoverageUtilities.getBackgroundValues(sources[0]);
        block.setParameter("backgroundValues", (Object)nodata);
        double threshold = CoverageUtilities.getMosaicThreshold(rasters[0].getSampleModel().getDataType());
        block.setParameter("sourceThreshold", (Object)new double[][]{{threshold}});
        ROI[] rois = new ROI[numSources];
        for (int i = 0; i < numSources; ++i) {
            rois[i] = new ROIShape((Shape)PlanarImage.wrapRenderedImage((RenderedImage)rasters[i]).getBounds());
        }
        block.setParameter("sourceROI", (Object)rois);
        block.setParameter("mosaicType", (Object)MosaicDescriptor.MOSAIC_TYPE_OVERLAY);
        if (rr.getAlphas() != null) {
            block.setParameter("sourceAlpha", (Object)rr.getAlphas());
        }
        return new Params(block, hints, finalGeometry);
    }

    private GridCoverage2D deriveGridCoverage(GridCoverage2D[] sources, Params parameters) {
        GridCoverage2D primarySource = sources[0];
        RenderingHints hintsStart = ImageUtilities.getRenderingHints(parameters.getSource());
        RenderingHints hints = null;
        if (parameters.hints != null) {
            if (hintsStart != null) {
                hints = new Hints(hintsStart);
                hints.add((RenderingHints)parameters.hints);
            } else {
                hints = new Hints((RenderingHints)parameters.hints);
            }
        }
        ImageLayout layoutOld = hints != null ? (ImageLayout)hints.get(JAI.KEY_IMAGE_LAYOUT) : null;
        ImageLayout layout = null;
        if (layoutOld != null) {
            layout = (ImageLayout)layoutOld.clone();
            layout.unsetValid(1);
            layout.unsetValid(2);
            layout.unsetValid(4);
            layout.unsetValid(8);
        } else {
            layout = new ImageLayout2();
        }
        GridEnvelope2D gridRange = parameters.finalGeometry.getGridRange2D();
        layout.setMinX(gridRange.x);
        layout.setMinY(gridRange.y);
        layout.setWidth(gridRange.width);
        layout.setHeight(gridRange.height);
        if (hints == null) {
            hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        } else {
            hints.put(JAI.KEY_IMAGE_LAYOUT, layout);
        }
        InternationalString name = this.deriveName(sources, -1, null);
        CoordinateReferenceSystem crs = primarySource.getCoordinateReferenceSystem();
        MathTransform toCRS = parameters.finalGeometry.getGridToCRS();
        RenderedImage data = this.createRenderedImage(parameters.parameters, hints);
        Map<String, ?> properties = this.getProperties(data, crs, name, toCRS, sources, null);
        return Mosaic.getFactory(parameters.hints).create((CharSequence)name, data, crs, toCRS, primarySource.getSampleDimensions(), sources, properties);
    }

    static {
        HashSet<Object> replacedDescriptors = new HashSet<Object>();
        replacedDescriptors.add(SOURCES);
        replacedDescriptors.add(GG);
        replacedDescriptors.add(GEOMETRY_POLICY);
        replacedDescriptors.add(OUTPUT_NODATA);
        replacedDescriptors.add(ALPHA);
        REPLACED_DESCRIPTORS = Collections.unmodifiableSet(replacedDescriptors);
    }

    private static final class ResampledRasters {
        private RenderedImage[] rasters;
        private GridGeometry2D finalGeometry;
        private PlanarImage[] alphas;

        private ResampledRasters() {
        }

        public RenderedImage[] getRasters() {
            return this.rasters;
        }

        public void setRasters(RenderedImage[] rasters) {
            this.rasters = rasters;
        }

        public GridGeometry2D getFinalGeometry() {
            return this.finalGeometry;
        }

        public void setFinalGeometry(GridGeometry2D finalGeometry) {
            this.finalGeometry = finalGeometry;
        }

        public PlanarImage[] getAlphas() {
            return this.alphas;
        }

        public void setAlphas(PlanarImage[] alphas) {
            this.alphas = alphas;
        }
    }

    protected static final class Params {
        public final ParameterBlockJAI parameters;
        public final GridGeometry2D finalGeometry;
        public final Hints hints;

        Params(ParameterBlockJAI parameters, Hints hints, GridGeometry2D finalGeometry) {
            this.parameters = parameters;
            this.hints = hints;
            this.finalGeometry = finalGeometry;
        }

        final RenderedImage getSource() {
            int n = this.parameters.getNumSources();
            for (int i = 0; i < n; ++i) {
                Object source = this.parameters.getSource(i);
                if (!(source instanceof RenderedImage)) continue;
                return (RenderedImage)source;
            }
            return null;
        }
    }

    public static enum GridGeometryPolicy {
        FIRST("first"){

            @Override
            public ResampledRasters resampleGridGeometry(GridCoverage2D[] sources, GridCoverage2D[] alphas, GridGeometry2D external, ParameterValueGroup parameters, Hints hints) {
                int index = 0;
                GridGeometry2D finalGG = GridGeometryPolicy.extractFinalGridGeometry(sources, index);
                return GridGeometryPolicy.resampleCoverages(sources, alphas, finalGG, parameters, hints);
            }
        }
        ,
        FINE("fine"){

            @Override
            public ResampledRasters resampleGridGeometry(GridCoverage2D[] sources, GridCoverage2D[] alphas, GridGeometry2D external, ParameterValueGroup parameters, Hints hints) {
                int numSources = sources.length;
                GridGeometry2D grid = sources[0].getGridGeometry();
                Envelope2D env = grid.getEnvelope2D();
                GridEnvelope2D gridEnv = grid.getGridRange2D();
                double res = env.width / (double)gridEnv.width;
                int index = 0;
                for (int i = 1; i < numSources; ++i) {
                    GridGeometry2D gridI = sources[i].getGridGeometry();
                    Envelope2D envI = gridI.getEnvelope2D();
                    GridEnvelope2D gridEnvI = gridI.getGridRange2D();
                    double resValue = envI.width / (double)gridEnvI.width;
                    if (!(resValue < res)) continue;
                    res = resValue;
                    index = i;
                }
                GridGeometry2D finalGG = GridGeometryPolicy.extractFinalGridGeometry(sources, index);
                return GridGeometryPolicy.resampleCoverages(sources, alphas, finalGG, parameters, hints);
            }
        }
        ,
        COARSE("coarse"){

            @Override
            public ResampledRasters resampleGridGeometry(GridCoverage2D[] sources, GridCoverage2D[] alphas, GridGeometry2D external, ParameterValueGroup parameters, Hints hints) {
                int numSources = sources.length;
                GridGeometry2D grid = sources[0].getGridGeometry();
                Envelope2D env = grid.getEnvelope2D();
                GridEnvelope2D gridEnv = grid.getGridRange2D();
                double res = env.width / (double)gridEnv.width;
                int index = 0;
                for (int i = 1; i < numSources; ++i) {
                    GridGeometry2D gridI = sources[i].getGridGeometry();
                    Envelope2D envI = gridI.getEnvelope2D();
                    GridEnvelope2D gridEnvI = gridI.getGridRange2D();
                    double resValue = envI.width / (double)gridEnvI.width;
                    if (!(resValue > res)) continue;
                    res = resValue;
                    index = i;
                }
                GridGeometry2D finalGG = GridGeometryPolicy.extractFinalGridGeometry(sources, index);
                return GridGeometryPolicy.resampleCoverages(sources, alphas, finalGG, parameters, hints);
            }
        }
        ,
        EXTERNAL("external"){

            @Override
            public ResampledRasters resampleGridGeometry(GridCoverage2D[] sources, GridCoverage2D[] alphas, GridGeometry2D external, ParameterValueGroup parameters, Hints hints) {
                if (external == null) {
                    throw new CoverageProcessingException("No input GridGeometry found");
                }
                return GridGeometryPolicy.resampleCoverages(sources, alphas, external, parameters, hints);
            }
        };

        private String name;

        private GridGeometryPolicy(String name) {
            this.name = name;
        }

        public abstract ResampledRasters resampleGridGeometry(GridCoverage2D[] var1, GridCoverage2D[] var2, GridGeometry2D var3, ParameterValueGroup var4, Hints var5);

        public static GridGeometryPolicy getPolicyFromString(String policyString) {
            if (policyString.equalsIgnoreCase(GridGeometryPolicy.FIRST.name)) {
                return FIRST;
            }
            if (policyString.equalsIgnoreCase(GridGeometryPolicy.FINE.name)) {
                return FINE;
            }
            if (policyString.equalsIgnoreCase(GridGeometryPolicy.COARSE.name)) {
                return COARSE;
            }
            if (policyString.equalsIgnoreCase(GridGeometryPolicy.EXTERNAL.name)) {
                return EXTERNAL;
            }
            return null;
        }

        private static ResampledRasters resampleCoverages(GridCoverage2D[] sources, GridCoverage2D[] alphas, GridGeometry2D external, ParameterValueGroup parameters, Hints hints) {
            int numSources = sources.length;
            RenderedImage[] rasters = new RenderedImage[numSources];
            MathTransform2D g2w = external.getGridToCRS2D(PixelOrientation.UPPER_LEFT);
            double[] nodata = null;
            Object outputNodata = parameters.parameter(Mosaic.OUTNODATA_NAME).getValue();
            if (outputNodata != null && outputNodata instanceof double[]) {
                nodata = (double[])outputNodata;
            }
            boolean hasAlpha = alphas != null && alphas.length > 0;
            PlanarImage[] alphaArray = new PlanarImage[numSources];
            for (int i = 0; i < numSources; ++i) {
                MathTransform2D w2gD;
                GridCoverage2D coverage = sources[i];
                GridGeometry2D inputGG = coverage.getGridGeometry();
                MathTransform2D g2wS = inputGG.getGridToCRS2D(PixelOrientation.UPPER_LEFT);
                MathTransform concatenated = ConcatenatedTransform.create((MathTransform)g2wS, (MathTransform)(w2gD = external.getCRSToGrid2D(PixelOrientation.UPPER_LEFT)));
                if (concatenated != null && concatenated.isIdentity()) {
                    RenderedImage renderedImage;
                    rasters[i] = renderedImage = coverage.getRenderedImage();
                    if (!hasAlpha || alphas[i] == null) continue;
                    GridGeometryPolicy.checkAlpha(coverage, alphas[i]);
                    alphaArray[i] = PlanarImage.wrapRenderedImage((RenderedImage)alphas[i].getRenderedImage());
                    continue;
                }
                GridGeometry2D newGG = new GridGeometry2D(PixelInCell.CELL_CORNER, (MathTransform)g2w, inputGG.getEnvelope(), GeoTools.getDefaultHints());
                try {
                    GeneralEnvelope transformed = CRS.transform(g2w.inverse(), inputGG.getEnvelope());
                    Rectangle rect = transformed.toRectangle2D().getBounds();
                    GridEnvelope2D gEnv2 = new GridEnvelope2D(rect);
                    newGG = new GridGeometry2D(gEnv2, inputGG.getEnvelope());
                }
                catch (InvalidGridGeometryException e) {
                    throw new CoverageProcessingException(e);
                }
                catch (NoninvertibleTransformException e) {
                    throw new CoverageProcessingException(e);
                }
                catch (TransformException e) {
                    throw new CoverageProcessingException(e);
                }
                double[] fillValue = null;
                fillValue = nodata == null ? CoverageUtilities.getBackgroundValues(coverage) : nodata;
                rasters[i] = GridCoverage2DRIA.create(coverage, newGG, fillValue, hints);
                if (!hasAlpha || alphas[i] == null) continue;
                GridGeometryPolicy.checkAlpha(coverage, alphas[i]);
                GridCoverage2DRIA al = GridCoverage2DRIA.create(alphas[i], newGG, new double[1], hints);
                alphaArray[i] = PlanarImage.wrapRenderedImage((RenderedImage)((Object)al));
            }
            ResampledRasters rr = new ResampledRasters();
            rr.setFinalGeometry(external);
            rr.setRasters(rasters);
            rr.setAlphas(alphaArray);
            return rr;
        }

        private static void checkAlpha(GridCoverage2D coverage, GridCoverage2D alpha) {
            if (!coverage.getGridGeometry().equals(alpha.getGridGeometry())) {
                throw new CoverageProcessingException("Alpha Coverage and Source Coverage does not have the same dimensions");
            }
        }

        private static GridGeometry2D extractFinalGridGeometry(GridCoverage2D[] sources, int index) {
            GridGeometry2D gg = sources[index].getGridGeometry();
            MathTransform2D g2w = gg.getGridToCRS2D(PixelOrientation.UPPER_LEFT);
            Envelope2D bbox = gg.getEnvelope2D();
            int numSources = sources.length;
            for (int i = 0; i < numSources; ++i) {
                bbox.include(sources[i].getEnvelope2D());
            }
            GridGeometry2D finalGG = new GridGeometry2D(PixelInCell.CELL_CORNER, (MathTransform)g2w, bbox, GeoTools.getDefaultHints());
            return finalGG;
        }
    }
}

