/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf.readers;

import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import org.geotools.data.vpf.VPFFeatureType;
import org.geotools.data.vpf.file.VPFFile;
import org.geotools.data.vpf.file.VPFFileFactory;
import org.geotools.data.vpf.ifc.FileConstants;
import org.geotools.data.vpf.readers.VPFGeometryFactory;
import org.geotools.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;

public class TextGeometryFactory
extends VPFGeometryFactory
implements FileConstants {
    @Override
    public void createGeometry(VPFFeatureType featureType, SimpleFeature values) throws SQLException, IOException, IllegalAttributeException {
        Geometry result = null;
        int textId = Integer.parseInt(values.getAttribute("txt_id").toString());
        String baseDirectory = featureType.getFeatureClass().getDirectoryName();
        String tileDirectory = baseDirectory;
        if (!new File(tileDirectory.concat(File.separator).concat("txt")).exists()) {
            Short tileId = new Short(Short.parseShort(values.getAttribute("tile_id").toString()));
            tileDirectory = tileDirectory.concat(File.separator).concat(featureType.getFeatureClass().getCoverage().getLibrary().getTileMap().get(tileId).toString()).trim();
        }
        String textTableName = tileDirectory.concat(File.separator).concat("txt");
        VPFFile textFile = VPFFileFactory.getInstance().getFile(textTableName);
        SimpleFeature row = textFile.getRowFromId("id", textId);
        result = (Geometry)row.getAttribute("shape_line");
        values.setDefaultGeometry((Object)result);
    }
}

