/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf.readers;

import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import org.geotools.data.vpf.VPFFeatureType;
import org.geotools.data.vpf.file.VPFFile;
import org.geotools.data.vpf.file.VPFFileFactory;
import org.geotools.data.vpf.ifc.FileConstants;
import org.geotools.data.vpf.readers.VPFGeometryFactory;
import org.geotools.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;

public class LineGeometryFactory
extends VPFGeometryFactory
implements FileConstants {
    @Override
    public void createGeometry(VPFFeatureType featureType, SimpleFeature values) throws SQLException, IOException, IllegalAttributeException {
        Geometry result = null;
        int edgeId = Integer.parseInt(values.getAttribute("edg_id").toString());
        String baseDirectory = featureType.getFeatureClass().getDirectoryName();
        String tileDirectory = baseDirectory;
        if (!new File(tileDirectory.concat(File.separator).concat("edg")).exists()) {
            Short tileId = new Short(Short.parseShort(values.getAttribute("tile_id").toString()));
            tileDirectory = tileDirectory.concat(File.separator).concat(featureType.getFeatureClass().getCoverage().getLibrary().getTileMap().get(tileId).toString()).trim();
        }
        String edgeTableName = tileDirectory.concat(File.separator).concat("edg");
        VPFFile edgeFile = VPFFileFactory.getInstance().getFile(edgeTableName);
        SimpleFeature row = edgeFile.getRowFromId("id", edgeId);
        result = (Geometry)row.getAttribute("coordinates");
        values.setDefaultGeometry((Object)result);
    }
}

