/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.FeatureReader;
import org.geotools.data.vpf.file.VPFFile;
import org.geotools.data.vpf.file.VPFFileFeatureReader;
import org.geotools.feature.SchemaException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class VPFFileStore
extends AbstractDataStore {
    private Map<String, SimpleFeatureType> files = new HashMap<String, SimpleFeatureType>();

    @Override
    public String[] getTypeNames() {
        String[] result = new String[this.files.size()];
        int counter = 0;
        for (SimpleFeatureType currentFile : this.files.values()) {
            result[counter] = currentFile.getTypeName();
        }
        return result;
    }

    @Override
    public SimpleFeatureType getSchema(String pathName) throws IOException {
        SimpleFeatureType result = null;
        if (this.files.containsKey(pathName)) {
            result = this.files.get(pathName);
        } else {
            try {
                VPFFile file = this.findFile(pathName);
                result = file.getFeatureType();
            }
            catch (SchemaException exc) {
                throw new IOException("Schema error in path: " + pathName + "\n" + exc.getMessage());
            }
            this.files.put(pathName, result);
        }
        return result;
    }

    @Override
    protected FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(String pathName) throws IOException {
        return new VPFFileFeatureReader((VPFFile)this.getSchema(pathName));
    }

    public void reset() {
        Iterator<SimpleFeatureType> iter = this.files.values().iterator();
        VPFFile file = null;
        while (iter.hasNext()) {
            try {
                SimpleFeatureType schema = iter.next();
                file = (VPFFile)schema.getUserData().get(VPFFile.class);
                file.close();
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        this.files.clear();
    }

    private VPFFile findFile(String pathName) throws IOException, SchemaException {
        if (new File(pathName).exists()) {
            return new VPFFile(pathName);
        }
        ArrayList<String> matches = new ArrayList<String>();
        matches.add("");
        StringTokenizer st = new StringTokenizer(pathName, File.separator);
        while (st.hasMoreTokens() && !matches.isEmpty()) {
            String curr = st.nextToken();
            String currUpper = curr.toUpperCase();
            String currLower = curr.toLowerCase();
            boolean useUpper = !curr.equals(currUpper);
            boolean useLower = !curr.equals(currLower);
            ArrayList<String> newMatches = new ArrayList<String>();
            for (String match : matches) {
                String tmp = match + File.separator + curr;
                if (new File(tmp).exists()) {
                    newMatches.add(tmp);
                    continue;
                }
                if (useUpper && new File(tmp = match + File.separator + currUpper).exists()) {
                    newMatches.add(tmp);
                }
                if (!useLower || !new File(tmp = match + File.separator + currLower).exists()) continue;
                newMatches.add(tmp);
            }
            matches = newMatches;
        }
        if (matches.isEmpty()) {
            throw new FileNotFoundException("Could not find file: " + pathName);
        }
        return new VPFFile((String)matches.get(0));
    }
}

