/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.vpf.VPFLibrary;
import org.geotools.feature.SchemaException;
import org.geotools.util.logging.Logging;

public class VPFDataStoreFactory
implements DataStoreFactorySpi {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.vpf");
    public static final DataAccessFactory.Param DIR = new DataAccessFactory.Param("url", URL.class, "Directory containing lht file", true);
    public static final DataAccessFactory.Param NAMESPACEP = new DataAccessFactory.Param("namespace", URI.class, "uri to a the namespace", false);

    @Override
    public String getDisplayName() {
        return "Vector Product Format Library";
    }

    @Override
    public String getDescription() {
        return "Vector Product Format Library data store implementation.";
    }

    public boolean canProcess(Map params) {
        boolean result = false;
        try {
            File file = this.getLhtFile(params);
            result = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public DataStore createDataStore(Map params) throws IOException {
        return this.create(params);
    }

    private DataStore create(Map params) throws IOException {
        VPFLibrary result = null;
        File file = this.getLhtFile(params);
        if (!file.exists() || !file.canRead()) {
            throw new IOException("File either doesn't exist or is unreadable : " + file);
        }
        URI namespace = (URI)NAMESPACEP.lookUp(params);
        LOGGER.finer("creating new vpf datastore with params: " + params);
        try {
            result = new VPFLibrary(file, namespace);
        }
        catch (SchemaException exc) {
            throw new IOException("There was a problem making one of the feature classes as a FeatureType.");
        }
        return result;
    }

    private File getLhtFile(Map params) throws IOException {
        URL url = (URL)DIR.lookUp(params);
        File file = null;
        if (url.getProtocol().equals("file")) {
            file = url.getHost() != null && !url.getHost().equals("") ? new File(url.getHost() + ":" + url.getFile()) : new File(url.getFile());
            if (file.isDirectory()) {
                File lhtFile = new File(file, "lht");
            } else {
                File lhtFile = file;
                if (!lhtFile.getName().equalsIgnoreCase("lht")) {
                    throw new IOException("File: " + file + "is not a lht file");
                }
            }
        } else {
            throw new IOException("only file protocol supported");
        }
        return file;
    }

    public DataStore createNewDataStore(Map params) throws IOException {
        return this.create(params);
    }

    @Override
    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{DIR};
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

