/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.geotools.data.vpf.VPFFeatureClass;
import org.geotools.data.vpf.VPFFeatureType;
import org.geotools.data.vpf.VPFLibrary;
import org.geotools.data.vpf.file.VPFFile;
import org.geotools.data.vpf.file.VPFFileFactory;
import org.geotools.data.vpf.ifc.FCode;
import org.geotools.feature.SchemaException;
import org.opengis.feature.simple.SimpleFeature;

public class VPFCoverage {
    private final String description;
    private final List featureClasses = new Vector();
    private final List featureTypes = new Vector(25);
    private final VPFLibrary library;
    private final String pathName;
    private final int topologyLevel;
    private final URI namespace;

    public VPFCoverage(VPFLibrary cLibrary, SimpleFeature feature, String cDirectoryName) throws IOException, SchemaException {
        this(cLibrary, feature, cDirectoryName, null);
    }

    public VPFCoverage(VPFLibrary cLibrary, SimpleFeature feature, String cDirectoryName, URI namespace) throws IOException, SchemaException {
        this.topologyLevel = Short.parseShort(feature.getAttribute("level").toString());
        this.library = cLibrary;
        this.description = feature.getAttribute("description").toString();
        this.namespace = namespace;
        this.pathName = cDirectoryName.concat(File.separator).concat(feature.getAttribute("coverage_name").toString());
        this.discoverFeatureClasses();
        this.discoverFeatureTypes();
    }

    private void discoverFeatureClasses() throws IOException, SchemaException {
        VPFFeatureClass featureClass = null;
        String fcsFileName = this.pathName + File.separator + "fcs";
        HashSet featureClassNames = new HashSet();
        VPFFile file = VPFFileFactory.getInstance().getFile(fcsFileName);
        for (SimpleFeature row : file.readAllRows()) {
            String featureClassName = row.getAttribute("feature_class").toString().trim();
            featureClass = new VPFFeatureClass(this, featureClassName, this.pathName, this.namespace);
            this.featureClasses.add(featureClass);
        }
    }

    private void discoverFeatureTypes() {
        try {
            block2: for (SimpleFeature row : this.getCharVDT().readAllRows()) {
                String attr = row.getAttribute("attribute").toString().trim().toLowerCase();
                if (!FCode.ALLOWED_FCODE_ATTRIBUTES_LIST.contains(attr)) continue;
                String tableFileName = row.getAttribute("table").toString().trim();
                String featureClassName = tableFileName.substring(0, tableFileName.indexOf("."));
                for (VPFFeatureClass featureClass : this.featureClasses) {
                    if (!featureClassName.equals(featureClass.getTypeName())) continue;
                    VPFFeatureType featureType = new VPFFeatureType(featureClass, row);
                    this.featureTypes.add(featureType);
                    continue block2;
                }
            }
        }
        catch (IOException exc) {
            VPFFeatureClass coverageClass = (VPFFeatureClass)this.featureClasses.get(0);
            VPFFeatureType featureType = new VPFFeatureType(coverageClass);
            this.featureTypes.add(featureType);
        }
    }

    private VPFFile getCharVDT() throws IOException {
        VPFFile charvdtInputStream = null;
        String charvdtFileName = this.pathName + File.separator + "char.vdt";
        charvdtInputStream = VPFFileFactory.getInstance().getFile(charvdtFileName);
        return charvdtInputStream;
    }

    public List getFeatureClasses() {
        return this.featureClasses;
    }

    public List getFeatureTypes() {
        return this.featureTypes;
    }

    public VPFLibrary getLibrary() {
        return this.library;
    }

    public String getName() {
        String result = this.pathName.substring(this.pathName.lastIndexOf(File.separator) + 1);
        return result;
    }

    public String getPathName() {
        return this.pathName;
    }

    public int getTopologyLevel() {
        return this.topologyLevel;
    }

    public String toString() {
        return "VPF Coverage " + this.getName() + ". " + this.description + "\n" + "Topology level " + this.topologyLevel;
    }
}

