/*
 * Decompiled with CFR 0.152.
 */
package net.opengis.cat.csw20;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ElementSetType implements Enumerator
{
    BRIEF(0, "brief", "brief"),
    SUMMARY(1, "summary", "summary"),
    FULL(2, "full", "full");

    public static final int BRIEF_VALUE = 0;
    public static final int SUMMARY_VALUE = 1;
    public static final int FULL_VALUE = 2;
    private static final ElementSetType[] VALUES_ARRAY;
    public static final List<ElementSetType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static ElementSetType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ElementSetType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static ElementSetType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ElementSetType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ElementSetType get(int value) {
        switch (value) {
            case 0: {
                return BRIEF;
            }
            case 1: {
                return SUMMARY;
            }
            case 2: {
                return FULL;
            }
        }
        return null;
    }

    private ElementSetType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new ElementSetType[]{BRIEF, SUMMARY, FULL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

