/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.data.view;

import java.util.ArrayList;
import java.util.Map;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.CaseExpression;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.InverseExpression;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.WhenClause;
import net.sf.jsqlparser.expression.operators.arithmetic.Addition;
import net.sf.jsqlparser.expression.operators.arithmetic.Division;
import net.sf.jsqlparser.expression.operators.arithmetic.Multiplication;
import net.sf.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.SubSelect;
import org.geotools.arcsde.data.view.ColumnQualifier;
import org.geotools.arcsde.data.view.ItemsListQualifier;
import org.geotools.arcsde.data.view.SubSelectQualifier;
import org.geotools.arcsde.session.ISession;

class ExpressionQualifier
implements ExpressionVisitor {
    private Expression _qualifiedExpression;
    private ISession session;
    private Map<String, Object> tableAliases;

    private ExpressionQualifier(ISession session, Map<String, Object> tableAliases) {
        this.session = session;
        this.tableAliases = tableAliases;
    }

    public static Expression qualify(ISession session, Map<String, Object> tableAliases, Expression exp) {
        if (exp == null) {
            return null;
        }
        ExpressionQualifier qualifier = new ExpressionQualifier(session, tableAliases);
        exp.accept((ExpressionVisitor)qualifier);
        return qualifier._qualifiedExpression;
    }

    public void visit(NullValue nullValue) {
        this._qualifiedExpression = nullValue;
    }

    public void visit(Function function) {
        Function qfunction = new Function();
        qfunction.setAllColumns(function.isAllColumns());
        qfunction.setEscaped(function.isEscaped());
        qfunction.setName(function.getName());
        ExpressionList parameters = function.getParameters();
        ExpressionList qualifiedParams = (ExpressionList)ItemsListQualifier.qualify(this.session, this.tableAliases, (ItemsList)parameters);
        qfunction.setParameters(qualifiedParams);
        this._qualifiedExpression = qfunction;
    }

    public void visit(InverseExpression inverseExpression) {
        InverseExpression qInv = new InverseExpression();
        Expression exp = inverseExpression.getExpression();
        Expression qExp = ExpressionQualifier.qualify(this.session, this.tableAliases, exp);
        qInv.setExpression(qExp);
        this._qualifiedExpression = qInv;
    }

    public void visit(JdbcParameter jdbcParameter) {
        this._qualifiedExpression = jdbcParameter;
    }

    public void visit(DoubleValue doubleValue) {
        this._qualifiedExpression = doubleValue;
    }

    public void visit(LongValue longValue) {
        this._qualifiedExpression = longValue;
    }

    public void visit(DateValue dateValue) {
        this._qualifiedExpression = dateValue;
    }

    public void visit(TimeValue timeValue) {
        this._qualifiedExpression = timeValue;
    }

    public void visit(TimestampValue timestampValue) {
        this._qualifiedExpression = timestampValue;
    }

    public void visit(Parenthesis parenthesis) {
        Expression pExp = parenthesis.getExpression();
        Expression qualifiedExpression = ExpressionQualifier.qualify(this.session, this.tableAliases, pExp);
        Parenthesis qualified = new Parenthesis();
        qualified.setExpression(qualifiedExpression);
        this._qualifiedExpression = qualified;
    }

    public void visit(StringValue stringValue) {
        this._qualifiedExpression = stringValue;
    }

    private void visitBinaryExpression(BinaryExpression exp) {
        Addition qualified;
        Expression left = ExpressionQualifier.qualify(this.session, this.tableAliases, exp.getLeftExpression());
        Expression right = ExpressionQualifier.qualify(this.session, this.tableAliases, exp.getRightExpression());
        if (exp instanceof Addition) {
            qualified = new Addition();
        } else if (exp instanceof Division) {
            qualified = new Division();
        } else if (exp instanceof Multiplication) {
            qualified = new Multiplication();
        } else if (exp instanceof Subtraction) {
            qualified = new Subtraction();
        } else if (exp instanceof EqualsTo) {
            qualified = new EqualsTo();
        } else if (exp instanceof GreaterThan) {
            qualified = new GreaterThan();
        } else if (exp instanceof GreaterThanEquals) {
            qualified = new GreaterThanEquals();
        } else if (exp instanceof LikeExpression) {
            qualified = new LikeExpression();
        } else if (exp instanceof MinorThan) {
            qualified = new MinorThan();
        } else if (exp instanceof MinorThanEquals) {
            qualified = new MinorThanEquals();
        } else if (exp instanceof NotEqualsTo) {
            qualified = new NotEqualsTo();
        } else {
            throw new IllegalArgumentException("Unknown binary expression: " + exp);
        }
        qualified.setLeftExpression(left);
        qualified.setRightExpression(right);
        this._qualifiedExpression = qualified;
    }

    public void visit(Addition addition) {
        this.visitBinaryExpression((BinaryExpression)addition);
    }

    public void visit(Division division) {
        this.visitBinaryExpression((BinaryExpression)division);
    }

    public void visit(Multiplication multiplication) {
        this.visitBinaryExpression((BinaryExpression)multiplication);
    }

    public void visit(Subtraction subtraction) {
        this.visitBinaryExpression((BinaryExpression)subtraction);
    }

    public void visit(AndExpression andExpression) {
        Expression left = ExpressionQualifier.qualify(this.session, this.tableAliases, andExpression.getLeftExpression());
        Expression rigth = ExpressionQualifier.qualify(this.session, this.tableAliases, andExpression.getRightExpression());
        AndExpression and = new AndExpression(left, rigth);
        this._qualifiedExpression = and;
    }

    public void visit(OrExpression orExpression) {
        Expression left = ExpressionQualifier.qualify(this.session, this.tableAliases, orExpression.getLeftExpression());
        Expression rigth = ExpressionQualifier.qualify(this.session, this.tableAliases, orExpression.getRightExpression());
        OrExpression or = new OrExpression(left, rigth);
        this._qualifiedExpression = or;
    }

    public void visit(Between between) {
        Between qualified = new Between();
        Expression start = ExpressionQualifier.qualify(this.session, this.tableAliases, between.getBetweenExpressionStart());
        Expression end = ExpressionQualifier.qualify(this.session, this.tableAliases, between.getBetweenExpressionEnd());
        Expression left = ExpressionQualifier.qualify(this.session, this.tableAliases, between.getLeftExpression());
        qualified.setBetweenExpressionStart(start);
        qualified.setBetweenExpressionEnd(end);
        qualified.setLeftExpression(left);
        this._qualifiedExpression = qualified;
    }

    public void visit(EqualsTo equalsTo) {
        this.visitBinaryExpression((BinaryExpression)equalsTo);
    }

    public void visit(GreaterThan greaterThan) {
        this.visitBinaryExpression((BinaryExpression)greaterThan);
    }

    public void visit(GreaterThanEquals greaterThanEquals) {
        this.visitBinaryExpression((BinaryExpression)greaterThanEquals);
    }

    public void visit(InExpression inExpression) {
        Expression left = ExpressionQualifier.qualify(this.session, this.tableAliases, inExpression.getLeftExpression());
        ItemsList itemsList = ItemsListQualifier.qualify(this.session, this.tableAliases, inExpression.getItemsList());
        InExpression qualified = new InExpression();
        qualified.setLeftExpression(left);
        qualified.setItemsList(itemsList);
        this._qualifiedExpression = qualified;
    }

    public void visit(IsNullExpression isNullExpression) {
        IsNullExpression qualified = new IsNullExpression();
        Expression left = ExpressionQualifier.qualify(this.session, this.tableAliases, isNullExpression.getLeftExpression());
        qualified.setLeftExpression(left);
        qualified.setNot(isNullExpression.isNot());
        this._qualifiedExpression = qualified;
    }

    public void visit(LikeExpression likeExpression) {
        this.visitBinaryExpression((BinaryExpression)likeExpression);
    }

    public void visit(MinorThan minorThan) {
        this.visitBinaryExpression((BinaryExpression)minorThan);
    }

    public void visit(MinorThanEquals minorThanEquals) {
        this.visitBinaryExpression((BinaryExpression)minorThanEquals);
    }

    public void visit(NotEqualsTo notEqualsTo) {
        this.visitBinaryExpression((BinaryExpression)notEqualsTo);
    }

    public void visit(Column tableColumn) {
        Column qualified = ColumnQualifier.qualify(this.session, this.tableAliases, tableColumn);
        this._qualifiedExpression = qualified;
    }

    public void visit(SubSelect subSelect) {
        SubSelect qualified = SubSelectQualifier.qualify(this.session, subSelect);
        this._qualifiedExpression = qualified;
    }

    public void visit(CaseExpression caseExpression) {
        Expression switchExpr = ExpressionQualifier.qualify(this.session, this.tableAliases, caseExpression.getSwitchExpression());
        Expression elseExpr = ExpressionQualifier.qualify(this.session, this.tableAliases, caseExpression.getElseExpression());
        ArrayList<WhenClause> whenClauses = null;
        if (caseExpression.getWhenClauses() != null) {
            whenClauses = new ArrayList<WhenClause>();
            for (WhenClause whenClause : caseExpression.getWhenClauses()) {
                WhenClause qWhen = (WhenClause)ExpressionQualifier.qualify(this.session, this.tableAliases, (Expression)whenClause);
                whenClauses.add(qWhen);
            }
        }
        CaseExpression qualifiedWhen = new CaseExpression();
        qualifiedWhen.setElseExpression(elseExpr);
        qualifiedWhen.setSwitchExpression(switchExpr);
        qualifiedWhen.setWhenClauses(whenClauses);
        this._qualifiedExpression = qualifiedWhen;
    }

    public void visit(WhenClause whenClause) {
        Expression whenExpr = ExpressionQualifier.qualify(this.session, this.tableAliases, whenClause.getWhenExpression());
        Expression thenExpr = ExpressionQualifier.qualify(this.session, this.tableAliases, whenClause.getThenExpression());
        WhenClause q = new WhenClause();
        q.setWhenExpression(whenExpr);
        q.setThenExpression(thenExpr);
        this._qualifiedExpression = q;
    }
}

