/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.data;

import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeObjectId;
import com.esri.sde.sdk.client.SeState;
import com.esri.sde.sdk.client.SeVersion;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.arcsde.data.ArcSDEDataStore;
import org.geotools.arcsde.session.Command;
import org.geotools.arcsde.session.ISession;
import org.geotools.arcsde.versioning.ArcSdeVersionHandler;
import org.geotools.arcsde.versioning.TransactionVersionHandler;
import org.geotools.data.FeatureListenerManager;
import org.geotools.data.Transaction;
import org.geotools.util.logging.Logging;

final class ArcTransactionState
implements Transaction.State {
    private static final Logger LOGGER = Logging.getLogger((String)ArcTransactionState.class.getName());
    private ArcSDEDataStore dataStore;
    private Transaction transaction;
    private final FeatureListenerManager listenerManager;
    private final Set<String> typesChanged = new HashSet<String>();
    public SeState currentVersionState;
    public SeObjectId initialStateId;
    public SeVersion defaultVersion;
    private ArcSdeVersionHandler versionHandler = ArcSdeVersionHandler.NONVERSIONED_HANDLER;

    ArcTransactionState(ArcSDEDataStore dataStore, FeatureListenerManager listenerManager) {
        this.dataStore = dataStore;
        this.listenerManager = listenerManager;
    }

    private void setupVersioningHandling(String versionName) throws IOException {
        if (this.versionHandler == ArcSdeVersionHandler.NONVERSIONED_HANDLER) {
            ISession session = this.getConnection();
            this.versionHandler = new TransactionVersionHandler(session, versionName);
        }
    }

    public ArcSdeVersionHandler getVersionHandler(boolean ftIsVersioned, String versionName) throws IOException {
        if (ftIsVersioned) {
            this.setupVersioningHandling(versionName);
        }
        return this.versionHandler;
    }

    public void addChange(String typeName) {
        this.typesChanged.add(typeName);
    }

    public void commit() throws IOException {
        this.failIfClosed();
        ISession session = this.getConnection();
        Command<Void> commitCommand = new Command<Void>(){

            @Override
            public Void execute(ISession session, SeConnection connection) throws SeException, IOException {
                try {
                    if (ArcTransactionState.this.currentVersionState != null) {
                        SeObjectId parentStateId = ArcTransactionState.this.initialStateId;
                        ArcTransactionState.this.defaultVersion.changeState(ArcTransactionState.this.currentVersionState.getId());
                        ArcTransactionState.this.currentVersionState.trimTree(parentStateId, ArcTransactionState.this.currentVersionState.getId());
                    }
                }
                catch (SeException se) {
                    LOGGER.log(Level.WARNING, se.getMessage(), se);
                    ArcTransactionState.this.close();
                    throw se;
                }
                return null;
            }
        };
        try {
            session.issue(commitCommand);
            this.fireChanges(true);
            this.versionHandler.commitEditState();
        }
        catch (IOException e) {
            this.versionHandler.rollbackEditState();
            throw e;
        }
    }

    public void rollback() throws IOException {
        this.failIfClosed();
        try {
            this.versionHandler.rollbackEditState();
            this.fireChanges(false);
        }
        catch (IOException se) {
            this.close();
            LOGGER.log(Level.WARNING, se.getMessage(), se);
            throw se;
        }
    }

    private void fireChanges(boolean commit) {
        for (String typeName : this.typesChanged) {
            this.listenerManager.fireChanged(typeName, this.transaction, commit);
        }
        this.typesChanged.clear();
    }

    public void addAuthorization(String authId) {
    }

    public void setTransaction(Transaction transaction) {
        if (Transaction.AUTO_COMMIT.equals(transaction)) {
            throw new IllegalArgumentException("Cannot use Transaction.AUTO_COMMIT here");
        }
        if (transaction == null) {
            this.close();
        } else if (this.transaction != null) {
            throw new IllegalStateException("Once a transaction is set, it is illegal to call Transaction.State.setTransaction with anything other than null: " + transaction);
        }
        this.transaction = transaction;
    }

    private void failIfClosed() throws IllegalStateException {
        if (this.dataStore == null) {
            throw new IllegalStateException("This transaction state has already been closed");
        }
    }

    private void close() {
        if (this.dataStore == null) {
            return;
        }
        this.dataStore = null;
    }

    ISession getConnection() throws IOException {
        this.failIfClosed();
        return this.dataStore.getSession(this.transaction);
    }

    public Transaction getTransaction() {
        return this.transaction;
    }
}

